/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import maslab.telemetry.JugHub;
import maslab.telemetry.JugMessageListener;
import maslab.telemetry.JugPacket;
import maslab.telemetry.MTQueue;
import maslab.telemetry.StatusEvent;
import maslab.telemetry.StatusListener;
import maslab.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JugClient {
    ArrayList<StatusListener> statusListeners = new ArrayList();
    boolean connectionState = false;
    MTQueue<JugPacket> outqueue = new MTQueue();
    HashMap<String, Channel> channels = new HashMap();
    LinkedList<String> advertisements = new LinkedList();
    protected Logger log = new Logger("JugClient");
    MonitorThread monitorthread;

    public JugClient() {
        try {
            this.monitorthread = new MonitorThread(InetAddress.getByName("127.0.0.1"), 7780);
            this.monitorthread.setDaemon(true);
            this.monitorthread.start();
        }
        catch (UnknownHostException ex) {
            this.log.error("Can't connect to localhost: " + ex);
        }
    }

    public JugClient(InetAddress addr, int port) throws IOException {
        this.monitorthread = new MonitorThread(addr, port);
        this.monitorthread.setDaemon(true);
        this.monitorthread.start();
    }

    public synchronized void reconnect(InetAddress addr, int port) throws IOException {
        this.monitorthread.threadquit = true;
        if (this.monitorthread.sock != null) {
            this.monitorthread.sock.close();
        }
        try {
            this.monitorthread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.monitorthread = new MonitorThread(addr, port);
        this.monitorthread.setDaemon(true);
        this.monitorthread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener listener) {
        ArrayList<StatusListener> arrayList = this.statusListeners;
        synchronized (arrayList) {
            this.statusListeners.add(listener);
        }
        StatusEvent e = new StatusEvent(this);
        e.name = "connected";
        e.booleanValue = this.connectionState;
        listener.statusChanged(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener listener) {
        ArrayList<StatusListener> arrayList = this.statusListeners;
        synchronized (arrayList) {
            this.statusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getChannels() {
        ArrayList<String> al = new ArrayList<String>();
        HashMap<String, Channel> hashMap = this.channels;
        synchronized (hashMap) {
            Iterator<String> i = this.channels.keySet().iterator();
            while (i.hasNext()) {
                Channel c = this.getChannel(i.next());
                if (!c.advertised) continue;
                al.add(c.name);
            }
        }
        return al;
    }

    Channel getChannel(String cname) {
        Channel c = this.channels.get(cname);
        if (c == null) {
            c = new Channel(cname);
            this.channels.put(cname, c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void subscribe(String cname, JugMessageListener listener) {
        Channel c = this.getChannel(cname);
        LinkedList<JugMessageListener> linkedList = c.listeners;
        synchronized (linkedList) {
            c.listeners.add(listener);
            if (c.listeners.size() == 1) {
                JugPacket p = new JugPacket(6, cname);
                this.outqueue.put(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribe(String cname, JugMessageListener listener) {
        Channel c = this.getChannel(cname);
        LinkedList<JugMessageListener> linkedList = c.listeners;
        synchronized (linkedList) {
            c.listeners.remove(listener);
            if (c.listeners.size() == 0) {
                JugPacket p = new JugPacket(7, cname);
                this.outqueue.put(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void advertise(String channel) {
        JugPacket p = new JugPacket(1, channel);
        LinkedList<String> linkedList = this.advertisements;
        synchronized (linkedList) {
            if (!this.advertisements.contains(channel)) {
                this.advertisements.add(channel);
                this.outqueue.put(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unadvertise(String channel) {
        JugPacket p = new JugPacket(2, channel);
        LinkedList<String> linkedList = this.advertisements;
        synchronized (linkedList) {
            if (this.advertisements.contains(channel)) {
                this.advertisements.remove(channel);
                this.outqueue.put(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String channel, byte[] data) {
        Channel c;
        if (!this.monitorthread.isConnected) {
            return;
        }
        Channel channel2 = c = this.getChannel(channel);
        synchronized (channel2) {
            if (c.numsubscribers > 0) {
                JugPacket p = new JugPacket(3, channel, data);
                if (JugHub.localJugHub != null) {
                    JugHub.localJugHub.directReceive(p);
                    return;
                }
                this.outqueue.put(p);
            }
        }
    }

    public void setMaximumQueueSize(String channel, int size) {
        Channel c = this.getChannel(channel);
        c.queueLimit = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayQueueSizes() {
        HashMap<String, Channel> hashMap = this.channels;
        synchronized (hashMap) {
            for (Channel c : this.channels.values()) {
                System.out.println(c.name + "  " + c.queueBytes + "  " + c.queueLimit);
            }
        }
    }

    public boolean publishing(String channel) {
        if (!this.monitorthread.isConnected) {
            return false;
        }
        Channel c = this.getChannel(channel);
        return c.numsubscribers > 0;
    }

    protected void receivedPacket(JugPacket p) {
        DataInputStream dins = null;
        Channel c = null;
        switch (p.command) {
            case 101: {
                c = this.getChannel(p.channelName);
                c.advertised = true;
                this.notifyListeners("newchannel", true);
                break;
            }
            case 102: {
                c = this.getChannel(p.channelName);
                c.advertised = false;
                this.notifyListeners("newchannel", true);
                break;
            }
            case 103: {
                this.receivedMessage(p.channelName, p.data);
                break;
            }
            case 110: {
                try {
                    dins = p.getDataInputStream();
                    c = this.getChannel(p.channelName);
                    c.numsubscribers = dins.readInt();
                }
                catch (Exception ex) {
                    this.log.warn("unexpected exception", ex);
                }
                break;
            }
            default: {
                this.log.warn("unknown packet type " + p.command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivedMessage(String channel, byte[] data) {
        Channel c = this.getChannel(channel);
        LinkedList<JugMessageListener> linkedList = c.listeners;
        synchronized (linkedList) {
            if (c.listeners.size() == 0) {
                this.log.warn("got a message for channel " + channel + " but there are no subscribers.");
                return;
            }
            for (JugMessageListener ml : c.listeners) {
                ml.messageReceived(channel, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(String name, boolean value) {
        StatusEvent e = new StatusEvent(this);
        e.name = name;
        e.booleanValue = value;
        ArrayList<StatusListener> arrayList = this.statusListeners;
        synchronized (arrayList) {
            for (StatusListener sl : this.statusListeners) {
                sl.statusChanged(e);
            }
        }
    }

    protected class MonitorThread
    extends Thread {
        InetAddress hubaddr;
        int hubport;
        Socket sock;
        boolean threadquit = false;
        JugPacket EXIT = new JugPacket(0);
        boolean isConnected = false;

        public MonitorThread(InetAddress hubaddr, int hubport) {
            this.hubaddr = hubaddr;
            this.hubport = hubport;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.threadquit) {
                Thread reader = null;
                Thread writer = null;
                try {
                    this.sock = new Socket(this.hubaddr, this.hubport);
                    writer = new WriterThread();
                    writer.setDaemon(true);
                    writer.start();
                    reader = new ReaderThread();
                    reader.setDaemon(true);
                    reader.start();
                    this.isConnected = true;
                    Cloneable cloneable = JugClient.this.channels;
                    synchronized (cloneable) {
                        for (Channel c : JugClient.this.channels.values()) {
                            LinkedList<JugMessageListener> linkedList = c.listeners;
                            synchronized (linkedList) {
                                if (c.listeners.size() > 0) {
                                    JugPacket p = new JugPacket(6, c.name);
                                    JugClient.this.outqueue.put(p);
                                }
                            }
                        }
                    }
                    cloneable = JugClient.this.advertisements;
                    synchronized (cloneable) {
                        for (String cname : JugClient.this.advertisements) {
                            JugPacket p = new JugPacket(1, cname);
                            JugClient.this.outqueue.put(p);
                        }
                    }
                    JugClient.this.notifyListeners("connected", true);
                    JugClient.this.connectionState = true;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    if (writer != null) {
                        writer.join();
                    }
                    if (reader != null) {
                        reader.join();
                    }
                }
                catch (InterruptedException ex) {
                    JugClient.this.log.warn("unable to join threads", ex);
                }
                this.isConnected = false;
                if (JugClient.this.connectionState) {
                    JugClient.this.notifyListeners("connected", false);
                    JugClient.this.log.verbose("lost connection to hub");
                    JugClient.this.connectionState = false;
                }
                for (Channel c : JugClient.this.channels.values()) {
                    c.advertised = false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
        }

        protected class ReaderThread
        extends Thread {
            DataInputStream ins;

            public ReaderThread() throws IOException {
                this.setDaemon(true);
                this.ins = new DataInputStream(new BufferedInputStream(MonitorThread.this.sock.getInputStream()));
            }

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            JugPacket p = new JugPacket(this.ins);
                            JugClient.this.receivedPacket(p);
                        }
                    }
                    catch (IOException ex) {
                        JugClient.this.log.log(4, "lost connection", ex);
                    }
                    catch (Exception ex) {
                        JugClient.this.log.log(2, "Unexpected exception " + ex, ex);
                        ex.printStackTrace(System.out);
                        continue;
                    }
                    break;
                }
                JugClient.this.outqueue.put(MonitorThread.this.EXIT);
            }
        }

        protected class WriterThread
        extends Thread {
            DataOutputStream outs;

            public WriterThread() throws IOException {
                this.setDaemon(true);
                this.outs = new DataOutputStream(new BufferedOutputStream(MonitorThread.this.sock.getOutputStream()));
            }

            public void run() {
                JugPacket o;
                while ((o = JugClient.this.outqueue.getBlock()) != MonitorThread.this.EXIT) {
                    try {
                        if (o instanceof byte[]) {
                            this.outs.write((byte[])o);
                        } else if (o instanceof String) {
                            this.outs.writeBytes((String)((Object)o));
                        } else if (o instanceof JugPacket) {
                            JugPacket p = o;
                            p.write(this.outs);
                            if (p.command == 3) {
                                Channel channel = JugClient.this.getChannel(p.channelName);
                            }
                        } else {
                            JugClient.this.log.error("Unknown type " + o.getClass().getName());
                        }
                        JugClient.this.log.vverbose("wrote packet");
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
            }
        }
    }

    class Channel {
        String name;
        LinkedList<JugMessageListener> listeners;
        int numsubscribers;
        int queueBytes;
        int queueLimit = -1;
        boolean advertised = false;

        public Channel(String name) {
            this.name = name;
            this.listeners = new LinkedList();
            this.numsubscribers = 0;
        }
    }
}

