/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.botclient;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HueSaturationPlot
extends JPanel {
    BufferedImage wheel;
    int wheelRadius;
    int pointSize;
    HashSet<Point> points;
    static final long serialVersionUID = 1001L;

    public HueSaturationPlot(int wheelRadius, int pointSize) {
        this.wheelRadius = wheelRadius;
        this.pointSize = pointSize;
        this.wheel = this.generateColorWheel(wheelRadius);
        this.setSize(wheelRadius * 2, wheelRadius * 2);
        this.setPreferredSize(new Dimension(wheelRadius * 2, wheelRadius * 2));
        this.points = new HashSet();
    }

    public static void main(String[] args) {
        JFrame foo = new JFrame();
        HueSaturationPlot hsp = new HueSaturationPlot(150, 3);
        foo.getContentPane().add(hsp);
        foo.pack();
        foo.setVisible(true);
        hsp.plotPoint(Color.RED);
        hsp.plotPoint(Color.BLUE);
        hsp.plotPoint(Color.WHITE);
    }

    public void paint(Graphics g) {
        g.drawImage(this.wheel, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight(), null);
        for (Point p : this.points) {
            int x = (int)((double)(p.saturation * (float)this.wheelRadius) * Math.cos((double)(p.hue * 2.0f) * Math.PI)) + this.wheelRadius;
            int y = (int)((double)(p.saturation * (float)this.wheelRadius) * Math.sin((double)(p.hue * 2.0f) * Math.PI)) + this.wheelRadius;
            g.setColor(Color.WHITE);
            g.fillOval(x - this.pointSize, y - this.pointSize, this.pointSize * 2, this.pointSize * 2);
            g.setColor(Color.BLACK);
            g.drawOval(x - this.pointSize, y - this.pointSize, this.pointSize * 2, this.pointSize * 2);
        }
    }

    BufferedImage generateColorWheel(int radius) {
        BufferedImage wheel = new BufferedImage(radius * 2, radius * 2, 1);
        Graphics g = wheel.getGraphics();
        int[] dout = new int[radius * radius * 4];
        int index = 0;
        for (int y = -radius; y < radius; ++y) {
            for (int x = -radius; x < radius; ++x) {
                double saturation = Math.sqrt(x * x + y * y) / (double)radius;
                double hue = Math.atan2(y, x) / (Math.PI * 2);
                double value = saturation > 1.0 ? 0.0 : 1.0;
                dout[index++] = Color.HSBtoRGB((float)hue, (float)saturation, (float)value);
            }
        }
        wheel.setRGB(0, 0, 2 * radius, 2 * radius, dout, 0, 2 * radius);
        return wheel;
    }

    public void plotPoint(Color c) {
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.points.add(new Point(hsv[0], hsv[1]));
        this.repaint();
    }

    class Point {
        public float hue;
        public float saturation;

        public Point(float h, float s) {
            this.hue = h;
            this.saturation = s;
        }
    }
}

