/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;
import org.orcboard.orcspy.WaveformSettings;
import org.orcboard.orcspy.WaveformSource;

public class QuadPhase
implements WaveformSource {
    Orc orc;
    int port;
    long lastCount = 0L;
    boolean reverse;

    public QuadPhase(Orc orc, int port) {
        this(orc, port, false);
    }

    public QuadPhase(Orc orc, int port, boolean reverse) {
        this.orc = orc;
        this.port = port;
        this.reverse = reverse;
    }

    public Reading read() {
        Reading r = new Reading();
        byte[] resp = this.orc.doTransactionRetry(new byte[]{2, (byte)this.port});
        r.count = Orc.get16u(resp, 1);
        r.vel = Orc.get16s(resp, 3);
        r.accel = Orc.get16s(resp, 5);
        if (this.reverse) {
            r.count *= -1;
            r.vel *= -1;
            r.accel *= -1;
        }
        r.count = this.reverse ? -r.count : r.count;
        return r;
    }

    public int readCount() {
        return this.read().count;
    }

    public int deltaCount() {
        long thisCount = this.readCount();
        int deltaCount = Orc.diff16(thisCount, this.lastCount);
        this.lastCount = thisCount;
        return deltaCount;
    }

    public int readVelocity() {
        byte[] resp = this.orc.doTransactionRetry(new byte[]{2, (byte)this.port});
        int pos = Orc.get16u(resp, 1);
        int vel = Orc.get16s(resp, 3);
        return this.reverse ? -vel : vel;
    }

    public double getWaveformSample() {
        return this.readCount();
    }

    public WaveformSettings getDefaultWaveformSettings() {
        return new WaveformSettings("QuadPhase " + this.port, "ticks", 0.0, 65535.0, 0.5);
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        QuadPhase qp = new QuadPhase(orc, 0);
        while (true) {
            System.out.println(String.format("%8d %8d", qp.readCount(), qp.deltaCount()));
        }
    }

    public static class Reading {
        public int count;
        public int vel;
        public int accel;
    }
}

