/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orcspy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.orcboard.orc.AnalogInput;
import org.orcboard.orc.Gyro;
import org.orcboard.orc.Orc;
import org.orcboard.orc.OrcListener;
import org.orcboard.orcspy.Oscilloscope;
import org.orcboard.orcspy.View;
import org.orcboard.util.ParameterGUI;
import org.orcboard.util.ParameterListener;

public class GyroView
extends JInternalFrame
implements View,
OrcListener,
ParameterListener {
    Orc orc;
    CompassWidget compass;
    Oscilloscope osc;
    Gyro gyro;
    ParameterGUI pg = new ParameterGUI();

    public GyroView(Orc orc) {
        super("Gyro", true, true);
        this.orc = orc;
        this.pg.addInt("port", "Analog port", 7);
        this.pg.addDouble("calibtime", "Calibration Time", 5.0);
        this.pg.addButtons("commands", "commands", new String[]{"Calibrate", "Reset"});
        this.setLayout(new BorderLayout());
        this.setupPort();
        this.compass = new CompassWidget();
        this.add((Component)this.compass, "East");
        this.add((Component)this.pg.getPanel(), "South");
        this.pg.addListener(this);
        this.setSize(400, 300);
        this.setVisible(true);
        orc.addListener(this);
        new UpdateThread().start();
    }

    public JInternalFrame getComponent() {
        return this;
    }

    void setupPort() {
        int port = this.pg.gi("port");
        if (this.osc != null) {
            this.remove(this.osc);
        }
        this.gyro = new Gyro(this.orc, port);
        this.gyro.reset();
        this.gyro.beginCalibration(this.pg.gd("calibtime"));
        this.osc = new Oscilloscope();
        this.osc.addWaveform(new AnalogInput(this.orc, port));
        this.osc.addWaveform(this.gyro);
        this.add((Component)this.osc, "Center");
        this.repaint();
    }

    public void parameterChanged(String name) {
        if (name.equals("Calibrate")) {
            this.gyro.reset();
            this.gyro.beginCalibration(this.pg.gd("calibtime"));
            return;
        }
        if (name.equals("Reset")) {
            this.gyro.reset();
            return;
        }
        if (this.pg.gi("port") != this.gyro.port) {
            this.setupPort();
        }
    }

    void update() {
        double angle = this.gyro.read();
        this.compass.theta = angle * Math.PI / 180.0;
        this.repaint();
    }

    public void orcReset() {
    }

    public void orcHeartBeat(double orcTime) {
    }

    public void orcPadEvent(int switches, int joyx, int joyy) {
        this.compass.repaint();
    }

    public void orcPadConnected() {
    }

    public void orcPadDisconnected() {
    }

    class CompassWidget
    extends JComponent {
        public static final long serialVersionUID = 1001L;
        double theta;

        CompassWidget() {
        }

        public void setTheta(double theta) {
            this.theta = theta;
            this.repaint();
        }

        public Dimension getMaximumSize() {
            return new Dimension(100, 100);
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, 60);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public synchronized void paint(Graphics gin) {
            int headlength;
            Graphics2D g = (Graphics2D)gin;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getWidth();
            int height = this.getHeight();
            int cx = width / 2;
            int cy = height / 2;
            int diam = width < height ? width : height;
            g.translate(cx, cy);
            g.setColor(Color.black);
            g.fillOval(-diam / 2, -diam / 2, diam, diam);
            g.setColor(Color.darkGray);
            g.drawLine(-diam / 2, 0, diam / 2, 0);
            g.drawLine(0, -diam / 2, 0, diam / 2);
            g.rotate(-this.theta);
            g.setColor(Color.white);
            int arrowlength = (int)Math.min((double)diam * 0.9, (double)(diam - 2));
            int arrowthick = (int)Math.min((double)diam * 0.1, 5.0);
            int headheight = headlength = Math.min(diam / 3 - 1, 20);
            Rectangle2D.Double rect = new Rectangle2D.Double(-arrowlength / 2, -arrowthick / 2, arrowlength - headlength + 1, arrowthick);
            g.fill(rect);
            g.setColor(Color.blue);
            Polygon p = new Polygon();
            p.addPoint(arrowlength / 2, 0);
            p.addPoint(arrowlength / 2 - headlength, headheight / 2);
            p.addPoint(arrowlength / 2 - headlength, -headheight / 2);
            g.fill(p);
        }
    }

    class UpdateThread
    extends Thread {
        public UpdateThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                if (GyroView.this.isVisible()) {
                    GyroView.this.update();
                }
                Orc.safesleep(500);
            }
        }
    }
}

