/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orcspy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.orcboard.orc.Orc;
import org.orcboard.orc.OrcListener;
import org.orcboard.orcspy.View;
import org.orcboard.util.JImage;

public class PadView
extends JInternalFrame
implements View,
OrcListener {
    JImage jimage = new JImage();
    Orc orc;
    JoystickCircle joycircle;

    public PadView(Orc orc) {
        super("OrcPad", true, true);
        this.orc = orc;
        this.setLayout(new BorderLayout());
        this.jimage.setImage(new BufferedImage(128, 64, 10));
        this.add((Component)this.jimage, "Center");
        this.joycircle = new JoystickCircle();
        this.add((Component)this.joycircle, "East");
        this.pack();
        this.setVisible(true);
        orc.addListener(this);
        new UpdateThread().start();
    }

    public JInternalFrame getComponent() {
        return this;
    }

    void update() {
        BufferedImage im = this.orc.lcdReadImage();
        this.jimage.setImage(im);
        this.repaint();
    }

    public void orcReset() {
    }

    public void orcHeartBeat(double orcTime) {
    }

    public void orcPadEvent(int switches, int joyx, int joyy) {
        this.joycircle.repaint();
    }

    public void orcPadConnected() {
    }

    public void orcPadDisconnected() {
    }

    class JoystickCircle
    extends JComponent {
        public static final long serialVersionUID = 1001L;

        JoystickCircle() {
        }

        public void paint(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            int cx = width / 2;
            int cy = height / 2;
            int diam = width < height ? width : height;
            int joyx = (int)((double)(-diam / 2) * PadView.this.orc.joyX());
            int joyy = (int)((double)(-diam / 2) * PadView.this.orc.joyY());
            g.setColor(Color.black);
            g.fillOval(cx - diam / 2, cy - diam / 2, diam, diam);
            g.setColor(Color.yellow);
            int knobsize = 8;
            g.fillOval(cx - joyx - knobsize / 2, cy - joyy - knobsize / 2, knobsize, knobsize);
        }

        public Dimension getMaximumSize() {
            return new Dimension(100, 100);
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, 60);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    class UpdateThread
    extends Thread {
        public UpdateThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                if (PadView.this.isVisible()) {
                    PadView.this.update();
                }
                Orc.safesleep(500);
            }
        }
    }
}

