/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;

public class ADIS16350 {
    Orc orc;
    int maxclk = 100000;
    int spo = 1;
    int sph = 1;
    int nbits = 16;

    public ADIS16350(Orc orc) {
        this.orc = orc;
    }

    int readRegister(int addr) {
        int[] v = this.orc.spiTransaction(this.maxclk, this.spo, this.sph, this.nbits, new int[]{addr << 8});
        v = this.orc.spiTransaction(this.maxclk, this.spo, this.sph, this.nbits, new int[]{addr << 8});
        return v[v.length - 1];
    }

    static int convert14(int v) {
        if (((v &= 0x3FFF) & 0x2000) > 0) {
            v |= 0xFFFFC000;
        }
        return v;
    }

    static int convert12(int v) {
        if (((v &= 0xFFF) & 0x800) > 0) {
            v |= 0xFFFFF000;
        }
        return v;
    }

    void writeRegister(int addr) {
        int[] v = this.orc.spiTransaction(this.maxclk, this.spo, this.sph, this.nbits, new int[]{(addr | 0x80) << 8, 0});
    }

    public double[] readState() {
        double[] x = new double[]{(double)ADIS16350.convert12(this.readRegister(2)) * 0.0018315, Math.toRadians((double)ADIS16350.convert14(this.readRegister(4)) * 0.07326), Math.toRadians((double)ADIS16350.convert14(this.readRegister(6)) * 0.07326), Math.toRadians((double)ADIS16350.convert14(this.readRegister(8)) * 0.07326), (double)ADIS16350.convert14(this.readRegister(10)) * 0.002522, (double)ADIS16350.convert14(this.readRegister(12)) * 0.002522, (double)ADIS16350.convert14(this.readRegister(14)) * 0.002522, (double)ADIS16350.convert12(this.readRegister(16)) * 0.1453 + 25.0, (double)ADIS16350.convert12(this.readRegister(18)) * 0.1453 + 25.0, (double)ADIS16350.convert12(this.readRegister(20)) * 0.1453 + 25.0, (double)ADIS16350.convert12(this.readRegister(22)) * 6.105E-4};
        return x;
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        ADIS16350 adis = new ADIS16350(orc);
        double zpos = 0.0;
        long lastTime = System.currentTimeMillis();
        while (true) {
            System.out.printf("%20.5f ", (double)System.currentTimeMillis() / 1000.0);
            double[] state = adis.readState();
            for (int i = 0; i < state.length; ++i) {
                System.out.printf("%15f", state[i]);
            }
            System.out.printf("\n", new Object[0]);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ex) {
            }
        }
    }
}

