/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.io.DataInputStream;
import java.io.IOException;
import orc.Orc;
import orc.OrcResponse;

public class OrcStatus {
    public Orc orc;
    public long utimeOrc;
    public long utimeHost;
    public int statusFlags;
    public int debugCharsWaiting;
    public int[] analogInput = new int[13];
    public int[] analogInputFiltered = new int[13];
    public int[] analogInputFilterAlpha = new int[13];
    public int simpleDigitalValues;
    public int simpleDigitalDirections;
    public boolean[] motorEnable = new boolean[3];
    public int[] motorPWMactual = new int[3];
    public int[] motorPWMgoal = new int[3];
    public int[] motorSlewRaw = new int[3];
    public double[] motorSlewSeconds = new double[3];
    public int[] qeiPosition = new int[2];
    public int[] qeiVelocity = new int[2];
    public int[] fastDigitalMode = new int[8];
    public int[] fastDigitalConfig = new int[8];
    public long[] gyroIntegrator = new long[3];
    public int[] gyroIntegratorCount = new int[3];

    static final int readU16(DataInputStream ins) throws IOException {
        return ins.readShort() & 0xFFFF;
    }

    static final int readS16(DataInputStream ins) throws IOException {
        return ins.readShort();
    }

    static final int readU8(DataInputStream ins) throws IOException {
        return ins.readByte() & 0xFF;
    }

    public boolean getEstopState() {
        return (this.statusFlags & 1) > 0;
    }

    public boolean getMotorWatchdogState() {
        return (this.statusFlags & 2) > 0;
    }

    public double getBatteryVoltage() {
        double voltage = (double)this.analogInputFiltered[11] / 65535.0 * 3.0;
        double batvoltage = voltage * 10.1;
        return batvoltage;
    }

    public OrcStatus(Orc orc, OrcResponse response) throws IOException {
        int i;
        this.orc = orc;
        DataInputStream ins = response.ins;
        this.utimeOrc = response.utimeOrc;
        this.utimeHost = response.utimeHost;
        this.statusFlags = ins.readInt();
        this.debugCharsWaiting = OrcStatus.readU16(ins);
        for (i = 0; i < 13; ++i) {
            this.analogInput[i] = OrcStatus.readU16(ins);
            this.analogInputFiltered[i] = OrcStatus.readU16(ins);
            this.analogInputFilterAlpha[i] = OrcStatus.readU16(ins);
        }
        this.simpleDigitalValues = ins.readInt();
        this.simpleDigitalDirections = ins.readInt();
        for (i = 0; i < 3; ++i) {
            this.motorEnable[i] = OrcStatus.readU8(ins) != 0;
            this.motorPWMactual[i] = OrcStatus.readS16(ins);
            this.motorPWMgoal[i] = OrcStatus.readS16(ins);
            this.motorSlewRaw[i] = OrcStatus.readU16(ins);
            this.motorSlewSeconds[i] = 510.0 / (double)this.motorSlewRaw[i] / 1000.0 * 128.0;
        }
        for (i = 0; i < 2; ++i) {
            this.qeiPosition[i] = ins.readInt();
            this.qeiVelocity[i] = ins.readInt();
        }
        for (i = 0; i < 8; ++i) {
            this.fastDigitalMode[i] = OrcStatus.readU8(ins);
            this.fastDigitalConfig[i] = ins.readInt();
        }
        for (i = 0; i < 3; ++i) {
            this.gyroIntegrator[i] = ins.readLong();
            this.gyroIntegratorCount[i] = ins.readInt();
        }
    }
}

