/*
 * Decompiled with CFR 0.152.
 */
package orc.spy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;

public class SmallSlider
extends JComponent {
    int barheight = 8;
    int minvalue = 0;
    int maxvalue = 100;
    int goalvalue;
    int actualvalue;
    int goalknobsize = 6;
    int actualknobsize = 10;
    int totalheight = this.actualknobsize + 4;
    int marginx = 6;
    ArrayList<Listener> gsls = new ArrayList();
    boolean copyactual = false;
    boolean showactual = true;
    public String formatString = "%.0f";
    public double formatScale = 1.0;

    public SmallSlider(int min, int max, boolean showactual) {
        this.minvalue = min;
        this.maxvalue = max;
        this.goalvalue = this.minvalue;
        this.actualvalue = this.minvalue;
        this.showactual = showactual;
        this.addMouseMotionListener(new SmallSliderMouseMotionListener());
        this.addMouseListener(new SmallSliderMouseMotionListener());
        this.copyactual = true;
    }

    public SmallSlider(int min, int max, int goalvalue, int actualvalue, boolean showactual) {
        this.minvalue = min;
        this.maxvalue = max;
        this.goalvalue = goalvalue;
        this.actualvalue = actualvalue;
        this.showactual = showactual;
        this.addMouseMotionListener(new SmallSliderMouseMotionListener());
        this.addMouseListener(new SmallSliderMouseMotionListener());
    }

    public void addListener(Listener gsl) {
        this.gsls.add(gsl);
    }

    public void setMaximum(int i) {
        this.maxvalue = i;
        this.repaint();
    }

    public void setMinimum(int i) {
        this.minvalue = i;
        this.repaint();
    }

    public synchronized void setActualValue(int i) {
        if (this.copyactual) {
            this.goalvalue = i;
            this.copyactual = false;
        }
        this.actualvalue = i;
        this.repaint();
    }

    public void setGoalValue(int i) {
        this.goalvalue = i;
        this.repaint();
    }

    public int getGoalValue() {
        return this.goalvalue;
    }

    public int getActualValue() {
        return this.actualvalue;
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, this.totalheight);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public synchronized void paint(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int height = this.getHeight();
        int width = this.getWidth() - 2 * this.marginx;
        int cy = height / 2;
        int cx = width / 2;
        g.translate(this.marginx, 0);
        g.setColor(this.getParent().getBackground());
        g.fillRect(0, 0, width, height);
        RoundRectangle2D.Double barr = new RoundRectangle2D.Double(0.0, cy - this.barheight / 2, width, this.barheight, this.barheight, this.barheight);
        g.setColor(Color.white);
        g.fill(barr);
        g.setColor(Color.black);
        g.draw(barr);
        int x = width * (this.goalvalue - this.minvalue) / (this.maxvalue - this.minvalue);
        Ellipse2D.Double goalknob = new Ellipse2D.Double(x - this.goalknobsize / 2, cy - this.goalknobsize / 2, this.goalknobsize, this.goalknobsize);
        g.setColor(Color.green);
        g.fill(goalknob);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        g.draw(goalknob);
        g.setFont(new Font("Monospaced", 0, 11));
        if (this.showactual) {
            x = width * (this.actualvalue - this.minvalue) / (this.maxvalue - this.minvalue);
            g.setColor(Color.black);
            g.setStroke(new BasicStroke(1.0f));
            Ellipse2D.Double actualknob = new Ellipse2D.Double(x - this.actualknobsize / 2, cy - this.actualknobsize / 2, this.actualknobsize, this.actualknobsize);
            g.draw(actualknob);
        }
        g.setColor(Color.black);
        String s = String.format(this.formatString, this.formatScale * (double)this.goalvalue);
        g.drawString(s, width - s.length() * 8, cy + 16);
    }

    void handleClick(int x) {
        this.goalvalue = this.minvalue + (this.maxvalue - this.minvalue) * (x - this.marginx) / (this.getWidth() - 2 * this.marginx);
        if (this.goalvalue < this.minvalue) {
            this.goalvalue = this.minvalue;
        }
        if (this.goalvalue > this.maxvalue) {
            this.goalvalue = this.maxvalue;
        }
        for (Listener gsl : this.gsls) {
            gsl.goalValueChanged(this, this.goalvalue);
        }
        this.repaint();
    }

    class SmallSliderMouseMotionListener
    implements MouseMotionListener,
    MouseListener {
        SmallSliderMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            SmallSlider.this.handleClick(e.getX());
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            SmallSlider.this.handleClick(e.getX());
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            SmallSlider.this.handleClick(e.getX());
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    public static interface Listener {
        public void goalValueChanged(SmallSlider var1, int var2);
    }
}

