/*
 * Decompiled with CFR 0.152.
 */
package orc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class GamePad {
    String devicePath;
    int[] axes = new int[16];
    int[] buttons = new int[16];

    public GamePad() {
        String[] paths = new String[]{"/dev/js0", "/dev/input/js0"};
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            File f = new File(path);
            if (!f.exists()) continue;
            this.devicePath = path;
            break;
        }
        if (this.devicePath == null) {
            System.out.println("Couldn't find a joystick.");
            System.exit(-1);
        }
        new ReaderThread().start();
    }

    public GamePad(String path) {
        this.devicePath = path;
        new ReaderThread().start();
    }

    public double getAxis(int axis) {
        if (axis >= this.axes.length) {
            return 0.0;
        }
        return (double)this.axes[axis] / 32767.0;
    }

    public boolean getButton(int button) {
        if (button >= this.buttons.length) {
            return false;
        }
        return this.buttons[button] > 0;
    }

    public int waitForAnyButtonPress() {
        int i;
        boolean[] buttonState = new boolean[16];
        for (i = 0; i < buttonState.length; ++i) {
            buttonState[i] = this.getButton(i);
        }
        while (true) {
            for (i = 0; i < buttonState.length; ++i) {
                if (this.getButton(i) == buttonState[i]) continue;
                return i;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static void main(String[] args) {
        int i;
        GamePad gp = new GamePad();
        int nAxes = 6;
        int nButtons = 16;
        for (i = 0; i < nAxes; ++i) {
            System.out.printf("%10s ", "Axis " + i);
        }
        for (i = 0; i < nButtons; ++i) {
            int v = i & 0xF;
            System.out.printf("%c", v >= 10 ? 97 + (v - 10) : 48 + v);
        }
        System.out.printf("\n", new Object[0]);
        while (true) {
            int i2;
            String s = "";
            for (i2 = 0; i2 < nButtons; ++i2) {
                s = s + (gp.getButton(i2) ? 1 : 0);
            }
            System.out.printf("\r", new Object[0]);
            for (i2 = 0; i2 < nAxes; ++i2) {
                System.out.printf("%10f ", gp.getAxis(i2));
            }
            System.out.printf("%s", s);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
            }
        }
    }

    class ReaderThread
    extends Thread {
        ReaderThread() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                this.runEx();
            }
            catch (IOException ex) {
                System.out.println("GamePad ex: " + ex);
            }
        }

        public void runEx() throws IOException {
            FileInputStream fins = new FileInputStream(new File(GamePad.this.devicePath));
            byte[] buf = new byte[8];
            while (true) {
                fins.read(buf);
                int mstime = buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
                int value = buf[4] & 0xFF | (buf[5] & 0xFF) << 8;
                if ((value & 0x8000) > 0) {
                    value |= 0xFFFF0000;
                }
                int type = buf[6] & 0xFF;
                int number = buf[7] & 0xFF;
                if ((type & 3) == 1) {
                    if (number < GamePad.this.buttons.length) {
                        GamePad.this.buttons[number] = value;
                    } else {
                        System.out.println("GamePad: " + number + " buttons!");
                    }
                }
                if ((type & 3) != 2) continue;
                if (number < GamePad.this.axes.length) {
                    GamePad.this.axes[number] = value;
                    continue;
                }
                System.out.println("GamePad: " + number + " axes!");
            }
        }
    }
}

