#!/usr/bin/perl -w
#
# Roofnet auto-updater by biswas
#
# Contacts roofnet.net, gets latest build for this node's IP.
# If the build doesn't match update this node. Nodes jitter by
# up to 50 minutes to avoid congestion
#
# The updater aborts if the /no-autoupdate file exists
#


# return 1 if successful, 0 if not
sub check_system {
    my $cmd = $_[0];
    my $retval = 0;

# hm, system seems to have problems...
# so do this for now as a workaround
    system "rm -f /tmp/ff";
    open FH, ">/tmp/ff";
    print FH "$cmd\n";
    close FH;
    $retval = system "sh /tmp/ff";
    $retval /= 256;
    system "rm -f /tmp/ff";
    return !$retval;
}



my $debug = 0;

foreach my $arg (@ARGV) {
    if ($arg eq "-d" ||
	$arg eq "--debug" ||
	$arg eq "-debug") {
	$debug = 1;
    }
}

chdir("/tmp");
print "$0: debug $debug\n";

if (-f "/no-autoupdaate") {
    die "$0: no-autoupdate file found, quitting";
}

if (! -f "/MERAKI_ARCH") {
    die "$0: /MERAKI_ARCH not found\n";
}
my $arch = `cat /MERAKI_ARCH`;
chomp($arch);


if (! -f "/MERAKI_BUILD") {
    die "$0: /MERAKI_BUILD not found\n";
}
my $build = `cat /MERAKI_BUILD`;
chomp($build);

my @l = split /\n/, `ifconfig ath0`;
@l = split /\s+/, $l[0];
my $mac = lc($l[4]);
my $build_url = "http://70.90.171.201/cgi-bin/update.pl?mac=$mac&arch=$arch&build=$build";
print "$0: fetching script from $build_url\n";
my $cmd = "wget -q \"$build_url\" -O /tmp/update_script";

if (!check_system($cmd)) {
    die "$0: fetching build number failed\n";
}

if (!check_system("sh /tmp/update_script")) {
    die "$0: update script failed\n";
}

print "update script succeeded\n";
