
AR531X_DIR := ar531x

all: $(BUILD_DIR)/stage2-embedded.elf $(BUILD_DIR)/crc

ifeq ($(BOARD), ar531x)
all: $(BUILD_DIR)/stage2-flash.elf
endif

all: $(BUILD_DIR)/upgrade.sh

$(BUILD_DIR)/part: $(LINUX_BUILD_DIR)/vmlinux-meraki.bin.lzma
	PATH=$(BUILD_DIR):$$PATH $(AR531X_DIR)/mkpart.pl $< > $@

$(BUILD_DIR)/upgrade.tgz: $(BUILD_DIR)/part $(BUILD_DIR)/stage2-flash.bin $(AR531X_DIR)/redconf.bin
	rm -rf $@.dir
	mkdir -p $@.dir
	cp $^ $@.dir
	cd $@.dir; tar czf target.tgz *
	mv $@.dir/target.tgz $@

$(BUILD_DIR)/upgrade.sh: $(AR531X_DIR)/upgrade.sh.base $(BUILD_DIR)/upgrade.tgz
	echo skip=$$((3 + `wc -l < $<`)) > $@.beginning
	cat $^ > $@.end
	echo script_reference_md5sum=\"`md5sum < $@.end | head -c 32`\" >> $@.beginning
	cat $@.beginning $@.end > $@
	chmod +x $@
	rm $@.beginning $@.end
