/*
 * ob1k.c
 *
 * Main routine for testing OB1K-112 board
 *
 * Copyright 1995 BG Systems 
 *
 * Author      Date       Comments
 * John Green  27-Jun-95  Written
 * John Green  02-Oct-95  Modified for OB1K-MP board
 *
 *
 */

static char SccsId[] = "@(#)dr_test.c	1.1  28 Jun 1995";

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>

#include <sys/schedctl.h>
#include <sys/types.h>
#include <sys/time.h>

#include "lv3.h"

void setup_lv(void );
void rf_quit(void );
void catcher(void );

extern void init_timer(struct itimerval , long);
extern int  ms_time(double *);

extern int open_lv(bglv *, char *, int );
extern int init_lv(bglv *);
extern int close_lv(bglv *);

extern int w_lv(int, char *);
extern int r_lv(bglv *);

extern int send_outputs(bglv *);
extern int check_inputs(bglv *);

extern int check_setup(bglv *);

bglv bgdata;

double start, now;
struct itimerval itv;

/*
 * main()
 *
 * This is where everything happens
 *
 */

main()
{
   int      st;
   long     counter = 0;
   long     pc;
   int      i;
   int      j;
   int      ind;
   char     inputs = 0;
   char     outputs = 1;


   setup_lv();
#ifndef DEBUG
   init_timer(itv, 30000);
#endif

   st = ms_time(&start);

   i = 0;
   ind = 0;
   pc = 0;
   while(counter++ < 10000000)
   {

/*
 *  Set digital output
 */
      if ( bgdata.mp_dig_out == 0 )
         st = w_lv(bgdata.sp_fd, "o");
      else
         st = send_outputs(&bgdata);

      st = ms_time(&now);
#ifdef DEBUG
      sginap(3);
#else
      sigpause(SIGALRM);
#endif

      if ( bgdata.mp_dig_out == 0 )
         st = r_lv(&bgdata);
      else
         st = check_inputs(&bgdata);
                  
      if ( counter % 10 == 0)
      {  
/*
 * Print the 56 inputs in a nice way
 */
         for ( j = 0; j < bgdata.n_dig_in/8; j++ )
         {
            for ( i = 0; i < 8; i++ )
            {
               if ( (bgdata.mp_din[j]>>i) & 0x1 )
                  printf("1");
               else
                  printf("0");
            }
            printf("  ");
         }
         printf("\n");

/*
 * Cycle through the 56 outputs
 */
         bgdata.mp_dout[ind] |= 0x1 << pc;
         pc++;
         if ( pc == 8 )
         {
            pc = 0;
            ind++;
            if ( ind == 8 )
            {
               for ( j = 0; j < 8; j++ )
                  bgdata.mp_dout[j] = 0;
               ind = 0;
            }
         }
      }
      if ( (counter % 200) == 0 )
         printf("%7ld  Update rate = %5.2f Hz\n",
                  counter, counter/(now-start) );
   }

   printf("%ld transfers in %f sec.\n", counter, (now-start) );
   printf("Update rate = %5.2f Hz\n", counter/(now-start) );
}


void setup_lv()
{
   int st;
   int i;
   
/*
 * Defaults to 8 analog, and 56 dig inputs and 56 dig outputs
 */
 
   bgdata.analog_in = 0;
   bgdata.analog_in = 0xff;

   bgdata.analog_out = 0;

   bgdata.dig_in = 0x0;

   bgdata.mp_dig_in  = 0;
   bgdata.mp_dig_in  = MD56;
   bgdata.mp_dig_in  = MD112;

/*
 *  For digital outputs
 */
   bgdata.dig_out = 0x0;

   bgdata.mp_dig_out = MD56;
   bgdata.mp_dig_out = 0;
 
/*
 *  Set the baud rate
 */
   bgdata.baud    = BAUD192;
 
/*
 *  Open the port & drivers
 */
   st = open_lv(&bgdata, "/dev/ttyd2", FB_NOBLOCK);
   if (st < 0)
   {
      printf("Unable to open port\n");
      exit(-1);
   }
 
   if ( bgdata.Rev.major < 3 )
   {
      printf("This test program requires a Rev 3.x EPROM\n");
      exit(-1);
   }
 
/*
 *  Send the init string
 */
   st = init_lv(&bgdata);
   if ( st < 0 )
   {
      printf("Invalid setup requested.  Bye\n");
      exit(-1);
   }
}

void catcher()
{
}

void rf_quit()
{
   int st;

   st = close_lv(&bgdata);
   printf("Bye\n");
   exit(0);
}


