/*
 * utils.c
 *
 * Some simple utility functions
 *
 * Copyright 1995 BG Systems 
 *
 * Author      Date       Comments
 * John Green  27-Jun-95  Written
 *
 *
 */

static char SccsId[] = "@(#)utils.c	1.1  28 Jun 1995";

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>

#include <sys/time.h>


void init_timer(struct itimerval itv, long );
int  ms_time(double *);

extern void catcher();
extern void rf_quit();

int ms_time(double *t)
{
   struct timeval tp;
   struct timezone tzp;
   int st;

   st = gettimeofday(&tp, &tzp);
   *t = tp.tv_sec +  ((float)tp.tv_usec / 1000000.0);
}

void init_timer(struct itimerval itv, long us_delay)
{
/*
 * Initialize the itimer
 */
   itv.it_interval.tv_sec = 0;
   itv.it_interval.tv_usec = us_delay;
   itv.it_value = itv.it_interval;
   setitimer(ITIMER_REAL, &itv, (struct itimerval *)0 );
 
   sigset(SIGALRM,  catcher);
   sigset(SIGQUIT,  rf_quit);
   sigset(SIGKILL,  rf_quit);
   sigset(SIGINT,   rf_quit);
}
