/*
 *
 *----------------------------------------------------------------------
 *
 *  Filename:
 *     lv3.h
 *
 *----------------------------------------------------------------------
 *        Copyright (C) 1994-7   BG Systems, Inc.
 *                  All rights reserved
 *----------------------------------------------------------------------
 *
 *  File description:
 *     Definitions for LV824 software
 *
 *  Modifications:
 *     Name        Date        Comment
 *     John Green  04-Jul-93   Created
 *     John Green  15-Oct-94   Major modification for Rev 3.0
 *     John Green  01-Feb-95   Cleanup for release
 *     John Green  16-Apr-95   Added DriveBox
 *     John Green  26-Jun-95   Added support for multiplex dig in.
 *     John Green  03-Oct-95   Added support for multiplex dig out.
 *     John Green  28-Feb-97   Added extra analog out, and encoders.
 *     John Green  25-Nov-97   Allow 8 encoders
 *
 *----------------------------------------------------------------------
 */
#ifndef __LV_H
#define __LV_H

/*
 * IMPORTANT.
 * 1.
 *  The bglv data structure has been modified to allow for future expansion
 *  capabilities.  If you have a FlyBox/BeeBox/CerealBox with an EPROM
 *  revision below 3.05, you can simply
 *     #define REV300
 *  instead of 
 *     #define REV305
 *  and the data structure will be the old size.  For the future you should
 *  use this file as is, but make sure to compile all files that include
 *  this.  (i.e., if you don't do this you will be passing the wrong
 *  size of data structure....)
 *
 * 2.
 *  For the new series of SGI hardware (O2/Octane/Origin) baud rates of 
 *  115200 are supported, and the termios data structure has been modified
 *  in IRIX 6.xx
 *  You can 
 *    #define _OLD_TERMIOS
 *  and this will link to an old termios data structure, and will disable
 *  the use of 115200 baud.  We recommend that you don't do this on new
 *  machine.  (Of course if you are still running IRIX 5.xx then you will
 *  have to do this.
 */

static char lv_SccsId[] = "@(#)lv3.h	1.10 24 Nov 1997";

#include <time.h>

#define REV305

#define FLYBOX    1
#define BEEBOX    2
#define CEREALBOX 3
#define CAB       4
#define DRIVEBOX  5

#define FB_NOBLOCK 1
#define FB_BLOCK 2

#define AIC1   0x01
#define AIC2   0x02
#define AIC3   0x04
#define AIC4   0x08
#define AIC5   0x10
#define AIC6   0x20
#define AIC7   0x40
#define AIC8   0x80

#define AOC1   0x01
#define AOC2   0x02
#define AOC3   0x04
/*
 *  Extra analog outputs to be available with next release
 *  of LV board.
 */
#define AOC4   0x08
#define AOC5   0x10
#define AOC6   0x20
#define AOC7   0x40
#define AOC8   0x80

#define DIC1    0x10
#define DIC2    0x20
#define DIC3    0x40

/*
 *  For use with JunctionBox
 */
#define MD16    0x10
#define MD32    0x20
#define MD48    0x30
#define MD56    0x40
#define MD64    0x50
#define MD80    0x60
#define MD96    0x70
#define MD112   0x80

#define MPDIG   0x08

#define MP112i  0x00
#define MP112o  0x10
#define MP56io  0x20

#define ENC4    0x01
#define ENC8    0x02

#define DOC1    0x10
#define DOC2    0x20
#define DOC3    0x40

/*
 *  Baud 115200 available for use with Irix 6.x new termios
 *  structure.  Supported with rev 3.07 EPROM's.  Useful on
 *  O2/Octane/Origin systems.
 */
#define BAUD1152 0x10
#define BAUD576  0x70
#define BAUD384  0x60
#define BAUD192  0x50
#define BAUD96   0x40
#define BAUD48   0x30
#define BAUD24   0x20

#ifdef _OLD_TERMIOS
#define BAUD12   0x10
#endif

#define OFFSET  0x21

/*
 *  Define some commands
 */

#define BURST       'B'    /* Burst mode                  */
#define BURST_SET   'b'    /* Burst mode rate set         */
#define CONFIG      'c'    /* Configure 3.07 + EPROMs     */
#define CONT        'C'    /* Continuous buffered         */
#define DEFAULT     'd'    /* Reset to Default            */
#define PACKET      'p'    /* One input and one output    */
#define ONCE        'o'    /* One input                   */
#define ONCE_CS     'O'    /* One input with check sum    */
#define RESET_FB    'r'    /* Reset 3 chars with offset   */
#define RESET_FB_O  'R'    /* Reset (rev 2.2 no offset)   */
#define STOP        'S'    /* Stop burst mode             */
#define SETUP       's'    /* Setup rev 3.0 eprom         */
#define TEST1       'T'    /* Test (and copyright)        */
#define TEST2       't'    /* Test (and copy, and rev #)  */

typedef struct rs_struct
{
  int  wrt;     /* write error */
  int  rd;      /* read error  */
  int  len;     /* string length error  */
  int  nl;      /* last char error  */
  int  cycles;  /* numer of cycles */
  int  thou;    /* thousands of cycles */
} RS_ERR;

typedef struct REVISION
{
   int    major;          /*  Software major revision             */
   int    minor;          /*  Software minor revision             */
   int    bug;            /*  Software bug revision               */
   char   alpha;          /*  EPROM alpha revision                */
   int    year;
}revision;

/*
 *  For v3.0 software, define a new structure
 */
typedef struct BGLV_STRUCT
{
   int    n_analog_in;    /*  Number of analog inputs (8 max)     */
   int    analog_in;      /*  Analog input selector               */
   int    n_dig_in;       /*  Number of digital inputs (24 max)   */
   int    dig_in;         /*  Digital input selector              */
   int    n_analog_out;   /*  Number of analog outputs (3 max)    */
   int    analog_out;     /*  Analog out channel selector         */
   int    n_dig_out;      /*  Number of digital outputs (24 max)  */
   int    dig_out;        /*  Digital output selector             */
   float  ain[8];         /*  Analog input data                   */
#ifdef REV300
   int    aout[3];        /*  Analog output data                  */
#endif
   int    din[3];         /*  Digital input data                  */
   int    dout[3];        /*  Digital output data                 */
   long   count;
   int    str_len;        /*  Length of string to expect          */
   int    baud;           /*  Baud rate selected                  */
   char   mode[2];        /*  Mode to send - rev 2.2              */
   time_t tag;    
   int    port;
   int    box_type;       /*  Device type                         */
   int    sp_fd;          /*  Serial port file descriptor         */
   revision   Rev;        /*  Software major revision             */
#ifdef REV305
   int    aout[8];        /*  For next generation board           */
   int    mp_dig_in;      /*  Multiplex dig input, overrides dig  */
   int    mp_dig_out;     /*  Multiplex dig output, overrides dig */
   int    mp_din[14];     /*  Multiplex inputs  values            */
   int    mp_dout[14];    /*  Multiplex outputs values            */
   int    n_enc;          /*  Number of encoders                  */
   int    enc_sel;        /*  Encoder selection                   */
   int    enc_type;       /*  Encoder type absolute/incremental   */
   long   enc_abs_val[8]; /*  Absolute value of encoder           */
   int    enc_inc_val[8]; /*  Incremental value of encoder        */
   float  sparef[16];     /*  Reserved for BG expansion           */
   int    sparei[3];      /*  Reserved for BG expansion           */
#endif
}bglv;

#endif /* __LV_H */
