/*
 * g_loop.c
 *
 * Main routine for loop back test for LV824-3G
 *
 * Copyright 1995 BG Systems 
 *
 * Author       Date       Comments
 * John Green   10-Feb-95  Written
 *
 *
 */

static char SccsId[] = "@(#)g_loop.c	1.3 14 Feb 1995";

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <signal.h>

#include <sys/schedctl.h>
#include <sys/types.h>
#include <sys/time.h>

#include "lv3.h"

void setup_lv(void);
void init_timer(void);
void rf_quit(void);
void catcher(void);
int  ms_time(double *);

extern int open_lv(bglv *, char *, int );
extern int init_lv(bglv *);
extern int close_lv(bglv * );

extern int w_lv(int, char *);
extern int r_lv(bglv *);
extern int send_outputs(bglv *);
extern int check_inputs(bglv *);

extern int check_setup( bglv *);
extern void pattern(long *, bglv *);

bglv bgdata;

double start, now;
struct itimerval itv;

/*
 * main()
 *
 * This is where everything happens
 *
 */

main()
{
   int      st;
   long     counter = 0;
   int      i;
   int      j;
   float    si;
   float    volts;


   setup_lv();
#ifndef DEBUG
   init_timer();
#endif

   st = ms_time(&start);

   i = 0;
   while(counter++ < 100000)
   {
/*
 *  Set analog output
 */
      si = sin( counter/100.0 );     
      bgdata.aout[0] = (int) ((1.0+si)*2048);
      bgdata.aout[1] = 4095-bgdata.aout[0];
      bgdata.aout[2] = (4095 - counter);

      send_outputs(&bgdata);

      st = ms_time(&now);
#ifdef DEBUG
      sginap(3);
#else
      sigpause(SIGALRM);
#endif

      st = check_inputs(&bgdata);
                  
      if ( counter % 5 == 0)
      {
         volts = 5.0 * ((bgdata.ain[0] + 1.0) / 2.0);
         printf("%6.3f V   ", volts );

         for ( i = 0; i < 3; i++ )
         {
            if ( bgdata.analog_out & 0x1 << i )
               printf("%d  ", bgdata.aout[i] );
         }

         printf("\n");
      }
      if ( (counter % 200) == 0 )
         printf("%7ld  Update rate = %5.2f Hz\n",
                  counter, counter/(now-start) );
   }

   printf("%ld transfers in %f sec.\n", counter, (now-start) );
   printf("Update rate = %5.2f Hz\n", counter/(now-start) );
}


void setup_lv()
{
   int st;
   int i;
   
/*
 * Set to 1 analog input, and 0 discretes
 */
 
   bgdata.analog_in = 0;
   bgdata.analog_in = AIC1;

   bgdata.dig_in = 0;

/*
 *  For outputs set all 3 analogs
 */
   bgdata.analog_out = AOC1 | AOC2 | AOC3;

   bgdata.dig_out = 0;
   
/*
 *  Set the baud rate
 */
   bgdata.baud    = BAUD192;
 
/*
 *  Open the port & drivers
 */
   st = open_lv(&bgdata, "", FB_NOBLOCK);
   if (st < 0)
   {
      printf("Unable to open port\n");
      exit(-1);
   }
 
   if ( bgdata.Rev.major < 3 )
   {
      printf("This test program requires a Rev 3.x EPROM\n");
      exit(-1);
   }
 
/*
 *  Send the init string
 */
   st = init_lv(&bgdata);
   if ( st < 0 )
   {
      printf("Invalid setup requested.  Bye\n");
      exit(-1);
   }
}

void catcher()
{
}

int ms_time(double *t)
{
   struct timeval tp;
   struct timezone tzp;
   int st;

   st = gettimeofday(&tp, &tzp);
   *t = tp.tv_sec +  ((float)tp.tv_usec / 1000000.0);
}

void rf_quit()
{
   int st;

   st = close_lv(&bgdata);
   printf("Bye\n");
   exit(0);
}


void init_timer()
{
/*
 * Initialize the itimer
 */
   itv.it_interval.tv_sec = 0;
   itv.it_interval.tv_usec = 50000;
   itv.it_value = itv.it_interval;
   setitimer(ITIMER_REAL, &itv, (struct itimerval *)0 );
 
   sigset(SIGALRM,  catcher);
   sigset(SIGQUIT,  rf_quit);
   sigset(SIGKILL,  rf_quit);
   sigset(SIGINT,   rf_quit);
}
