| Context switch and thread startup for Sun.

	.text

| Suspend the current thread and resume the next one.
|
|	void
|	thread_Proc_Switch(cur, next)
|		int *cur;
|		int *next;

	.globl	_thread_Proc_Switch
_thread_Proc_Switch:
	movl	sp@(4),a0	| a0 = cur
	movl	sp@(8),a1	| a1 = next
	moveml	#Lpush,sp@-	| save current registers
	movl	sp,a0@		| save current sp
	movl	a1@,sp		| restore next sp
	moveml	sp@+,#Lpop	| restore next registers
	rts			| return to next thread

|	void
|	thread_Proc_Start(parent_context, child, stackp)
|		int *parent_context;
|		proc_t child;
|		int stackp;

	.globl	_thread_Proc_Start
_thread_Proc_Start:
	movl	sp@(4),a0	| a0 = parent
	movl	sp@(12),a1	| a1 = stackp
	movl	sp@(8),a1@-	| push child onto stackp
	moveml	#Lpush,sp@-	| save parent registers
	movl	sp,a0@		| save parent sp
	movl	a1,sp		| child sp = stackp
	jbsr	_thread_Body	| thread_Body(child)

	| Control never returns from thread_Body().


	| Register save masks for moveml instruction.
	| The pop mask is for post-increment mode.
	| The push mask is for pre-decrement mode.
	Lpop	= 0x7cfc	| A6 .. A2, D7 .. D2
	Lpush	= 0x3f3e	| D2 .. D7, A2 .. A6
