! Context switch and thread startup for Sun 4.

	ST_FLUSH_WINDOWS = 3		! see <sun4/trap.h>

	.seg	"text"

! Suspend the current thread and resume the next one.
!
!	void
!	thread_Proc_Switch(cur, next)
!		int *cur;
!		int *next;

	.globl	_thread_Proc_Switch
_thread_Proc_Switch:
	st	%o7, [%o0]		! save current return addr
	st	%sp, [%o0 + 4]		! save current sp
	ta	ST_FLUSH_WINDOWS	! flush current register windows
	ld	[%o1 + 4], %fp		! restore next sp
	sub	%fp, 64, %sp
	ld	[%o1], %o7		! restore next return addr
	jmp	%o7 + 8			! return to next thread
	restore

!	void
!	thread_Proc_Start(parent_context, child, stackp)
!		int *parent_context;
!		proc_t child;
!		int stackp;

	.globl	_thread_Proc_Start
_thread_Proc_Start:
	st	%o7, [%o0]		! save parent return addr
	st	%sp, [%o0 + 4]		! save parent sp
	ta	ST_FLUSH_WINDOWS	! flush parent register windows
	mov	%o2, %sp		! child sp = stackp
	clr	%fp			! fp = NIL
	call	_thread_Body		! thread_Body(child)
	mov	%o1, %o0

	! Control never returns from thread_Body().

	unimp	0			! shouldn't be reached

