BEGIN {
	pending = 0
}
NF == 2 && $1 == "call" && \
 ($2 == "_Spin_Lock,1" || \
  $2 == "_Spin_Unlock,1" || \
  $2 == "_Mutex_Unlock,1" || \
  $2 == "_Mutex_Try_Lock,1" || \
  $2 == "_thread_Sp,0") {
	if (pending == 0) {
		name = $2
		pending = 1
	} else {
		print "internal error: inline already pending" > "/dev/tty"
	}
	continue
}
pending == 1 {
# move non-NOP before the call-equivalent
	if (NF != 1 || $1 != "nop")
		print
	print	"!	BEGIN INLINE " name
	if (name == "_Spin_Lock,1") {
		print	"1:	ldstub	[%o0], %o0"
		print	"	orcc	%o0, %g0, %o0"
		print	"	bne	1b"
		print	"	nop"
	} else if (name == "_Spin_Unlock,1" || name == "_Mutex_Unlock,1") {
		print	"	clr	[%o0]"
	} else if (name == "_Mutex_Try_Lock,1") {
		print	"	ldstub	[%o0], %o0"
		print	"	xor	%o0, 0xFF, %o0"
	} else if (name == "_thread_Sp,0") {
		print	"	mov	%sp, %o0"
	} else {
		print "internal error: unknown inline " name > "/dev/tty"
	}
	print	"!	END INLINE " name
	pending = 0
}
# default:
{
	print
}
