/*
 * thread_internals.h
 *
 * $Source: /usr0/ecc/nectar/src/cab/new/threads/RCS/thread_internals.h,v $
 *
 * $Header: thread_internals.h,v 1.1 88/04/04 19:05:54 ecc Exp $
 *
 * Internals of threads package.
 */

#ifndef	_THREAD_INTERNALS_
#define	_THREAD_INTERNALS_

#define	CONTEXT_SIZE	2		/* max needed by different architectures */

/*
 * This structure must agree with struct Thread_base in threads.h
 */
typedef struct proc {
	struct proc *next;		/* for lock, condition, and ready queues */
	Thread_t incarnation;		/* for thread_self() */
	int context[CONTEXT_SIZE];
	int state;
	int level;
	unsigned int stack_base;
	unsigned int stack_size;
} *proc_t;

#define	NO_PROC			((proc_t) 0)
#define	thread_Proc_Self()	((proc_t) thread_Self())

/*
 * Possible proc states.
 */
#define	PROC_RUNNING		0
#define	PROC_SPINNING		1
#define	PROC_BLOCKED		2

/*
 * Module-wide threads functions.
 */
PUBLIC void thread_Proc_Init();
PUBLIC void thread_Proc_Create();
PUBLIC void thread_Stack_Init();
PUBLIC void thread_Stack_Alloc();
PUBLIC void thread_Proc_Start();
PUBLIC void thread_Proc_Switch();

#endif	_THREAD_INTERNALS_
