/*
 * time.h
 *
 * $Source: /usr0/ecc/nectar/src/cab/threads/RCS/time.h,v $
 *
 * $Header: time.h,v 1.1 88/04/04 18:59:28 ecc Locked $
 */

#ifndef	_TIME_
#define	_TIME_

typedef struct Time_val {
	long seconds;
	long microseconds;
} *Time_val_t;

#define	TIME_VAL_INITIALIZER	{ 0, 0 }

#define	NO_TIME_VAL		((Time_val_t) 0)

/*
 * Compare two Time_val structures.
 * Result is <, ==, or > 0, according to whether t1 is <, ==, or > t2.
 */
#define TIME_COMPARE(t1, t2)	((t1)->seconds == (t2)->seconds \
					? (t1)->microseconds - (t2)->microseconds \
					: (t1)->seconds - (t2)->seconds)

/*
 * Store the current time in the result Time_val.
 */
EXPORT void
Time_Now ARGS ((OUT Time_val_t result));

/*
 * Compare two Time_val structures.
 * The current time of day is used
 * in place of t1 or t2 if it is NO_TIME_VAL.
 * Result is <, ==, or > 0, according to whether t1 is <, ==, or > t2.
 */
EXPORT int
Time_Compare ARGS ((Time_val_t t1, Time_val_t t2));

/*
 * result := t1 + t2
 * where t1 and t2 are struct Time_val pointers.
 * The current time of day is used
 * in place of t1 or t2 if it is NO_TIME_VAL.
 * t1 or t2 can also be used as the result.
 */
EXPORT void
Time_Plus ARGS ((Time_val_t t1, Time_val_t t2, OUT Time_val_t result));

/*
 * result := t1 - t2
 * where t1 and t2 are struct Time_val pointers.
 * The current time of day is used
 * in place of t1 or t2 if it is NO_TIME_VAL.
 * t1 or t2 can also be used as the result.
 */
EXPORT void
Time_Diff ARGS ((Time_val_t t1, Time_val_t t2, OUT Time_val_t result));

#endif	_TIME_
