#ifndef	lint
static char rcs_id[] = "$Header: unix.c,v 1.4 88/05/09 16:03:03 ecc Exp $";
#endif	not lint

/*
 * threads/unix.c
 *
 * $Source: /usr0/ecc/nectar/src/cab/threads/RCS/unix.c,v $
 *
 * Simulate blocking UNIX system calls in the presence
 * of other threads.
 */


#include <nectar_sys.h>
#include <threads.h>
#include <time.h>

#include <stdio.h>
#include <sys/errno.h>
#include <sys/types.h>
#include <syscall.h>

EXPORT struct Time_val Thread_select_timeout = {
	0,	/* seconds */
	10000,	/* microseconds */
};

#ifdef	NFDBITS
#define	FD_BYTES(n)	(howmany((n), NFDBITS) * sizeof(fd_mask))
#else	not NFDBITS
#define	FD_BYTES(n)	sizeof(struct fd_set)
#endif	not NFDBITS

#ifdef	lint
#define	select	Thread_Select
#define	gets	Thread_Gets
#endif	lint


EXPORT int
select(nfds, readfds, writefds, exceptfds, timeout)
	int nfds;
	fd_set *readfds, *writefds, *exceptfds;
	Time_val_t timeout;
    BEGIN(select)
	int n;
	struct Time_val tval, deadline;
	fd_set r, w, e;
	fd_set *rp = (readfds == 0 ? 0 : &r);
	fd_set *wp = (writefds == 0 ? 0 : &w);
	fd_set *ep = (exceptfds == 0 ? 0 : &e);
	IMPORT bcopy(), syscall();
	IMPORT errno;

	if (timeout != NO_TIME_VAL)
		Time_Plus(NO_TIME_VAL, timeout, &deadline);
	for (;;) {
		if (Thread_Count() <= 1) {
			/*
			 * No other threads are runnable.
			 * Go ahead and do the possibly blocking version.
			 */
			n = syscall(SYS_select, nfds, readfds, writefds, exceptfds, timeout);
			if (n == -1 && errno == EINTR)
				continue;
			RETURN(n);
		}
		/*
		 * Only copy in portion of fd_set required by value of nfds.
		 */
		if (rp != 0)
			bcopy((char *) readfds, (char *) rp, FD_BYTES(nfds));
		if (wp != 0)
			bcopy((char *) writefds, (char *) wp, FD_BYTES(nfds));
		if (ep != 0)
			bcopy((char *) exceptfds, (char *) ep, FD_BYTES(nfds));
		tval = Thread_select_timeout;
		n = syscall(SYS_select, nfds, rp, wp, ep, &tval);
		switch (n) {
		    case -1:
			if (errno == EINTR)
				continue;
			RETURN(-1);
		    case 0:
			if (timeout != NO_TIME_VAL &&
			    Time_Compare(&deadline, NO_TIME_VAL) <= 0)
				RETURN(0);
			DEBUG(Thread_debug, (msg, "select() poll\n"));
			Thread_Yield();
			continue;
		    default:
			/*
			 * Only copy out portion of fd_set required by value of nfds.
			 */
			if (rp != 0)
				bcopy((char *) rp, (char *) readfds, FD_BYTES(nfds));
			if (wp != 0)
				bcopy((char *) wp, (char *) writefds, FD_BYTES(nfds));
			if (ep != 0)
				bcopy((char *) ep, (char *) exceptfds, FD_BYTES(nfds));
			RETURN(n);
		}
	}
    END(select)


/*
 * Non-blocking version of gets().
 */
EXPORT string_t
gets(s)
	string_t s;
    BEGIN(gets)
	int f = fileno(stdin);
	int mask = 1 << f;
	int c;

	mask = 1 << f;
	if (select(f + 1, (fd_set *) &mask, (fd_set *) 0, (fd_set *) 0, NO_TIME_VAL) != 1) {
		perror("select");
		RETURN(NULL);
	}
	while ((c = getchar()) != '\n') {
		if (c == EOF)
			RETURN(NULL);
		*s++ = c;
	}
	*s = '\0';
	RETURN(s);
    END(gets)
