/*
 * Context switch and thread startup for VAX.
 */

	.text

/*
 * Suspend the current thread and resume the next one.
 *
 *	void
 *	thread_Proc_Switch(cur, next)
 *		int *cur;
 *		int *next;
 */
	.align	1
	.globl	_thread_Proc_Switch
_thread_Proc_Switch:
	.word	0xfc0		/* save current registers */
	movl	fp,*4(ap)	/* save current fp */
	movl	*8(ap),fp	/* restore next fp */
	movl	fp,sp		/* sp = fp */
	ret			/* return to next thread */

/*
 *	void
 *	thread_Proc_Start(parent_context, child, stackp)
 *		int *parent_context;
 *		proc_t child;
 *		int stackp;
 */
	.align	1
	.globl	_thread_Proc_Start
_thread_Proc_Start:
	.word	0xfc0			/* save parent registers */
	movl	fp,*4(ap)		/* save parent fp */
	movl	12(ap),sp		/* sp = stackp */
	movl	sp,fp			/* fp = sp */
	pushl	8(ap)
	calls	$1,_thread_Body		/* thread_Body(child) */
	/*
	 * Control never returns from thread_Body().
	 */
