#----------------------------------------------------------------------
# Name:        wx.lib.pdfwin
# Purpose:     A class that allows the use of the Acrobat PSF reader
#              ActiveX control
#
# Author:      Robin Dunn
#
# Created:     22-March-2004
# RCS-ID:      $Id: pdfwin.py,v 1.1 2004/03/23 05:29:33 RD Exp $
# Copyright:   (c) 2004 by Total Control Software
# Licence:     wxWindows license
#----------------------------------------------------------------------
# This module was generated by the wx.activex.GernerateAXModule class
# (See also the genaxmodule script.)

import wx
import wx.activex

clsID = '{CA8A9780-280D-11CF-A24D-444553540000}'
progID = 'PDF.PdfCtrl.5'



# Derive a new class from ActiveXWindow
class PDFWindow(wx.activex.ActiveXWindow):
    def __init__(self, parent, ID=-1, pos=wx.DefaultPosition,
                 size=wx.DefaultSize, style=0, name='PDFWindow'):
        wx.activex.ActiveXWindow.__init__(self, parent,
            wx.activex.CLSID('{CA8A9780-280D-11CF-A24D-444553540000}'),
            ID, pos, size, style, name)
        
    # Methods exported by the ActiveX object
    def LoadFile(self, fileName):
        return self.CallAXMethod('LoadFile', fileName)

    def setShowToolbar(self, On):
        return self.CallAXMethod('setShowToolbar', On)

    def gotoFirstPage(self):
        return self.CallAXMethod('gotoFirstPage')

    def gotoLastPage(self):
        return self.CallAXMethod('gotoLastPage')

    def gotoNextPage(self):
        return self.CallAXMethod('gotoNextPage')

    def gotoPreviousPage(self):
        return self.CallAXMethod('gotoPreviousPage')

    def setCurrentPage(self, n):
        return self.CallAXMethod('setCurrentPage', n)

    def goForwardStack(self):
        return self.CallAXMethod('goForwardStack')

    def goBackwardStack(self):
        return self.CallAXMethod('goBackwardStack')

    def setPageMode(self, pageMode):
        return self.CallAXMethod('setPageMode', pageMode)

    def setLayoutMode(self, layoutMode):
        return self.CallAXMethod('setLayoutMode', layoutMode)

    def setNamedDest(self, namedDest):
        return self.CallAXMethod('setNamedDest', namedDest)

    def Print(self):
        return self.CallAXMethod('Print')

    def printWithDialog(self):
        return self.CallAXMethod('printWithDialog')

    def setZoom(self, percent):
        return self.CallAXMethod('setZoom', percent)

    def setZoomScroll(self, percent, left, top):
        return self.CallAXMethod('setZoomScroll', percent, left, top)

    def setView(self, viewMode):
        return self.CallAXMethod('setView', viewMode)

    def setViewScroll(self, viewMode, offset):
        return self.CallAXMethod('setViewScroll', viewMode, offset)

    def setViewRect(self, left, top, width, height):
        return self.CallAXMethod('setViewRect', left, top, width, height)

    def printPages(self, from_, to):
        return self.CallAXMethod('printPages', from_, to)

    def printPagesFit(self, from_, to, shrinkToFit):
        return self.CallAXMethod('printPagesFit', from_, to, shrinkToFit)

    def printAll(self):
        return self.CallAXMethod('printAll')

    def printAllFit(self, shrinkToFit):
        return self.CallAXMethod('printAllFit', shrinkToFit)

    def setShowScrollbars(self, On):
        return self.CallAXMethod('setShowScrollbars', On)

    def AboutBox(self):
        return self.CallAXMethod('AboutBox')


#  PROPERTIES
#  --------------------
#  
#  
#  
#  METHODS
#  --------------------
#  LoadFile
#      retType:  bool
#      params:
#          fileName
#              in:False  out:False  optional:False  type:string
#  
#  setShowToolbar
#      retType:  VT_VOID
#      params:
#          On
#              in:False  out:False  optional:False  type:bool
#  
#  gotoFirstPage
#      retType:  VT_VOID
#  
#  gotoLastPage
#      retType:  VT_VOID
#  
#  gotoNextPage
#      retType:  VT_VOID
#  
#  gotoPreviousPage
#      retType:  VT_VOID
#  
#  setCurrentPage
#      retType:  VT_VOID
#      params:
#          n
#              in:False  out:False  optional:False  type:int
#  
#  goForwardStack
#      retType:  VT_VOID
#  
#  goBackwardStack
#      retType:  VT_VOID
#  
#  setPageMode
#      retType:  VT_VOID
#      params:
#          pageMode
#              in:False  out:False  optional:False  type:string
#  
#  setLayoutMode
#      retType:  VT_VOID
#      params:
#          layoutMode
#              in:False  out:False  optional:False  type:string
#  
#  setNamedDest
#      retType:  VT_VOID
#      params:
#          namedDest
#              in:False  out:False  optional:False  type:string
#  
#  Print
#      retType:  VT_VOID
#  
#  printWithDialog
#      retType:  VT_VOID
#  
#  setZoom
#      retType:  VT_VOID
#      params:
#          percent
#              in:False  out:False  optional:False  type:double
#  
#  setZoomScroll
#      retType:  VT_VOID
#      params:
#          percent
#              in:False  out:False  optional:False  type:double
#          left
#              in:False  out:False  optional:False  type:double
#          top
#              in:False  out:False  optional:False  type:double
#  
#  setView
#      retType:  VT_VOID
#      params:
#          viewMode
#              in:False  out:False  optional:False  type:string
#  
#  setViewScroll
#      retType:  VT_VOID
#      params:
#          viewMode
#              in:False  out:False  optional:False  type:string
#          offset
#              in:False  out:False  optional:False  type:double
#  
#  setViewRect
#      retType:  VT_VOID
#      params:
#          left
#              in:False  out:False  optional:False  type:double
#          top
#              in:False  out:False  optional:False  type:double
#          width
#              in:False  out:False  optional:False  type:double
#          height
#              in:False  out:False  optional:False  type:double
#  
#  printPages
#      retType:  VT_VOID
#      params:
#          from
#              in:False  out:False  optional:False  type:int
#          to
#              in:False  out:False  optional:False  type:int
#  
#  printPagesFit
#      retType:  VT_VOID
#      params:
#          from
#              in:False  out:False  optional:False  type:int
#          to
#              in:False  out:False  optional:False  type:int
#          shrinkToFit
#              in:False  out:False  optional:False  type:bool
#  
#  printAll
#      retType:  VT_VOID
#  
#  printAllFit
#      retType:  VT_VOID
#      params:
#          shrinkToFit
#              in:False  out:False  optional:False  type:bool
#  
#  setShowScrollbars
#      retType:  VT_VOID
#      params:
#          On
#              in:False  out:False  optional:False  type:bool
#  
#  AboutBox
#      retType:  VT_VOID
#  
#  
#  
#  
#  EVENTS
#  --------------------
#  
#  
#  
