/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime.types;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import scala.Type;

public class Statistics {
    private static long instantiationsCount;
    private static long uniqueInstantiationsCount;
    private static long instanceOfCount;
    private static long weakInstanceOfCount;
    private static long typeCastCount;
    private static long ancestorSearchIterations;
    private static long ancestorSearches;
    private static HashMap instances;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean addWriteFileHook() {
        1 var0 = new 1();
        Runtime.getRuntime().addShutdownHook(var0);
        return true;
    }

    public static synchronized boolean incInstantiations(boolean bl) {
        ++instantiationsCount;
        if (bl) {
            ++uniqueInstantiationsCount;
        }
        return true;
    }

    public static synchronized boolean incInstanceOf() {
        ++instanceOfCount;
        return true;
    }

    public static synchronized boolean incWeakInstanceOf() {
        ++weakInstanceOfCount;
        return true;
    }

    public static synchronized boolean decInstanceOf() {
        --instanceOfCount;
        return true;
    }

    public static synchronized boolean incTypeCast() {
        ++typeCastCount;
        return true;
    }

    public static synchronized boolean incInstances(String string, Type type) {
        ArrayList<Type> arrayList = (ArrayList<Type>)instances.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Type>();
            instances.put(string, arrayList);
        }
        arrayList.add(type);
        return true;
    }

    public static synchronized boolean addAncestorSearchIterations(int n) {
        ancestorSearchIterations += (long)n;
        ++ancestorSearches;
        return true;
    }

    public static boolean writeToFile() throws FileNotFoundException {
        String string = System.getProperty("scala.runtime.types.statfile");
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError((Object)"property scala.runtime.types.statfile not set");
        }
        System.out.println("Writing RTT statistics to file ".concat(String.valueOf(String.valueOf(string))));
        PrintStream printStream = new PrintStream(new FileOutputStream(string));
        printStream.println("(");
        printStream.println(String.valueOf(String.valueOf("(instantiations . ".concat(String.valueOf(instantiationsCount)))).concat(")"));
        printStream.println(String.valueOf(String.valueOf("(unique-instantiations . ".concat(String.valueOf(uniqueInstantiationsCount)))).concat(")"));
        printStream.println(String.valueOf(String.valueOf("(instance-of . ".concat(String.valueOf(instanceOfCount)))).concat(")"));
        printStream.println(String.valueOf(String.valueOf("(weak-instance-of . ".concat(String.valueOf(weakInstanceOfCount)))).concat(")"));
        printStream.println(String.valueOf(String.valueOf("(type-cast . ".concat(String.valueOf(typeCastCount)))).concat(")"));
        if (ancestorSearches > 0L) {
            printStream.println(String.valueOf(String.valueOf("(ancestor-searches . ".concat(String.valueOf(ancestorSearches)))).concat(")"));
            printStream.println(String.valueOf(String.valueOf("(ancestor-search-iterations . ".concat(String.valueOf(ancestorSearchIterations)))).concat(")"));
        }
        printStream.println("(instances . (");
        Iterator iterator = instances.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            ArrayList arrayList = (ArrayList)entry.getValue();
            HashSet hashSet = new HashSet(arrayList);
            printStream.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("(\"".concat(String.valueOf(String.valueOf(string2))))).concat("\" . "))).concat(String.valueOf(arrayList.size())))).concat(")"));
            printStream.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("(\"Unique".concat(String.valueOf(String.valueOf(string2))))).concat("\" . "))).concat(String.valueOf(hashSet.size())))).concat(")"));
        }
        printStream.print("))");
        printStream.println(")");
        printStream.close();
        return true;
    }

    static {
        $assertionsDisabled = !Class.forName("scala.runtime.types.Statistics").desiredAssertionStatus();
        instantiationsCount = 0L;
        uniqueInstantiationsCount = 0L;
        instanceOfCount = 0L;
        weakInstanceOfCount = 0L;
        typeCastCount = 0L;
        ancestorSearchIterations = 0L;
        ancestorSearches = 0L;
        instances = new HashMap();
        if (!$assertionsDisabled && !Statistics.addWriteFileHook()) {
            throw new AssertionError();
        }
    }

    static class 1
    extends Thread {
        public void run() {
            try {
                Statistics.writeToFile();
            }
            catch (Throwable throwable) {
                throw new Error(throwable);
            }
        }

        1() {
        }
    }
}

