/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class CodePrinter {
    public static final String STEP = "    ";
    public static final String LINE = System.getProperty("line.separator");
    private final Writer writer;
    private String step;
    private int level;
    private boolean align;
    private boolean space;
    private boolean line;

    public CodePrinter() {
        this(new StringWriter());
    }

    public CodePrinter(String string) {
        this(new StringWriter(), string);
    }

    public CodePrinter(Writer writer) {
        this(writer, STEP);
    }

    public CodePrinter(Writer writer, String string) {
        this.writer = writer;
        this.step = string;
        this.level = 0;
        this.align = true;
        this.space = false;
        this.line = false;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public int getIndentLevel() {
        return this.level;
    }

    public int getIndentWidth() {
        return this.step == null ? -1 : this.step.length();
    }

    public String getIndentString() {
        return this.step;
    }

    public CodePrinter setIndentLevel(int n) {
        this.level = n;
        return this;
    }

    public CodePrinter setIndentWidth(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return this.setIndentString(stringBuffer.toString());
    }

    public CodePrinter setIndentString(String string) {
        this.step = string;
        return this;
    }

    public CodePrinter indent() {
        ++this.level;
        return this;
    }

    public CodePrinter undent() {
        --this.level;
        return this;
    }

    public CodePrinter line() {
        if (this.step == null) {
            return this.space();
        }
        if (this.line) {
            return this;
        }
        this.write(LINE);
        this.line = this.align;
        this.align = true;
        this.space = false;
        return this;
    }

    public CodePrinter space() {
        this.space = !this.align;
        return this;
    }

    public CodePrinter println() {
        return this.line();
    }

    public CodePrinter println(boolean bl) {
        return this.print(bl).line();
    }

    public CodePrinter println(byte by) {
        return this.print(by).line();
    }

    public CodePrinter println(short s) {
        return this.print(s).line();
    }

    public CodePrinter println(char c) {
        return this.print(c).line();
    }

    public CodePrinter println(int n) {
        return this.print(n).line();
    }

    public CodePrinter println(long l) {
        return this.print(l).line();
    }

    public CodePrinter println(float f) {
        return this.print(f).line();
    }

    public CodePrinter println(double d) {
        return this.print(d).line();
    }

    public CodePrinter println(String string) {
        return this.print(string).line();
    }

    public CodePrinter print(boolean bl) {
        return this.print(String.valueOf(bl));
    }

    public CodePrinter print(byte by) {
        return this.print(String.valueOf(by));
    }

    public CodePrinter print(short s) {
        return this.print(String.valueOf(s));
    }

    public CodePrinter print(char c) {
        return this.print(String.valueOf(c));
    }

    public CodePrinter print(int n) {
        return this.print(String.valueOf(n));
    }

    public CodePrinter print(long l) {
        return this.print(String.valueOf(l));
    }

    public CodePrinter print(float f) {
        return this.print(String.valueOf(f));
    }

    public CodePrinter print(double d) {
        return this.print(String.valueOf(d));
    }

    public CodePrinter print(String string) {
        if (this.align) {
            for (int i = 0; i < this.level; ++i) {
                this.write(this.step);
            }
        }
        if (this.space) {
            this.write(" ");
        }
        this.write(string);
        this.align = false;
        this.space = false;
        this.line = false;
        return this;
    }

    public String toString() {
        return this.writer.toString();
    }

    private void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }
}

