/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.util;

import ch.epfl.lamp.util.CodePrinter;
import ch.epfl.lamp.util.HTMLRepresentation;
import ch.epfl.lamp.util.StringOf;
import ch.epfl.lamp.util.XMLAttribute;
import java.io.Writer;

public class HTMLPrinter {
    public static final String DEFAULT_STYLESHEET = "style.css";
    public static final String DEFAULT_JAVASCRIPT = "script.js";
    private static final Character AMP = new Character('&');
    private static final Character GT = new Character('>');
    private static final Character LT = new Character('<');
    private static final Character QUOT = new Character('\"');
    private final CodePrinter printer;
    private final String title;
    protected final HTMLRepresentation representation;
    protected final String stylesheet;
    protected final String script;

    public HTMLPrinter(Writer writer, String string, HTMLRepresentation hTMLRepresentation, String string2, String string3) {
        this.printer = new CodePrinter(writer, "  ");
        this.title = string;
        this.representation = hTMLRepresentation;
        this.stylesheet = string2;
        this.script = string3;
    }

    public HTMLPrinter(Writer writer, String string, HTMLRepresentation hTMLRepresentation, String string2) {
        this(writer, string, hTMLRepresentation, string2, DEFAULT_JAVASCRIPT);
    }

    public HTMLPrinter(Writer writer, String string, HTMLRepresentation hTMLRepresentation) {
        this(writer, string, hTMLRepresentation, DEFAULT_STYLESHEET);
    }

    public HTMLPrinter(Writer writer, String string, String string2) {
        this(writer, string, new HTMLRepresentation("HTML 4.01 Transitional", string2));
    }

    public HTMLPrinter(Writer writer, String string) {
        this(writer, string, "iso-8859-1");
    }

    public CodePrinter getCodePrinter() {
        return this.printer;
    }

    public String getTitle() {
        return this.title;
    }

    public static String encode(Character c) {
        if (AMP.compareTo(c) == 0) {
            return "&amp;";
        }
        if (GT.compareTo(c) == 0) {
            return "&gt;";
        }
        if (LT.compareTo(c) == 0) {
            return "&lt;";
        }
        if (QUOT.compareTo(c) == 0) {
            return "&quot;";
        }
        return c.toString();
    }

    public static String encode(String string) {
        return string;
    }

    public HTMLPrinter indent() {
        this.printer.indent();
        return this;
    }

    public HTMLPrinter undent() {
        this.printer.undent();
        return this;
    }

    public HTMLPrinter line() {
        this.printer.line();
        return this;
    }

    public HTMLPrinter space() {
        this.printer.space();
        return this;
    }

    public HTMLPrinter println() {
        this.printer.println();
        return this;
    }

    public HTMLPrinter println(boolean bl) {
        this.printer.println(bl);
        return this;
    }

    public HTMLPrinter println(byte by) {
        this.printer.println(by);
        return this;
    }

    public HTMLPrinter println(short s) {
        this.printer.println(s);
        return this;
    }

    public HTMLPrinter println(char c) {
        this.printer.println(c);
        return this;
    }

    public HTMLPrinter println(int n) {
        this.printer.println(n);
        return this;
    }

    public HTMLPrinter println(long l) {
        this.printer.println(l);
        return this;
    }

    public HTMLPrinter println(float f) {
        this.printer.println(f);
        return this;
    }

    public HTMLPrinter println(double d) {
        this.printer.println(d);
        return this;
    }

    public HTMLPrinter println(String string) {
        this.printer.println(string);
        return this;
    }

    public HTMLPrinter printlnOTag(String string) {
        this.printer.print("<");
        this.printer.print(string);
        this.printer.println(">");
        return this;
    }

    public HTMLPrinter printlnOTag(String string, XMLAttribute[] xMLAttributeArray) {
        this.printer.print("<");
        this.printer.print(string);
        this.printer.print(" ");
        this.printer.print(StringOf.object.array(xMLAttributeArray, "", " ", ""));
        this.printer.println(">");
        return this;
    }

    public HTMLPrinter printlnCTag(String string) {
        this.printer.print("</");
        this.printer.print(string);
        this.printer.println(">");
        return this;
    }

    public HTMLPrinter printlnTag(String string, String string2) {
        this.printlnOTag(string);
        this.print(string2);
        return this.printlnCTag(string);
    }

    public HTMLPrinter printlnTag(String string, XMLAttribute[] xMLAttributeArray, String string2) {
        this.printOTag(string, xMLAttributeArray);
        this.print(string2);
        return this.printlnCTag(string);
    }

    public HTMLPrinter printlnSTag(String string) {
        this.printer.print("<");
        this.printer.print(string);
        this.printer.println("/>");
        return this;
    }

    public HTMLPrinter printlnSTag(String string, XMLAttribute[] xMLAttributeArray) {
        this.printer.print("<");
        this.printer.print(string);
        this.printer.print(" ");
        this.printer.print(StringOf.object.array(xMLAttributeArray, "", " ", ""));
        this.printer.println("/>");
        return this;
    }

    public HTMLPrinter printlnAhref(String string, String string2) {
        this.printOTag("a", new XMLAttribute[]{new XMLAttribute("href", string)});
        this.print(string2);
        return this.printlnCTag("a");
    }

    public HTMLPrinter printlnAhref(String string, String string2, String string3) {
        this.printOTag("a", new XMLAttribute[]{new XMLAttribute("href", string), new XMLAttribute("target", string2)});
        this.print(string3);
        return this.printlnCTag("a");
    }

    public HTMLPrinter printlnAname(String string, String string2) {
        this.printOTag("a", new XMLAttribute[]{new XMLAttribute("name", string)});
        this.print(string2);
        return this.printlnCTag("a");
    }

    public HTMLPrinter printlnBold(String string) {
        return this.printlnTag("b", string);
    }

    public HTMLPrinter printlnFontColor(String string, String string2) {
        return this.printlnTag("font", new XMLAttribute[]{new XMLAttribute("color", string)}, string2);
    }

    public HTMLPrinter printlnComment(String string) {
        this.printer.print("<!--");
        this.printer.print(string);
        this.printer.println("-->");
        return this;
    }

    public HTMLPrinter printlnScript(String string) {
        this.printOTag("script", new XMLAttribute[]{new XMLAttribute("type", "text/javascript"), new XMLAttribute("src", string)});
        return this.printlnCTag("script");
    }

    public HTMLPrinter printlnNbsp(int n) {
        return this.printNbsp(n).line();
    }

    public HTMLPrinter printlnHLine() {
        return this.printlnOTag("hr");
    }

    public HTMLPrinter printlnHLine(XMLAttribute[] xMLAttributeArray) {
        return this.printlnOTag("hr", xMLAttributeArray);
    }

    public HTMLPrinter printlnMeta(XMLAttribute[] xMLAttributeArray) {
        return this.printlnOTag("meta", xMLAttributeArray);
    }

    public HTMLPrinter printlnLink(XMLAttribute[] xMLAttributeArray) {
        return this.printlnOTag("link", xMLAttributeArray);
    }

    public HTMLPrinter print(boolean bl) {
        this.printer.print(bl);
        return this;
    }

    public HTMLPrinter print(byte by) {
        this.printer.print(by);
        return this;
    }

    public HTMLPrinter print(short s) {
        this.printer.print(s);
        return this;
    }

    public HTMLPrinter print(char c) {
        this.printer.print(c);
        return this;
    }

    public HTMLPrinter print(int n) {
        this.printer.print(n);
        return this;
    }

    public HTMLPrinter print(long l) {
        this.printer.print(l);
        return this;
    }

    public HTMLPrinter print(float f) {
        this.printer.print(f);
        return this;
    }

    public HTMLPrinter print(double d) {
        this.printer.print(d);
        return this;
    }

    public HTMLPrinter print(String string) {
        this.printer.print(string);
        return this;
    }

    public HTMLPrinter printOTag(String string) {
        this.printer.print("<");
        this.printer.print(string);
        this.printer.print(">");
        return this;
    }

    public HTMLPrinter printOTag(String string, XMLAttribute[] xMLAttributeArray) {
        this.printer.print("<");
        this.printer.print(string);
        this.printer.print(" ");
        this.printer.print(StringOf.object.array(xMLAttributeArray, "", " ", ""));
        this.printer.print(">");
        return this;
    }

    public HTMLPrinter printCTag(String string) {
        this.printer.print("</");
        this.printer.print(string);
        this.printer.print(">");
        return this;
    }

    public HTMLPrinter printTag(String string, String string2) {
        this.printOTag(string);
        this.print(string2);
        return this.printCTag(string);
    }

    public HTMLPrinter printTag(String string, XMLAttribute[] xMLAttributeArray, String string2) {
        this.printOTag(string, xMLAttributeArray);
        this.print(string2);
        this.printCTag(string);
        return this;
    }

    public HTMLPrinter printSTag(String string) {
        this.printer.print("<");
        this.printer.print(string);
        this.printer.print("/>");
        return this;
    }

    public HTMLPrinter printAhref(String string, String string2) {
        this.printOTag("a", new XMLAttribute[]{new XMLAttribute("href", string)});
        this.print(string2);
        return this.printCTag("a");
    }

    public HTMLPrinter printAhref(String string, String string2, String string3) {
        this.printOTag("a", new XMLAttribute[]{new XMLAttribute("href", string), new XMLAttribute("target", string2)});
        this.print(string3);
        return this.printCTag("a");
    }

    public HTMLPrinter printAname(String string, String string2) {
        this.printOTag("a", new XMLAttribute[]{new XMLAttribute("name", string)});
        this.print(string2);
        return this.printCTag("a");
    }

    public HTMLPrinter printBold(String string) {
        return this.printTag("b", string);
    }

    public HTMLPrinter printFontColor(String string, String string2) {
        return this.printTag("font", new XMLAttribute[]{new XMLAttribute("color", string)}, string2);
    }

    public HTMLPrinter printComment(String string) {
        this.printer.print("<!-- ");
        this.printer.print(string);
        this.printer.print(" -->");
        return this;
    }

    public HTMLPrinter printNbsp(int n) {
        while (n > 0) {
            this.print("&nbsp;");
            --n;
        }
        return this;
    }

    public HTMLPrinter printHLine() {
        return this.printOTag("hr");
    }

    public HTMLPrinter printHLine(XMLAttribute[] xMLAttributeArray) {
        return this.printOTag("hr", xMLAttributeArray);
    }

    public String toString() {
        return this.printer.toString();
    }

    protected void printPreamble() {
        this.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("<!DOCTYPE html PUBLIC \"-//W3C//DTD ".concat(String.valueOf(String.valueOf(this.representation.getType()))))).concat("//"))).concat(String.valueOf(String.valueOf(this.representation.getLanguage()))))).concat("\">"));
        this.printlnOTag("html").line();
    }

    protected void printMetaInfo(XMLAttribute[] xMLAttributeArray) {
        this.printlnMeta(new XMLAttribute[]{new XMLAttribute("http-equiv", "content-type"), new XMLAttribute("content", "text/html; charset=".concat(String.valueOf(String.valueOf(this.representation.getEncoding()))))});
        for (int i = 0; i < xMLAttributeArray.length; ++i) {
            this.printlnMeta(new XMLAttribute[]{new XMLAttribute("name", xMLAttributeArray[i].name), new XMLAttribute("content", xMLAttributeArray[i].value)});
        }
    }

    protected void printlnStyle(String string) {
        this.printlnLink(new XMLAttribute[]{new XMLAttribute("rel", "stylesheet"), new XMLAttribute("type", "text/css"), new XMLAttribute("href", string)});
    }

    public void printHeader(XMLAttribute[] xMLAttributeArray, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.printPreamble();
        this.printlnOTag("head").indent();
        this.printlnTag("title", this.title);
        for (int i = 0; i < stringArray.length; ++i) {
            this.printlnComment(stringArray[i]);
        }
        this.printMetaInfo(xMLAttributeArray);
        for (int i = 0; i < stringArray2.length; ++i) {
            this.printlnStyle(stringArray2[i]);
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            this.printlnScript(stringArray3[i]);
        }
        this.undent().printlnCTag("head").line();
    }

    public void printHeader(XMLAttribute[] xMLAttributeArray, String string, String string2, String string3) {
        this.printHeader(xMLAttributeArray, new String[]{string}, new String[]{string2}, new String[]{string3});
    }

    public void printHeader(XMLAttribute[] xMLAttributeArray, String string, String string2) {
        this.printHeader(xMLAttributeArray, string, string2, this.script);
    }

    public void printHeader(XMLAttribute[] xMLAttributeArray, String string) {
        this.printHeader(xMLAttributeArray, string, this.stylesheet);
    }

    public void printHeader(XMLAttribute[] xMLAttributeArray) {
        this.printHeader(xMLAttributeArray, null);
    }

    public void printOpenBody(XMLAttribute[] xMLAttributeArray) {
        this.printlnOTag("body", xMLAttributeArray).indent();
    }

    public void printOpenBody() {
        this.printlnOTag("body").indent();
    }

    public void printFootpage() {
        this.undent().printlnCTag("body");
        this.printlnCTag("html");
    }
}

