/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scaladoc;

import ch.epfl.lamp.util.HTMLPrinter;
import ch.epfl.lamp.util.HTMLRepresentation;
import ch.epfl.lamp.util.Pair;
import ch.epfl.lamp.util.XMLAttribute;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.tools.scaladoc.Comment;
import scala.tools.scaladoc.DocSyms;
import scala.tools.scaladoc.HTMLGeneratorCommand;
import scala.tools.scaladoc.HTMLValidator;
import scala.tools.scaladoc.HTTPServer;
import scala.tools.scaladoc.Location;
import scala.tools.scaladoc.MySymbolTablePrinter;
import scala.tools.scaladoc.Page;
import scala.tools.scaladoc.Promise;
import scala.tools.scaladoc.ScalaSearch;
import scala.tools.scaladoc.SearchResult;
import scala.tools.scaladoc.Servlet;
import scala.tools.scaladoc.SymbolBooleanFunction;
import scala.tools.scaladoc.SymbolTablePrinterFactory;
import scala.tools.scaladoc.Tag;
import scala.tools.scaladoc.TypeIsomorphism;
import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.symtab.Modifiers;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.ScalaProgramArgumentParser;

public abstract class HTMLGenerator {
    protected final String FRAME_PAGE = "index.html";
    protected final String ROOT_PAGE = "root-page.html";
    protected final String PACKAGE_INDEX_PAGE = "package-index-page.html";
    protected final String HELP_PAGE = "help-page.html";
    protected final String SEARCH_SECTION = "search-section";
    protected final String INDEX_PAGE = "index-page.html";
    protected final String PACKAGE_PAGE = "package-page.html";
    protected final String ROOT_FRAME = "rootFrame";
    protected final String PACKAGES_FRAME = "packagesFrame";
    protected final String CLASSES_FRAME = "classesFrame";
    protected final String SELF_FRAME = "_self";
    protected final String[] HTML_DTD = new String[]{"xhtml1-transitional.dtd", "xhtml-lat1.ent", "xhtml-special.ent", "xhtml-symbol.ent"};
    protected HTMLValidator xhtml;
    protected final XMLAttribute[] ATTRS_DOCTAG = new XMLAttribute[]{new XMLAttribute("style", "margin-top:10px;")};
    protected final XMLAttribute[] ATTRS_ENTITY = new XMLAttribute[]{new XMLAttribute("class", "entity")};
    protected final XMLAttribute[] ATTRS_LIST = new XMLAttribute[]{new XMLAttribute("class", "list")};
    protected final XMLAttribute[] ATTRS_MEMBER = new XMLAttribute[]{new XMLAttribute("cellpadding", "3"), new XMLAttribute("class", "member")};
    protected final XMLAttribute[] ATTRS_MEMBER_DETAIL = new XMLAttribute[]{new XMLAttribute("cellpadding", "3"), new XMLAttribute("class", "member-detail")};
    protected final XMLAttribute[] ATTRS_MEMBER_TITLE = new XMLAttribute[]{new XMLAttribute("class", "member-title")};
    protected final XMLAttribute[] ATTRS_MODIFIERS = new XMLAttribute[]{new XMLAttribute("valign", "top"), new XMLAttribute("class", "modifiers")};
    protected final XMLAttribute[] ATTRS_NAVIGATION = new XMLAttribute[]{new XMLAttribute("class", "navigation")};
    protected final XMLAttribute[] ATTRS_NAVIGATION_LINKS = new XMLAttribute[]{new XMLAttribute("valign", "top"), new XMLAttribute("class", "navigation-links")};
    protected final XMLAttribute[] ATTRS_NAVIGATION_ENABLED = new XMLAttribute[]{new XMLAttribute("class", "navigation-enabled")};
    protected final XMLAttribute[] ATTRS_NAVIGATION_SELECTED = new XMLAttribute[]{new XMLAttribute("class", "navigation-selected")};
    protected final XMLAttribute[] ATTRS_NAVIGATION_PRODUCT = new XMLAttribute[]{new XMLAttribute("align", "right"), new XMLAttribute("valign", "top"), new XMLAttribute("style", "white-space:nowrap;"), new XMLAttribute("rowspan", "2")};
    protected final XMLAttribute[] ATTRS_PAGE_TITLE = new XMLAttribute[]{new XMLAttribute("class", "page-title")};
    protected final XMLAttribute[] ATTRS_SIGNATURE = new XMLAttribute[]{new XMLAttribute("class", "signature")};
    protected final XMLAttribute[] ATTRS_TITLE_SUMMARY = new XMLAttribute[]{new XMLAttribute("colspan", "2"), new XMLAttribute("class", "title")};
    protected final XMLAttribute[] ATTRS_VALIDATION = new XMLAttribute[]{new XMLAttribute("style", "margin-top:5px; text-align:center; font-size:9pt;")};
    public static final String PRODUCT;
    public static final String VERSION;
    protected final String GENERATOR = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(PRODUCT)).concat(" ("))).concat(String.valueOf(String.valueOf(VERSION))))).concat(")");
    protected final SimpleDateFormat df = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
    protected final XMLAttribute[] ATTRS_META = new XMLAttribute[]{new XMLAttribute("generator", this.GENERATOR)};
    protected final Global global;
    protected File directory;
    protected Map comments = new HashMap();
    public Page page;
    protected URI uri;
    protected MySymbolTablePrinter symtab;
    protected HTMLRepresentation representation;
    protected String windowtitle;
    protected String doctitle;
    protected String stylesheet;
    protected boolean noindex;
    protected boolean validate;
    protected boolean launchServer;
    protected int port;
    protected final Stack stack = new Stack();
    private final int ROOT_NAV_CONTEXT = 0;
    private final int INDEX_NAV_CONTEXT = 1;
    private final int HELP_NAV_CONTEXT = 2;
    private final int CONTAINER_NAV_CONTEXT = 3;
    public static final String DEFAULT_DOCTITLE = "";
    public static final String DEFAULT_WINDOWTITLE = "Generated Documentation";
    protected final Symbol root;
    protected SymbolBooleanFunction isDocumented;
    public Map promises;
    public static String SEARCH_SERVLET_NAME;
    public static String PAGE_SERVLET_NAME;
    private static final /* synthetic */ boolean $assertionsDisabled;

    protected String getGenerator() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("Generated by ".concat(String.valueOf(String.valueOf(this.GENERATOR))))).concat(" on "))).concat(String.valueOf(String.valueOf(this.df.format(new Date()))));
    }

    public abstract TypeIsomorphism newTypeIso(Global var1);

    protected HTMLGenerator(Global global) {
        this.global = global;
        this.root = global.definitions.ROOT_CLASS;
        this.uri = Location.makeURI(".");
        this.promises = new HashMap();
        if (!$assertionsDisabled && !(global.args instanceof HTMLGeneratorCommand)) {
            throw new AssertionError();
        }
        HTMLGeneratorCommand hTMLGeneratorCommand = (HTMLGeneratorCommand)global.args;
        this.representation = new HTMLRepresentation(hTMLGeneratorCommand.doctype.value, hTMLGeneratorCommand.docencoding.value, "EN");
        this.windowtitle = hTMLGeneratorCommand.windowtitle.value;
        this.doctitle = hTMLGeneratorCommand.doctitle.value;
        this.stylesheet = hTMLGeneratorCommand.stylesheet.value;
        this.noindex = hTMLGeneratorCommand.noindex.value;
        this.validate = hTMLGeneratorCommand.validate.value;
        this.launchServer = hTMLGeneratorCommand.server.value;
        try {
            this.port = Integer.parseInt(hTMLGeneratorCommand.port.value);
        }
        catch (NumberFormatException numberFormatException) {
            this.port = 1280;
        }
        Symbol[] symbolArray = this.getPackages(hTMLGeneratorCommand.packages);
        DocSyms docSyms = new DocSyms(global, symbolArray);
        this.isDocumented = new 0(docSyms, this);
    }

    public URI adaptURI(URI uRI, URI uRI2) {
        if (this.launchServer) {
            return Location.mkURI(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(PAGE_SERVLET_NAME)).concat("?"))).concat("page="))).concat(String.valueOf(String.valueOf(uRI.getPath()))))).concat("#"))).concat(String.valueOf(String.valueOf(uRI.getFragment()))));
        }
        return Location.asSeenFrom(uRI, uRI2);
    }

    protected URI definitionURI(Symbol symbol, Page page) {
        URI uRI = Location.getURI(symbol);
        return this.adaptURI(uRI, page.uri);
    }

    protected URI definitionURI(Symbol symbol) {
        return this.definitionURI(symbol, this.page);
    }

    protected Symbol[] getPackages(ScalaProgramArgumentParser scalaProgramArgumentParser) {
        if (scalaProgramArgumentParser.main != null) {
            Symbol[] symbolArray = new Symbol[scalaProgramArgumentParser.args.length + 1];
            symbolArray[0] = this.global.definitions.getModule(scalaProgramArgumentParser.main);
            for (int i = 0; i < scalaProgramArgumentParser.args.length; ++i) {
                symbolArray[i + 1] = this.global.definitions.getModule(scalaProgramArgumentParser.args[i]);
            }
            return symbolArray;
        }
        return new Symbol[]{this.root};
    }

    protected static Writer fileWriter(File file, String string) {
        try {
            File file2 = new File(file, string);
            file2.getParentFile().mkdirs();
            return new BufferedWriter(new FileWriter(file2));
        }
        catch (IOException iOException) {
            throw Debug.abort(iOException);
        }
    }

    protected void createPrinters(Writer writer, URI uRI, String string, String string2) {
        this.stack.push(this.page);
        this.stack.push(this.symtab);
        this.page = new Page(writer, uRI, string2, string, this.representation, this.adaptURI(Location.mkURI("style.css"), uRI).toString(), this.adaptURI(Location.mkURI("script.js"), uRI).toString());
        this.symtab = SymbolTablePrinterFactory.makeHTML(this, this.page, this.isDocumented);
        this.page.open();
    }

    protected void closePrinters() {
        this.symtab = (MySymbolTablePrinter)this.stack.pop();
        this.page = (Page)this.stack.pop();
    }

    private boolean checkOutpath() {
        String string = String.valueOf(String.valueOf("Output path \"".concat(String.valueOf(String.valueOf(this.global.outpath))))).concat("\" ");
        boolean bl = false;
        try {
            this.directory = new File(this.global.outpath);
            if (!this.directory.exists()) {
                this.global.reporter.error(null, String.valueOf(String.valueOf(string)).concat("does not exist"));
            } else if (!this.directory.isDirectory()) {
                this.global.reporter.error(null, String.valueOf(String.valueOf(string)).concat("is not a directory"));
            } else if (!this.directory.canWrite()) {
                this.global.reporter.error(null, String.valueOf(String.valueOf(string)).concat("cannot be modified"));
            } else {
                bl = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.global.reporter.error(null, ((Throwable)nullPointerException).getMessage());
        }
        return bl;
    }

    public void apply() {
        Promise promise;
        if (!this.launchServer && !this.checkOutpath()) {
            return;
        }
        this.xhtml = new HTMLValidator(this.getResourceURL(this.HTML_DTD[0]));
        PackageIndexPromise packageIndexPromise = new PackageIndexPromise();
        this.promises.put(((Promise)packageIndexPromise).name(), packageIndexPromise);
        ScalaSearch.foreach(this.root, new 1());
        if (!this.noindex) {
            promise = new IndexPromise();
            this.promises.put(promise.name(), promise);
        }
        promise = new HelpPromise();
        this.promises.put(promise.name(), promise);
        FramePromise framePromise = new FramePromise();
        this.promises.put(((Promise)framePromise).name(), framePromise);
        ResourcePromise resourcePromise = new ResourcePromise("style.css", null);
        this.promises.put(((Promise)resourcePromise).name(), resourcePromise);
        ResourcePromise resourcePromise2 = new ResourcePromise("script.js", null);
        this.promises.put(((Promise)resourcePromise2).name(), resourcePromise2);
        if (this.launchServer) {
            this.launchServer();
        } else {
            Iterator iterator = this.promises.values().iterator();
            while (iterator.hasNext()) {
                Promise promise2 = (Promise)iterator.next();
                Writer writer = HTMLGenerator.fileWriter(this.directory, promise2.name());
                promise2.writeOn(writer);
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    protected void launchServer() {
        Object object;
        PageServlet pageServlet = new PageServlet();
        SearchServlet searchServlet = new SearchServlet();
        Servlet[] servletArray = new Servlet[]{pageServlet, searchServlet};
        try {
            object = new HTTPServer(this.directory, this.port, servletArray);
            ((Thread)object).start();
        }
        catch (IOException iOException) {
            System.out.println("Server could not start because of an ".concat(String.valueOf(String.valueOf(iOException.getClass()))));
            System.out.println(iOException);
        }
        try {
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    throw throwable;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Error while waiting.");
            System.exit(0);
        }
    }

    protected Comment getComment(Symbol symbol) {
        Comment comment = (Comment)this.comments.get(symbol);
        if (comment == null) {
            Pair pair = (Pair)this.global.mapSymbolComment.get(symbol);
            if (pair != null) {
                String string = (String)pair.fst;
                CompilationUnit compilationUnit = (CompilationUnit)pair.snd;
                comment = new Comment(string, symbol, compilationUnit, this.xhtml);
            } else {
                Symbol symbol2 = ScalaSearch.overridenBySymbol(symbol);
                comment = symbol2 == Symbol.NONE ? new Comment(null, symbol, null, this.xhtml) : this.getComment(symbol2);
            }
            this.comments.put(symbol, comment);
        }
        return comment;
    }

    protected String filterModifiers(Symbol symbol) {
        int n = symbol.flags;
        if ((symbol.isPackage() || symbol.isPackageClass()) && (n & 2) != 0) {
            n -= 2;
        }
        if (symbol.isModule() && (n & 2) != 0) {
            n -= 2;
        }
        if (symbol.isTrait()) {
            if ((n & 0x80) != 0) {
                n -= 128;
            }
            if ((n & 0x10000000) != 0) {
                n -= 0x10000000;
            }
        }
        return Modifiers.Helper.toString(n);
    }

    protected void addDocumentationTitle(XMLAttribute[] xMLAttributeArray, Page page) {
        page.printlnOTag("div", xMLAttributeArray).indent();
        page.println(this.doctitle).undent();
        page.printlnCTag("div");
    }

    protected void addDocumentationTitle(XMLAttribute[] xMLAttributeArray) {
        this.addDocumentationTitle(xMLAttributeArray, this.page);
    }

    protected void addSearchSection(Page page) {
        page.printlnOTag("form", new XMLAttribute[]{new XMLAttribute("action", "/".concat(String.valueOf(String.valueOf(SEARCH_SERVLET_NAME)))), new XMLAttribute("method", "get")}).indent();
        page.printlnOTag("table", new XMLAttribute[]{new XMLAttribute("border", "0")}).indent();
        page.printlnOTag("tr").indent();
        page.printlnOTag("td").indent();
        page.printlnSTag("input", new XMLAttribute[]{new XMLAttribute("name", "searchString"), new XMLAttribute("id", "word"), new XMLAttribute("size", "100%"), new XMLAttribute("type", "text")});
        page.printlnSTag("input", new XMLAttribute[]{new XMLAttribute("type", "submit"), new XMLAttribute("value", "Search")}).undent();
        page.printlnCTag("td").undent();
        page.printlnCTag("tr");
        page.printlnOTag("tr").indent();
        page.printlnOTag("td", new XMLAttribute[]{new XMLAttribute("align", "center")}).indent();
        page.printlnSTag("input", new XMLAttribute[]{new XMLAttribute("type", "radio"), new XMLAttribute("checked", "true"), new XMLAttribute("name", "searchKind"), new XMLAttribute("id", "byName"), new XMLAttribute("value", "byName")});
        page.println("By name");
        page.printlnSTag("input", new XMLAttribute[]{new XMLAttribute("type", "radio"), new XMLAttribute("name", "searchKind"), new XMLAttribute("id", "byComment"), new XMLAttribute("value", "byComment")});
        page.println("By comment");
        page.printlnSTag("input", new XMLAttribute[]{new XMLAttribute("type", "radio"), new XMLAttribute("name", "searchKind"), new XMLAttribute("id", "byType"), new XMLAttribute("value", "byType")});
        page.println("By type").undent();
        page.printlnCTag("td").undent();
        page.printlnCTag("tr").undent();
        page.printlnCTag("table").undent();
        page.printlnCTag("form");
    }

    protected void addSearchSection() {
        this.addSearchSection(this.page);
    }

    protected void addNavigationBar(int n, Page page) {
        try {
            String string = this.adaptURI(Location.mkURI("root-page.html"), page.uri).toString();
            String string2 = this.adaptURI(Location.mkURI("index-page.html"), page.uri).toString();
            String string3 = this.adaptURI(Location.mkURI("help-page.html"), page.uri).toString();
            page.printlnOTag("table", this.ATTRS_NAVIGATION).indent();
            page.printlnOTag("tr").indent();
            page.printlnOTag("td", this.ATTRS_NAVIGATION_LINKS).indent();
            page.printlnOTag("table").indent();
            page.printlnOTag("tr").indent();
            if (n == 0) {
                page.printlnTag("td", this.ATTRS_NAVIGATION_SELECTED, "Overview");
            } else {
                page.printOTag("td", this.ATTRS_NAVIGATION_ENABLED);
                page.printAhref(string, "_self", "Overview");
                page.printlnCTag("td");
            }
            if (n == 1) {
                page.printlnTag("td", this.ATTRS_NAVIGATION_SELECTED, "Index");
            } else {
                page.printOTag("td", this.ATTRS_NAVIGATION_ENABLED);
                page.printAhref(string2, "_self", "Index");
                page.printlnCTag("td");
            }
            if (n == 2) {
                page.printlnTag("td", this.ATTRS_NAVIGATION_SELECTED, "Help");
            } else {
                page.printOTag("td", this.ATTRS_NAVIGATION_ENABLED);
                page.printAhref(string3, "_self", "Help");
                page.printlnCTag("td");
            }
            page.undent();
            page.printlnCTag("tr").undent();
            page.printlnCTag("table").undent();
            page.printlnCTag("td");
            page.printlnOTag("td", this.ATTRS_NAVIGATION_PRODUCT).indent();
            this.addDocumentationTitle(new XMLAttribute[]{new XMLAttribute("class", "doctitle")}, page);
            page.undent();
            page.printlnCTag("td").undent();
            page.printlnCTag("tr");
            page.printlnOTag("tr").indent();
            page.printlnTag("td", "&nbsp;").undent();
            page.printlnCTag("tr").undent();
            if (this.launchServer) {
                page.printlnOTag("tr").indent();
                this.addSearchSection(page);
                page.undent();
                page.printlnCTag("tr");
            }
            page.printlnCTag("table");
        }
        catch (Exception exception) {
            throw Debug.abort(exception);
        }
    }

    protected void addNavigationBar(int n) {
        this.addNavigationBar(n, this.page);
    }

    protected void addValidationBar() {
        this.page.printlnOTag("div", this.ATTRS_VALIDATION);
        this.page.indent();
        this.page.printlnAhref("http://validator.w3.org/check/referer", "_self", "validate html");
        this.page.undent();
        this.page.printlnCTag("div");
    }

    protected void addTitle(Symbol symbol) {
        if (symbol.isRoot()) {
            this.page.printlnOTag("div", this.ATTRS_PAGE_TITLE).indent();
            this.page.println(this.doctitle.replaceAll("<.*>", " "));
            this.page.printlnSTag("br");
            this.page.println("API Specification").undent();
            this.page.printlnCTag("div");
            this.page.println(String.valueOf(String.valueOf("This document is the API specification for ".concat(String.valueOf(String.valueOf(this.doctitle.replaceAll("<.*>", " ")))))).concat("."));
            this.page.printlnSTag("p");
        } else {
            List list;
            this.page.print("in ");
            this.printPath(symbol.owner(), "_self");
            this.page.printlnOTag("div", this.ATTRS_ENTITY).indent();
            this.page.print(String.valueOf(String.valueOf(this.symtab.getSymbolKeywordForDoc(symbol))).concat(" "));
            this.page.printlnTag("span", this.ATTRS_ENTITY, symbol.nameString()).undent();
            this.page.printlnCTag("div");
            this.page.printlnHLine();
            this.printTemplateHtmlSignature(symbol, false);
            Map map = ScalaSearch.subTemplates(this.root, this.isDocumented);
            if (symbol.isClass() && (list = (List)map.get(symbol)) != null && list.size() != 0) {
                this.page.printlnOTag("dl").indent();
                this.page.printlnOTag("dt");
                this.page.printlnBold("Implementing classes or objects:");
                this.page.printlnCTag("dt");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    Symbol symbol2 = (Symbol)pair.fst;
                    this.page.printlnOTag("dd");
                    this.symtab.defString(symbol2, true);
                    if (symbol2.owner() != symbol.owner()) {
                        this.page.print(" in ");
                        this.printPath(symbol2.owner(), "_self");
                    }
                    this.page.printlnCTag("dd");
                }
                this.page.undent();
                this.page.printlnCTag("dl");
            }
        }
    }

    protected void addDocumentationComment(Symbol symbol) {
        Comment comment = this.getComment(symbol);
        if (!comment.isEmpty()) {
            this.page.printlnHLine();
            this.addComments(comment);
        }
    }

    protected void addMemberSummary(Symbol[] symbolArray, String string) {
        if (symbolArray.length > 0) {
            Symbol[] symbolArray2 = new Symbol[symbolArray.length];
            for (int i = 0; i < symbolArray.length; ++i) {
                if (!$assertionsDisabled && symbolArray[i] == null) {
                    throw new AssertionError((Object)"HA ENFIN !");
                }
                symbolArray2[i] = symbolArray[i];
            }
            Arrays.sort(symbolArray2, ScalaSearch.symAlphaOrder);
            this.page.printlnOTag("table", this.ATTRS_MEMBER).indent();
            this.page.printlnOTag("tr").indent();
            this.page.printlnOTag("td", this.ATTRS_TITLE_SUMMARY).indent();
            this.page.println(string).undent();
            this.page.printlnCTag("td").undent();
            this.page.printlnCTag("tr");
            for (int i = 0; i < symbolArray.length; ++i) {
                this.addMemberSummary(symbolArray2[i]);
            }
            this.page.undent();
            this.page.printlnCTag("table");
            this.page.printlnSTag("br");
        }
    }

    protected void addMemberSummary(Symbol symbol) {
        this.page.printlnOTag("tr").indent();
        String string = this.filterModifiers(symbol);
        this.page.printlnOTag("td", this.ATTRS_MODIFIERS).indent();
        if (string.length() > 0) {
            this.page.printlnTag("code", string);
        } else {
            this.page.printlnNbsp(1);
        }
        this.page.undent();
        this.page.printlnCTag("td");
        this.page.printlnOTag("td", this.ATTRS_SIGNATURE).indent();
        this.page.printOTag("code");
        this.symtab.defString(symbol, true);
        this.page.printlnCTag("code");
        String string2 = this.firstSentence(this.getComment(symbol));
        if (!string2.equals(DEFAULT_DOCTITLE)) {
            this.page.printlnSTag("br");
            this.page.printNbsp(4);
            this.page.println(string2);
        }
        this.page.undent();
        this.page.printlnCTag("td").undent();
        this.page.printlnCTag("tr");
    }

    protected void addMemberDetail(Symbol[] symbolArray, String string) {
        boolean bl = true;
        for (int i = 0; i < symbolArray.length; ++i) {
            Symbol symbol = symbolArray[i];
            if (ScalaSearch.isContainer(symbol)) continue;
            if (bl) {
                this.page.printlnOTag("table", this.ATTRS_MEMBER_DETAIL).indent();
                this.page.printlnOTag("tr").indent();
                this.page.printlnTag("td", this.ATTRS_MEMBER_TITLE, string).undent();
                this.page.printlnCTag("tr").undent();
                this.page.printlnCTag("table");
                bl = false;
            } else {
                this.page.printlnHLine();
            }
            this.addMemberDetail(symbol);
        }
    }

    protected void addMemberDetail(Symbol symbol) {
        this.page.printlnAname(Location.getURI(symbol).getFragment(), DEFAULT_DOCTITLE);
        this.page.printTag("h3", symbol.nameString());
        this.page.printlnOTag("pre");
        String string = this.filterModifiers(symbol);
        if (string.length() > 0) {
            this.page.print(String.valueOf(String.valueOf(string)).concat(" "));
        }
        this.symtab.printSignature(symbol, false);
        this.page.printlnCTag("pre");
        this.addComments(this.getComment(symbol));
    }

    protected void addInheritedMembers(Symbol symbol, String string) {
        Symbol[] symbolArray = ScalaSearch.collectMembers(symbol);
        Pair pair = ScalaSearch.groupSymbols(symbolArray);
        Symbol[] symbolArray2 = (Symbol[])pair.fst;
        Map map = (Map)pair.snd;
        for (int i = 0; i < symbolArray2.length; ++i) {
            if (symbolArray2[i] == (symbol.isModule() ? symbol.moduleClass() : symbol)) continue;
            this.page.printlnOTag("table", this.ATTRS_MEMBER).indent();
            this.page.printlnOTag("tr").indent();
            this.page.printlnOTag("td", new XMLAttribute[]{new XMLAttribute("class", "inherited-owner")}).indent();
            this.page.print(String.valueOf(String.valueOf(string)).concat(" inherited from "));
            this.printPath(symbolArray2[i], "_self");
            this.page.undent();
            this.page.printlnCTag("td").undent();
            this.page.printlnCTag("tr");
            this.page.printlnOTag("tr").indent();
            this.page.printlnOTag("td", new XMLAttribute[]{new XMLAttribute("class", "inherited-members")}).indent();
            Symbol[] symbolArray3 = (Symbol[])map.get(symbolArray2[i]);
            for (int j = 0; j < symbolArray3.length; ++j) {
                if (j > 0) {
                    this.page.print(", ");
                }
                this.symtab.printSymbol(symbolArray3[j], true);
            }
            this.page.undent();
            this.page.printlnCTag("td").undent();
            this.page.printlnCTag("tr").undent();
            this.page.printlnCTag("table");
            this.page.printlnSTag("br");
        }
    }

    public void printTemplateHtmlSignature(Symbol symbol, boolean bl) {
        int n;
        Modifiers[] modifiersArray;
        String string = this.filterModifiers(symbol);
        this.page.printlnOTag("dl");
        this.page.printlnOTag("dt");
        this.symtab.print(string).space();
        String string2 = this.symtab.getSymbolKeywordForDoc(symbol);
        if (string2 != null) {
            this.symtab.print(string2).space();
        }
        this.symtab.getSymbolInnerString(symbol);
        this.symtab.printDefinedSymbolName(symbol, bl);
        if (symbol.isClass()) {
            modifiersArray = symbol.typeParams();
            if (modifiersArray.length != 0 || this.global.debug) {
                this.symtab.print('[');
                for (n = 0; n < modifiersArray.length; ++n) {
                    if (n > 0) {
                        this.symtab.print(",");
                    }
                    this.symtab.printSignature((Symbol)modifiersArray[n], false);
                }
                this.symtab.print(']');
            }
            this.symtab.printValueParams(symbol.valueParams());
        }
        modifiersArray = (symbol.isModule() ? symbol.moduleClass() : symbol).parents();
        this.page.printlnCTag("dt");
        for (n = 0; n < modifiersArray.length; ++n) {
            this.page.printOTag("dd");
            this.symtab.print(n == 0 ? "extends " : "with ");
            this.symtab.printType((Type)modifiersArray[n]);
            this.page.printlnCTag("dd");
        }
        this.page.printCTag("dl");
    }

    protected String getResourceURL(String string) {
        String string2 = Class.forName("scala.tools.scaladoc.HTMLGenerator").getResource("resources/".concat(String.valueOf(String.valueOf(string)))).toString();
        return string2;
    }

    private String removeHtmlSuffix(String string) {
        return string.substring(0, string.length() - 5);
    }

    private String packageSummaryPage(Symbol symbol) {
        if (symbol.isRoot()) {
            return "package-page.html";
        }
        String string = Location.getURI(symbol).toString();
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.removeHtmlSuffix(string))).concat("/"))).concat("package-page.html");
    }

    private void printPackagesTable(Symbol[] symbolArray, String string) {
        if (symbolArray.length > 0) {
            this.page.printlnBold(string);
            this.page.printlnOTag("table", this.ATTRS_LIST).indent();
            this.page.printlnOTag("tr").indent();
            this.page.printlnOTag("td", new XMLAttribute[]{new XMLAttribute("style", "white-space:nowrap;")}).indent();
            for (int i = 1; i < symbolArray.length; ++i) {
                Symbol symbol = symbolArray[i];
                this.page.printAhref(this.adaptURI(Location.mkURI(this.packageSummaryPage(symbol)), this.page.uri).toString(), "classesFrame", this.removeHtmlSuffix(Location.getURI(symbol).toString()));
                this.page.printlnSTag("br");
            }
            this.page.undent();
            this.page.printlnCTag("td").undent();
            this.page.printlnCTag("tr").undent();
            this.page.printlnCTag("table");
            this.page.printlnSTag("p");
        }
    }

    private void addSymbolTable(Symbol[] symbolArray, String string, boolean bl) {
        if (symbolArray.length > 0) {
            this.page.printlnBold(string);
            this.page.printlnOTag("table", this.ATTRS_LIST).indent();
            this.page.printlnOTag("tr").indent();
            this.page.printlnOTag("td", new XMLAttribute[]{new XMLAttribute("style", "white-space:nowrap;")}).indent();
            for (int i = 0; i < symbolArray.length; ++i) {
                Symbol symbol = symbolArray[i];
                if (symbol.isRoot()) continue;
                String string2 = symbol.nameString();
                if (symbol.isPackage() || symbol.isPackageClass()) {
                    this.page.printAhref(this.definitionURI(symbol).toString(), "classesFrame", string2);
                } else {
                    this.page.printAhref(this.definitionURI(symbol).toString(), "rootFrame", string2);
                }
                this.page.printlnSTag("br");
            }
            this.page.undent();
            this.page.printlnCTag("td").undent();
            this.page.printlnCTag("tr").undent();
            this.page.printlnCTag("table");
            this.page.printlnSTag("p");
        }
    }

    protected void printPath(Symbol symbol, String string, Page page) {
        String string2 = this.removeHtmlSuffix(Location.getURI(symbol).toString());
        if (this.isDocumented.apply(symbol)) {
            String string3 = this.definitionURI(symbol, page).toString();
            page.printlnAhref(string3, string, string2);
        } else {
            page.println(string2);
        }
    }

    protected void printPath(Symbol symbol, String string) {
        this.printPath(symbol, string, this.page);
    }

    protected void addIndexEntry(Symbol symbol, Page page, MySymbolTablePrinter mySymbolTablePrinter) {
        String string = mySymbolTablePrinter.getSymbolKeywordForDoc(symbol);
        if (string != null) {
            page.print(string).space();
        }
        mySymbolTablePrinter.printDefinedSymbolName(symbol, true);
        if (!symbol.isRoot()) {
            page.print(" in ");
            this.printPath(symbol.owner(), "_self", page);
        }
    }

    protected void addIndexEntry(Symbol symbol) {
        this.addIndexEntry(symbol, this.page, this.symtab);
    }

    protected void addComments(Comment comment) {
        if (!comment.isEmpty()) {
            this.page.printlnOTag("dl").indent();
            this.page.printlnTag("dd", this.inlineLinkTags(comment.holder, comment.text));
            this.page.undent().printlnCTag("dl");
            this.addTags(comment.tags);
        }
    }

    protected String inlineLinkTags(Symbol symbol, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Tag[] tagArray = Comment.makeTags(symbol, string);
        for (int i = 0; i < tagArray.length; ++i) {
            if (tagArray[i].isText()) {
                stringBuffer.append(tagArray[i].text);
                continue;
            }
            if (!tagArray[i].isReference()) continue;
            stringBuffer.append(this.inlineRefTag(tagArray[i]));
        }
        return stringBuffer.toString();
    }

    protected String firstSentence(Comment comment) {
        return this.inlineLinkTags(comment.holder, comment.firstSentence());
    }

    private static String ahref(String string, String string2, String string3) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("<a href=\"".concat(String.valueOf(String.valueOf(string))))).concat("\" target=\""))).concat(String.valueOf(String.valueOf(string2))))).concat("\">"))).concat(String.valueOf(String.valueOf(string3))))).concat("/a>");
    }

    protected String inlineRefTag(Tag tag) {
        Tag.RefKind refKind = Tag.parseReference(tag);
        switch (refKind.$tag) {
            case 0: {
                Tag.RefKind.Bad bad = (Tag.RefKind.Bad)refKind;
                String string = bad.ref;
                return string;
            }
            case 3: {
                Tag.RefKind.Url url = (Tag.RefKind.Url)refKind;
                String string = url.ref;
                return string;
            }
            case 1: {
                Tag.RefKind.Literal literal = (Tag.RefKind.Literal)refKind;
                String string = literal.ref;
                return string;
            }
            case 2: {
                Tag.RefKind.Scala scala = (Tag.RefKind.Scala)refKind;
                String string = scala.container;
                String string2 = scala.member;
                String string3 = scala.label;
                Symbol symbol = this.findSymbolFromString(tag.holder, string, string2);
                if (symbol == Symbol.NONE) {
                    System.err.println("Warning: not found ".concat(String.valueOf(String.valueOf(tag))));
                    return tag.text;
                }
                if (!this.isDocumented.apply(symbol)) {
                    System.err.println("Warning: not referenced ".concat(String.valueOf(String.valueOf(tag))));
                    return tag.text;
                }
                String string4 = string3.equals(DEFAULT_DOCTITLE) ? symbol.nameString() : string3;
                return HTMLGenerator.ahref(this.definitionURI(symbol).toString(), "rootFrame", string4);
            }
        }
        throw Debug.abort("illegal case", tag);
    }

    protected void addTags(Tag[] tagArray) {
        if (tagArray.length > 0) {
            String string;
            String string2;
            Pair pair;
            Tag tag;
            Iterator iterator;
            Tag tag2 = null;
            Tag tag3 = null;
            Tag tag4 = null;
            LinkedList<Tag> linkedList = new LinkedList<Tag>();
            LinkedList<Tag> linkedList2 = new LinkedList<Tag>();
            LinkedList<Tag> linkedList3 = new LinkedList<Tag>();
            LinkedList<Tag> linkedList4 = new LinkedList<Tag>();
            LinkedList<Tag> linkedList5 = new LinkedList<Tag>();
            for (int i = 0; i < tagArray.length; ++i) {
                if ("@return".equals(tagArray[i].name)) {
                    tag2 = tagArray[i];
                    continue;
                }
                if ("@since".equals(tagArray[i].name)) {
                    tag3 = tagArray[i];
                    continue;
                }
                if ("@version".equals(tagArray[i].name)) {
                    tag4 = tagArray[i];
                    continue;
                }
                if ("@param".equals(tagArray[i].name)) {
                    linkedList.add(tagArray[i]);
                    continue;
                }
                if ("@see".equals(tagArray[i].name)) {
                    linkedList2.add(tagArray[i]);
                    continue;
                }
                if (tagArray[i].isException()) {
                    linkedList3.add(tagArray[i]);
                    continue;
                }
                if ("@author".equals(tagArray[i].name)) {
                    linkedList4.add(tagArray[i]);
                    continue;
                }
                linkedList5.add(tagArray[i]);
            }
            this.page.printlnOTag("dl");
            if (linkedList4.size() > 0) {
                this.addTagSection("Author");
                this.page.printlnOTag("dd").indent();
                iterator = linkedList4.iterator();
                tag = (Tag)iterator.next();
                this.page.print(tag.text);
                while (iterator.hasNext()) {
                    tag = (Tag)iterator.next();
                    this.page.print(", ".concat(String.valueOf(String.valueOf(tag.text))));
                }
                this.page.println().undent();
                this.page.printlnCTag("dd");
            }
            if (tag3 != null) {
                this.addTagSection("Since");
                this.page.printlnTag("dd", tag3.text);
            }
            if (tag4 != null) {
                this.addTagSection("Version");
                this.page.printlnTag("dd", tag4.text);
            }
            if (linkedList.size() > 0) {
                this.addTagSection("Parameters");
                iterator = linkedList.iterator();
                tag = null;
                while (iterator.hasNext()) {
                    tag = (Tag)iterator.next();
                    pair = Tag.split(tag.text);
                    string2 = (String)pair.fst;
                    string = (String)pair.snd;
                    this.page.printOTag("dd");
                    this.page.printTag("code", string2);
                    this.page.println(" - ");
                    this.page.println(this.inlineLinkTags(tag.holder, string));
                    this.page.printlnCTag("dd");
                }
            }
            if (tag2 != null) {
                this.addTagSection("Returns");
                this.page.printlnTag("dd", tag2.text);
            }
            if (linkedList3.size() > 0) {
                this.addTagSection("Throws");
                iterator = linkedList3.iterator();
                tag = null;
                while (iterator.hasNext()) {
                    tag = (Tag)iterator.next();
                    pair = Tag.split(tag.text);
                    string2 = (String)pair.fst;
                    string = (String)pair.snd;
                    this.page.printOTag("dd");
                    this.page.printTag("code", string2);
                    this.page.println(" - ");
                    this.page.println(this.inlineLinkTags(tag.holder, string));
                    this.page.printlnCTag("dd");
                }
            }
            if (linkedList2.size() > 0) {
                this.addTagSection("See Also");
                this.page.printlnOTag("dd");
                iterator = linkedList2.iterator();
                tag = (Tag)iterator.next();
                this.page.println(this.inlineRefTag(tag));
                while (iterator.hasNext()) {
                    tag = (Tag)iterator.next();
                    this.page.print(", ");
                    this.page.println(this.inlineRefTag(tag));
                }
                this.page.printlnCTag("dd");
            }
            if (linkedList5.size() > 0) {
                iterator = linkedList5.iterator();
                while (iterator.hasNext()) {
                    this.addStandardTag((Tag)iterator.next());
                }
            }
            this.page.printlnCTag("dl");
        }
    }

    protected void addTagSection(String string) {
        this.page.printOTag("dt", this.ATTRS_DOCTAG);
        this.page.printBold(String.valueOf(String.valueOf(string)).concat(":"));
        this.page.printlnCTag("dt");
    }

    protected void addStandardTag(Tag tag) {
        String string = DEFAULT_DOCTITLE;
        if (tag.name.length() > 1) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(Character.toUpperCase(tag.name.charAt(1))));
            if (tag.name.length() > 2) {
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(tag.name.substring(2))));
            }
        }
        this.addTagSection(string);
        this.page.printTag("dd", this.inlineLinkTags(tag.holder, tag.text));
    }

    protected Symbol findSymbolFromString(Symbol symbol, String string, String string2) {
        return Symbol.NONE;
    }

    protected void addCategory(Symbol[] symbolArray, String string, Page page, MySymbolTablePrinter mySymbolTablePrinter) {
        if (symbolArray.length > 0) {
            page.printlnTag("h3", string);
            page.printlnOTag("dl").indent();
            for (int i = 0; i < symbolArray.length; ++i) {
                page.printOTag("dt");
                this.addIndexEntry(symbolArray[i], page, mySymbolTablePrinter);
                page.printlnCTag("dt");
                page.printlnTag("dd", this.firstSentence(this.getComment(symbolArray[i])));
            }
            page.undent().printlnCTag("dl");
        }
    }

    protected void addFoundSymbols(List list, Page page, MySymbolTablePrinter mySymbolTablePrinter) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        ScalaSearch.categorizeSymbols(list, linkedList, linkedList2, linkedList3);
        Symbol[] symbolArray = ScalaSearch.sortList(linkedList);
        Symbol[] symbolArray2 = ScalaSearch.sortList(linkedList2);
        Symbol[] symbolArray3 = ScalaSearch.sortList(linkedList3);
        this.addCategory(symbolArray, "val/def", page, mySymbolTablePrinter);
        this.addCategory(symbolArray2, "package/object", page, mySymbolTablePrinter);
        this.addCategory(symbolArray3, "type/trait/class", page, mySymbolTablePrinter);
    }

    protected void addResultNumber(int n, Page page) {
        page.printOTag("p");
        page.printOTag("b");
        page.print(String.valueOf(String.valueOf(DEFAULT_DOCTITLE.concat(String.valueOf(n)))).concat(" result(s)."));
        page.printCTag("b");
        page.printCTag("p");
    }

    final /* synthetic */ void access$4(Symbol[] symbolArray, String string, boolean bl) {
        this.addSymbolTable(symbolArray, string, bl);
    }

    final /* synthetic */ void access$2(Symbol[] symbolArray, String string) {
        this.printPackagesTable(symbolArray, string);
    }

    final /* synthetic */ String access$3(Symbol symbol) {
        return this.packageSummaryPage(symbol);
    }

    final /* synthetic */ int access$1() {
        return 3;
    }

    final /* synthetic */ int access$6() {
        return 2;
    }

    final /* synthetic */ int access$5() {
        return 1;
    }

    final /* synthetic */ int access$0() {
        return 0;
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.scaladoc.HTMLGenerator").desiredAssertionStatus();
        PRODUCT = System.getProperty("scala.product", "scaladoc");
        VERSION = System.getProperty("scala.version", "unknown version");
        SEARCH_SERVLET_NAME = "scaladocServlet";
        PAGE_SERVLET_NAME = "pageServlet";
    }

    public class SearchServlet
    extends Servlet {
        public String name() {
            return SEARCH_SERVLET_NAME;
        }

        public synchronized void apply(Map map, Writer writer) {
            String string = "search-page";
            URI uRI = Location.makeURI(String.valueOf(String.valueOf(string)).concat(".html"));
            String string2 = "_self";
            String string3 = string;
            Page page = new Page(writer, uRI, string2, string3, HTMLGenerator.this.representation, HTMLGenerator.this.adaptURI(Location.mkURI("style.css"), uRI).toString(), HTMLGenerator.this.adaptURI(Location.mkURI("script.js"), uRI).toString());
            page.open();
            page.printHeader(HTMLGenerator.this.ATTRS_META, HTMLGenerator.this.getGenerator());
            page.printOpenBody();
            HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$1(), page);
            page.printlnHLine();
            MySymbolTablePrinter mySymbolTablePrinter = SymbolTablePrinterFactory.makeHTML(HTMLGenerator.this, page, HTMLGenerator.this.isDocumented);
            String string4 = (String)map.get("searchKind");
            String string5 = (String)map.get("searchString");
            String string6 = null;
            if (string4.equals("byName")) {
                string6 = "in defined names";
            } else if (string4.equals("byComment")) {
                string6 = "in comments";
            } else if (string4.equals("byType")) {
                string6 = "by type";
            }
            String string7 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Scaladoc searched for the string (".concat(String.valueOf(String.valueOf(string5))))).concat(") "))).concat(String.valueOf(String.valueOf(string6))))).concat(".");
            page.printOTag("p");
            page.printOTag("b");
            page.print(string7);
            page.printCTag("b");
            page.printCTag("p");
            if (string4.equals("byName")) {
                String string8 = string5;
                Pattern pattern = Pattern.compile(string8);
                LinkedList linkedList = new LinkedList();
                ScalaSearch.foreach(HTMLGenerator.this.global.definitions.ROOT_CLASS, new 2(pattern, linkedList, this), HTMLGenerator.this.isDocumented);
                HTMLGenerator.this.addResultNumber(linkedList.size(), page);
                HTMLGenerator.this.addFoundSymbols(linkedList, page, mySymbolTablePrinter);
            } else if (string4.equals("byComment")) {
                String string9 = string5;
                Pattern pattern = Pattern.compile(string9);
                LinkedList linkedList = new LinkedList();
                ScalaSearch.foreach(HTMLGenerator.this.global.definitions.ROOT_CLASS, new 3(pattern, linkedList, this), HTMLGenerator.this.isDocumented);
                HTMLGenerator.this.addResultNumber(linkedList.size(), page);
                HTMLGenerator.this.addFoundSymbols(linkedList, page, mySymbolTablePrinter);
            } else if (string4.equals("byType")) {
                Symbol[] symbolArray;
                Type type = ScalaSearch.typeOfString(string5, HTMLGenerator.this.global);
                TypeIsomorphism typeIsomorphism = HTMLGenerator.this.newTypeIso(HTMLGenerator.this.global);
                LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
                HashMap<Symbol, Symbol[]> hashMap = new HashMap<Symbol, Symbol[]>();
                Iterator iterator = typeIsomorphism.searchType(type, HTMLGenerator.this.isDocumented);
                while (iterator.hasNext()) {
                    symbolArray = (Symbol[])iterator.next();
                    linkedList.add(symbolArray.symbol);
                    hashMap.put(symbolArray.symbol, symbolArray);
                }
                if (type == Type.NoType) {
                    page.printOTag("p");
                    page.println("Scaladoc could not recognize your search string as a type, see the ");
                    page.printlnTag("a", new XMLAttribute[]{new XMLAttribute("href", "help-page.html#search-section")}, "help page");
                    page.println(" to know which syntax to use.");
                    page.printCTag("p");
                } else {
                    page.printOTag("p");
                    page.print("You are searching for symbols with type: ");
                    page.print(type.toString());
                    page.printCTag("p");
                    HTMLGenerator.this.addResultNumber(linkedList.size(), page);
                    symbolArray = ScalaSearch.sortList(linkedList);
                    for (int i = 0; i < symbolArray.length; ++i) {
                        String string10;
                        Symbol symbol = symbolArray[i];
                        SearchResult searchResult = (SearchResult)hashMap.get(symbol);
                        Type type2 = searchResult.getType;
                        page.printOTag("dt");
                        mySymbolTablePrinter.printShortSignature(symbol, true);
                        mySymbolTablePrinter.printSeqType(symbol, type2, mySymbolTablePrinter.getSymbolInnerString(symbol));
                        page.printlnCTag("dt");
                        if (!symbol.isRoot()) {
                            page.printOTag("dd");
                            page.print("in ");
                            HTMLGenerator.this.printPath(symbol.owner(), "_self", page);
                            if (searchResult.isInClass && searchResult.tparams.length > 0) {
                                page.print("[");
                                for (int j = 0; j < searchResult.tparams.length; ++j) {
                                    if (j != 0) {
                                        page.print(",");
                                    }
                                    page.print(searchResult.tparams[j].nameString());
                                }
                                page.print("]");
                            }
                            page.printCTag("dd");
                        }
                        if ((string10 = HTMLGenerator.this.firstSentence(HTMLGenerator.this.getComment(symbol))).equals(HTMLGenerator.DEFAULT_DOCTITLE)) continue;
                        page.printlnTag("dd", string10);
                    }
                }
            }
            page.printlnHLine();
            HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$1(), page);
            page.printFootpage();
        }

        static class 3
        extends ScalaSearch.SymFun {
            final /* synthetic */ Pattern val$p;
            final /* synthetic */ List val$found;
            final /* synthetic */ SearchServlet this$1;

            public void apply(Symbol symbol) {
                String string;
                Matcher matcher;
                Pair pair = (Pair)this.this$1.HTMLGenerator.this.global.mapSymbolComment.get(symbol);
                if (pair != null && (matcher = this.val$p.matcher(string = (String)pair.fst)).find()) {
                    this.val$found.add(symbol);
                }
            }

            3(Pattern pattern, List list, SearchServlet searchServlet) {
                this.val$p = pattern;
                this.val$found = list;
                this.this$1 = searchServlet;
            }
        }

        static class 2
        extends ScalaSearch.SymFun {
            final /* synthetic */ Pattern val$p;
            final /* synthetic */ List val$found;
            final /* synthetic */ SearchServlet this$1;

            public void apply(Symbol symbol) {
                String string = symbol.nameString();
                Matcher matcher = this.val$p.matcher(string);
                if (matcher.find()) {
                    this.val$found.add(symbol);
                }
            }

            2(Pattern pattern, List list, SearchServlet searchServlet) {
                this.val$p = pattern;
                this.val$found = list;
                this.this$1 = searchServlet;
            }
        }
    }

    public class PageServlet
    extends Servlet {
        public String name() {
            return PAGE_SERVLET_NAME;
        }

        public synchronized void apply(Map map, Writer writer) {
            String string = (String)map.get("page");
            Promise promise = (Promise)HTMLGenerator.this.promises.get(string);
            promise.writeOn(writer);
        }
    }

    class ResourcePromise
    extends Promise {
        protected String name;
        protected String dir;

        ResourcePromise(String string, String string2) {
            this.name = string;
            this.dir = string2;
        }

        public String name() {
            return this.name;
        }

        protected void computeIn(Writer writer) {
            String string = "resources/".concat(String.valueOf(String.valueOf(this.name)));
            InputStreamReader inputStreamReader = new InputStreamReader(Class.forName("scala.tools.scaladoc.HTMLGenerator").getResourceAsStream(string));
            if (inputStreamReader == null) {
                throw Debug.abort(String.valueOf(String.valueOf("Resource file \"".concat(String.valueOf(String.valueOf(string))))).concat("\" not found"));
            }
            try {
                int n;
                char[] cArray = new char[1024];
                while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) > 0) {
                    writer.write(cArray, 0, n);
                }
                ((Reader)inputStreamReader).close();
            }
            catch (IOException iOException) {
                throw Debug.abort(iOException);
            }
        }
    }

    class FramePromise
    extends Promise {
        public String name() {
            return "index.html";
        }

        protected void computeIn(Writer writer) {
            HTMLGenerator.this.createPrinters(writer, Location.makeURI("index.html"), HTMLGenerator.this.windowtitle, HTMLGenerator.DEFAULT_DOCTITLE);
            HTMLGenerator.this.page.printHeader(HTMLGenerator.this.ATTRS_META, HTMLGenerator.this.getGenerator());
            HTMLGenerator.this.page.printlnOTag("frameset", new XMLAttribute[]{new XMLAttribute("cols", "25%, 75%")}).indent();
            HTMLGenerator.this.page.printlnOTag("frameset", new XMLAttribute[]{new XMLAttribute("rows", "50%, 50%")}).indent();
            HTMLGenerator.this.page.printlnOTag("frame", new XMLAttribute[]{new XMLAttribute("src", HTMLGenerator.this.adaptURI(Location.mkURI("package-index-page.html"), HTMLGenerator.this.page.uri).toString()), new XMLAttribute("name", "packagesFrame")});
            HTMLGenerator.this.page.printlnOTag("frame", new XMLAttribute[]{new XMLAttribute("src", HTMLGenerator.this.adaptURI(Location.mkURI("package-page.html"), HTMLGenerator.this.page.uri).toString()), new XMLAttribute("name", "classesFrame")}).undent();
            HTMLGenerator.this.page.printlnCTag("frameset");
            HTMLGenerator.this.page.printlnOTag("frame", new XMLAttribute[]{new XMLAttribute("src", HTMLGenerator.this.adaptURI(Location.mkURI("root-page.html"), HTMLGenerator.this.page.uri).toString()), new XMLAttribute("name", "rootFrame")});
            HTMLGenerator.this.page.printlnOTag("noframes").indent();
            HTMLGenerator.this.page.printlnSTag("p");
            HTMLGenerator.this.page.print("Here is the ");
            HTMLGenerator.this.page.printAhref(HTMLGenerator.this.adaptURI(Location.mkURI("root-page.html"), HTMLGenerator.this.page.uri).toString(), "non-frame based version");
            HTMLGenerator.this.page.println(" of the documentation.").undent();
            HTMLGenerator.this.page.printlnCTag("noframes").undent();
            HTMLGenerator.this.page.printlnCTag("frameset");
            HTMLGenerator.this.page.printlnCTag("html");
            HTMLGenerator.this.closePrinters();
        }
    }

    class HelpPromise
    extends Promise {
        public String name() {
            return "help-page.html";
        }

        protected void computeIn(Writer writer) {
            String string = "API Help";
            HTMLGenerator.this.createPrinters(writer, Location.makeURI("help-page.html"), string, "root-page.html");
            HTMLGenerator.this.page.printHeader(HTMLGenerator.this.ATTRS_META, HTMLGenerator.this.getGenerator());
            HTMLGenerator.this.page.printOpenBody();
            HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$6());
            HTMLGenerator.this.page.printlnHLine();
            XMLAttribute[] xMLAttributeArray = new XMLAttribute[]{new XMLAttribute("style", "margin:15px 0px 0px 0px; font-size:large; font-weight: bold;")};
            XMLAttribute[] xMLAttributeArray2 = new XMLAttribute[]{new XMLAttribute("style", "margin:15px 0px 15px 0px; font-size:small; font-style: italic;")};
            HTMLGenerator.this.page.printlnTag("div", HTMLGenerator.this.ATTRS_PAGE_TITLE, "How This API Document Is Organized");
            HTMLGenerator.this.page.println("This API (Application Programming Interface) document has pages corresponding to the items in the navigation bar, described as follows.");
            HTMLGenerator.this.page.printlnTag("div", xMLAttributeArray, "Overview");
            HTMLGenerator.this.page.printlnOTag("blockquote").indent();
            HTMLGenerator.this.page.print("The ");
            HTMLGenerator.this.page.printAhref(HTMLGenerator.this.adaptURI(Location.mkURI("root-page.html"), HTMLGenerator.this.page.uri).toString(), "_self", "Overview");
            HTMLGenerator.this.page.println(" page is the front page of this API document and provides a list of all top-level packages, classes, traits and objects with a summary for each. This page can also contain an overall description of the set of packages.").undent();
            HTMLGenerator.this.page.printlnCTag("blockquote");
            HTMLGenerator.this.page.printlnTag("div", xMLAttributeArray, "Package");
            HTMLGenerator.this.page.printlnOTag("blockquote").indent();
            HTMLGenerator.this.page.println("Each package has a page that contains a list of its objects, traits and classes, with a summary for each. This page can contain three categories:");
            HTMLGenerator.this.page.printlnOTag("ul").indent();
            HTMLGenerator.this.page.printlnTag("li", "Objects");
            HTMLGenerator.this.page.printlnTag("li", "Traits");
            HTMLGenerator.this.page.printlnTag("li", "Classes").undent();
            HTMLGenerator.this.page.printlnCTag("ul").undent();
            HTMLGenerator.this.page.printlnCTag("blockquote");
            HTMLGenerator.this.page.printlnTag("div", xMLAttributeArray, "Object/Trait/Class");
            HTMLGenerator.this.page.printlnOTag("blockquote").indent();
            HTMLGenerator.this.page.println("Each object, trait, class, nested object, nested trait and nested class has its own separate page. Each of these pages has three sections consisting of a object/trait/class description, summary tables, and detailed member descriptions:");
            HTMLGenerator.this.page.printlnOTag("ul").indent();
            HTMLGenerator.this.page.printlnTag("li", "Class inheritance diagram");
            HTMLGenerator.this.page.printlnTag("li", "Direct Subclasses");
            HTMLGenerator.this.page.printlnTag("li", "All Known Subinterfaces");
            HTMLGenerator.this.page.printlnTag("li", "All Known Implementing Classes");
            HTMLGenerator.this.page.printlnTag("li", "Class/interface declaration");
            HTMLGenerator.this.page.printlnTag("li", "Class/interface description<p/>");
            HTMLGenerator.this.page.printlnTag("li", "Nested Class Summary");
            HTMLGenerator.this.page.printlnTag("li", "Field Summary");
            HTMLGenerator.this.page.printlnTag("li", "Constructor Summary");
            HTMLGenerator.this.page.printlnTag("li", "Method Summary<p/>");
            HTMLGenerator.this.page.printlnTag("li", "Field Detail");
            HTMLGenerator.this.page.printlnTag("li", "Constructor Detail");
            HTMLGenerator.this.page.printlnTag("li", "Method Detail").undent();
            HTMLGenerator.this.page.printlnCTag("ul").undent();
            HTMLGenerator.this.page.println("Each summary entry contains the first sentence from the detailed description for that item. The summary entries are alphabetical, while the detailed descriptions are in the order they appear in the source code. This preserves the logical groupings established by the programmer.");
            HTMLGenerator.this.page.printlnCTag("blockquote");
            HTMLGenerator.this.page.printlnTag("div", xMLAttributeArray, "Index");
            HTMLGenerator.this.page.printlnOTag("blockquote").indent();
            HTMLGenerator.this.page.print("The ");
            HTMLGenerator.this.page.printAhref(HTMLGenerator.this.adaptURI(Location.mkURI("index-page.html"), HTMLGenerator.this.page.uri).toString(), "_self", "Index");
            HTMLGenerator.this.page.print(" contains an alphabetic list of all classes, interfaces, constructors, methods, and fields.");
            HTMLGenerator.this.page.printlnCTag("blockquote");
            if (HTMLGenerator.this.launchServer) {
                HTMLGenerator.this.page.printlnTag("div", xMLAttributeArray, "Searching a definition");
                HTMLGenerator.this.page.printlnOTag("blockquote").indent();
                HTMLGenerator.this.page.printlnSTag("a", new XMLAttribute[]{new XMLAttribute("name", "search-section")});
                HTMLGenerator.this.page.printlnOTag("p");
                HTMLGenerator.this.page.println("At the top and and at the bottom of each page, there is a form that allows to search the definition of a <em>symbol</em> (field, method, package, object, type, trait or class).");
                HTMLGenerator.this.page.printlnCTag("p");
                HTMLGenerator.this.page.printlnOTag("p");
                HTMLGenerator.this.page.println("There are three ways of specifying the symbols of interest:");
                HTMLGenerator.this.page.printlnOTag("dl");
                HTMLGenerator.this.page.printOTag("dt");
                HTMLGenerator.this.page.printlnTag("b", "By name");
                HTMLGenerator.this.page.printOTag("dd");
                HTMLGenerator.this.page.println("The search string must be a ");
                HTMLGenerator.this.page.printlnTag("a", new XMLAttribute[]{new XMLAttribute("href", "http://java.sun.com/j2se/1.4.2/docs/api/java/util/regex/Pattern.html")}, "regular expression");
                HTMLGenerator.this.page.print(" that has to match a substring in the name of the searched symbol.");
                HTMLGenerator.this.page.printOTag("dt");
                HTMLGenerator.this.page.printlnTag("b", "By comment");
                HTMLGenerator.this.page.printOTag("dd");
                HTMLGenerator.this.page.println("The search string must be a ");
                HTMLGenerator.this.page.printlnTag("a", new XMLAttribute[]{new XMLAttribute("href", "http://java.sun.com/j2se/1.4.2/docs/api/java/util/regex/Pattern.html")}, "regular expression");
                HTMLGenerator.this.page.print(" that has to match a substring in the comments associated to the searched symbol.");
                HTMLGenerator.this.page.printOTag("dt");
                HTMLGenerator.this.page.printlnTag("b", "By type");
                HTMLGenerator.this.page.printOTag("dd");
                HTMLGenerator.this.page.println("The search string must represent a Scala type. Any string ");
                HTMLGenerator.this.page.printlnTag("code", "S");
                HTMLGenerator.this.page.println(" such that ");
                HTMLGenerator.this.page.printlnTag("pre", "def foo S;");
                HTMLGenerator.this.page.println(" is a valid function definition is accepted. Here are some examples:");
                HTMLGenerator.this.page.printlnOTag("ul");
                HTMLGenerator.this.page.printOTag("li");
                HTMLGenerator.this.page.printlnTag("code", ": int => int");
                HTMLGenerator.this.page.printOTag("li");
                HTMLGenerator.this.page.printlnTag("code", "[a,b]: List[a] => (a => b) => List[b]");
                HTMLGenerator.this.page.printOTag("li");
                HTMLGenerator.this.page.printlnTag("code", "(x: int, y: int): unit");
                HTMLGenerator.this.page.printlnCTag("ul");
                HTMLGenerator.this.page.println("The searched symbols must conform to the entered type modulo ");
                HTMLGenerator.this.page.printlnTag("a", new XMLAttribute[]{new XMLAttribute("href", "http://www.pps.jussieu.fr/~dicosmo/Publications/ISObook.html")}, "type isomorphism");
                HTMLGenerator.this.page.println(". This concept allows to unify types that differ by their exact representation but not by their meaning.  The order of parameters is for instance irrelevant when looking for a function. Note finally that methods of classes are interpreted as functions that would take an extra argument of the type of the class.");
                HTMLGenerator.this.page.printlnCTag("dl");
                HTMLGenerator.this.page.printlnCTag("p");
                HTMLGenerator.this.page.printlnCTag("blockquote");
            }
            HTMLGenerator.this.page.printlnOTag("div", xMLAttributeArray2);
            HTMLGenerator.this.page.println("This help file applies to API documentation generated using the standard doclet.");
            HTMLGenerator.this.page.printlnCTag("div");
            HTMLGenerator.this.page.printlnHLine();
            HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$6());
            if (HTMLGenerator.this.validate) {
                HTMLGenerator.this.addValidationBar();
            }
            HTMLGenerator.this.page.printFootpage();
            HTMLGenerator.this.closePrinters();
        }
    }

    class IndexPromise
    extends Promise {
        public String name() {
            return "index-page.html";
        }

        protected void computeIn(Writer writer) {
            String string = "Scala Library Index";
            HTMLGenerator.this.createPrinters(writer, Location.makeURI("index-page.html"), string, "_self");
            HTMLGenerator.this.page.printHeader(HTMLGenerator.this.ATTRS_META, HTMLGenerator.this.getGenerator());
            HTMLGenerator.this.page.printOpenBody();
            HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$5());
            HTMLGenerator.this.page.printlnHLine();
            HTMLGenerator.this.page.printlnOTag("table", HTMLGenerator.this.ATTRS_MEMBER).indent();
            HTMLGenerator.this.page.printlnOTag("tr").indent();
            HTMLGenerator.this.page.printlnOTag("td", HTMLGenerator.this.ATTRS_MEMBER_TITLE).indent();
            HTMLGenerator.this.page.println("Index").undent();
            HTMLGenerator.this.page.printlnCTag("td").undent();
            HTMLGenerator.this.page.printlnCTag("tr").undent();
            HTMLGenerator.this.page.printlnCTag("table");
            HTMLGenerator.this.page.printlnSTag("br");
            Pair pair = ScalaSearch.index(HTMLGenerator.this.root, HTMLGenerator.this.isDocumented);
            Character[] characterArray = (Character[])pair.fst;
            Map map = (Map)pair.snd;
            for (int i = 0; i < characterArray.length; ++i) {
                HTMLGenerator.this.page.printlnAhref("#".concat(String.valueOf(i)), "_self", HTMLPrinter.encode(characterArray[i]));
            }
            HTMLGenerator.this.page.printlnHLine();
            for (int i = 0; i < characterArray.length; ++i) {
                Character c = characterArray[i];
                HTMLGenerator.this.page.printlnAname(String.valueOf(i), HTMLGenerator.DEFAULT_DOCTITLE);
                HTMLGenerator.this.page.printlnOTag("h2");
                HTMLGenerator.this.page.printBold(HTMLPrinter.encode(c));
                HTMLGenerator.this.page.printlnCTag("h2");
                HTMLGenerator.this.page.printlnOTag("dl").indent();
                Symbol[] symbolArray = (Symbol[])map.get(c);
                for (int j = 0; j < symbolArray.length; ++j) {
                    HTMLGenerator.this.page.printOTag("dt");
                    HTMLGenerator.this.addIndexEntry(symbolArray[j]);
                    HTMLGenerator.this.page.printlnCTag("dt");
                    HTMLGenerator.this.page.printlnTag("dd", HTMLGenerator.this.firstSentence(HTMLGenerator.this.getComment(symbolArray[j])));
                }
                HTMLGenerator.this.page.undent().printlnCTag("dl");
            }
            HTMLGenerator.this.page.printlnHLine();
            HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$5());
            if (HTMLGenerator.this.validate) {
                HTMLGenerator.this.addValidationBar();
            }
            HTMLGenerator.this.page.printFootpage();
            HTMLGenerator.this.closePrinters();
        }
    }

    class 1
    extends ScalaSearch.SymFun {
        public void apply(Symbol symbol) {
            if (ScalaSearch.isContainer(symbol) && HTMLGenerator.this.isDocumented.apply(symbol)) {
                ContainerPromise containerPromise = new ContainerPromise(symbol);
                HTMLGenerator.this.promises.put(((Promise)containerPromise).name(), containerPromise);
                if (symbol.isPackage() || symbol.isPackageClass()) {
                    ContainerIndexPromise containerIndexPromise = new ContainerIndexPromise(symbol);
                    HTMLGenerator.this.promises.put(((Promise)containerIndexPromise).name(), containerIndexPromise);
                }
            }
        }

        1() {
        }
    }

    class PackageIndexPromise
    extends Promise {
        public String name() {
            return "package-index-page.html";
        }

        protected void computeIn(Writer writer) {
            HTMLGenerator.this.createPrinters(writer, Location.makeURI("package-index-page.html"), "List of packages", "classesFrame");
            HTMLGenerator.this.page.printHeader(HTMLGenerator.this.ATTRS_META, HTMLGenerator.this.getGenerator());
            HTMLGenerator.this.page.printOpenBody();
            Symbol[] symbolArray = ScalaSearch.getSortedPackageList(HTMLGenerator.this.root, HTMLGenerator.this.isDocumented);
            HTMLGenerator.this.addDocumentationTitle(new XMLAttribute[]{new XMLAttribute("class", "doctitle-larger")});
            HTMLGenerator.this.page.printAhref(HTMLGenerator.this.adaptURI(Location.mkURI("package-page.html"), HTMLGenerator.this.page.uri).toString(), "classesFrame", "All objects, traits and classes");
            HTMLGenerator.this.page.printlnSTag("p");
            HTMLGenerator.this.access$2(symbolArray, "Packages");
            if (HTMLGenerator.this.validate) {
                HTMLGenerator.this.addValidationBar();
            }
            HTMLGenerator.this.page.printFootpage();
            HTMLGenerator.this.closePrinters();
        }
    }

    static class 0
    extends SymbolBooleanFunction {
        final /* synthetic */ DocSyms val$docSyms;
        final /* synthetic */ HTMLGenerator this$0;

        public boolean apply(Symbol symbol) {
            return this.val$docSyms.contains(symbol) && ScalaSearch.isRelevant(symbol) && !this.this$0.getComment(symbol).containsTag("@ignore");
        }

        0(DocSyms docSyms, HTMLGenerator hTMLGenerator) {
            this.val$docSyms = docSyms;
            this.this$0 = hTMLGenerator;
        }
    }

    class ContainerIndexPromise
    extends Promise {
        protected Symbol sym;

        ContainerIndexPromise(Symbol symbol) {
            this.sym = symbol;
        }

        public String name() {
            return HTMLGenerator.this.access$3(this.sym);
        }

        protected void computeIn(Writer writer) {
            HTMLGenerator.this.createPrinters(writer, Location.makeURI(HTMLGenerator.this.access$3(this.sym)), Location.getName(this.sym), "rootFrame");
            HTMLGenerator.this.page.printHeader(HTMLGenerator.this.ATTRS_META, HTMLGenerator.this.getGenerator());
            HTMLGenerator.this.page.printOpenBody();
            HTMLGenerator.this.page.printlnOTag("table", HTMLGenerator.this.ATTRS_NAVIGATION).indent();
            HTMLGenerator.this.page.printlnOTag("tr").indent();
            HTMLGenerator.this.page.printlnOTag("td", HTMLGenerator.this.ATTRS_NAVIGATION_LINKS).indent();
            HTMLGenerator.this.printPath(this.sym, "rootFrame");
            HTMLGenerator.this.page.printlnCTag("td");
            HTMLGenerator.this.page.printlnCTag("tr");
            HTMLGenerator.this.page.printlnCTag("table");
            HTMLGenerator.this.page.printlnSTag("p");
            String[] stringArray = new String[]{"Objects", "Traits", "Classes"};
            if (this.sym.isRoot()) {
                Symbol[][] symbolArray = ScalaSearch.getSubContainerMembers(HTMLGenerator.this.root, HTMLGenerator.this.isDocumented);
                for (int i = 0; i < stringArray.length; ++i) {
                    HTMLGenerator.this.access$4(symbolArray[i], "All ".concat(String.valueOf(String.valueOf(stringArray[i]))), true);
                }
            } else {
                Symbol[][] symbolArray = ScalaSearch.splitMembers(ScalaSearch.members(this.sym, HTMLGenerator.this.isDocumented));
                for (int i = 0; i < stringArray.length; ++i) {
                    Arrays.sort(symbolArray[i + 2], ScalaSearch.symAlphaOrder);
                    HTMLGenerator.this.access$4(symbolArray[i + 2], stringArray[i], false);
                }
            }
            if (HTMLGenerator.this.validate) {
                HTMLGenerator.this.addValidationBar();
            }
            HTMLGenerator.this.page.printFootpage();
            HTMLGenerator.this.closePrinters();
        }
    }

    class ContainerPromise
    extends Promise {
        protected Symbol sym;

        public ContainerPromise(Symbol symbol) {
            this.sym = symbol;
        }

        public String name() {
            return Location.getURI(this.sym).toString();
        }

        protected void computeIn(Writer writer) {
            String string = Location.getName(this.sym);
            HTMLGenerator.this.createPrinters(writer, Location.getURI(this.sym), string, "_self");
            HTMLGenerator.this.page.printHeader(HTMLGenerator.this.ATTRS_META, HTMLGenerator.this.getGenerator());
            HTMLGenerator.this.page.printOpenBody();
            if (this.sym.isRoot()) {
                HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$0());
            } else {
                HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$1());
            }
            HTMLGenerator.this.page.printlnHLine();
            HTMLGenerator.this.addTitle(this.sym);
            HTMLGenerator.this.addDocumentationComment(this.sym);
            HTMLGenerator.this.page.printlnHLine();
            String[] stringArray = new String[]{"Field", "Method", "Object", "Trait", "Class", "Package"};
            String[] stringArray2 = new String[]{"Fields", "Methods", "Objects", "Traits", "Classes", "Packages"};
            Symbol[][] symbolArray = ScalaSearch.splitMembers(ScalaSearch.members(this.sym, HTMLGenerator.this.isDocumented));
            for (int i = 0; i < symbolArray.length; ++i) {
                HTMLGenerator.this.addMemberSummary(symbolArray[i], String.valueOf(String.valueOf(stringArray[i])).concat(" Summary"));
                if (i != 1) continue;
                HTMLGenerator.this.addInheritedMembers(this.sym, stringArray2[i]);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                HTMLGenerator.this.addMemberDetail(symbolArray[i], String.valueOf(String.valueOf(stringArray[i])).concat(" Detail"));
            }
            HTMLGenerator.this.page.printlnHLine();
            if (this.sym.isRoot()) {
                HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$0());
            } else {
                HTMLGenerator.this.addNavigationBar(HTMLGenerator.this.access$1());
            }
            if (HTMLGenerator.this.validate) {
                HTMLGenerator.this.addValidationBar();
            }
            HTMLGenerator.this.page.printFootpage();
            HTMLGenerator.this.closePrinters();
        }
    }
}

