/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scaladoc;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import scala.tools.scaladoc.EchoServlet;
import scala.tools.scaladoc.RequestProcessor;
import scala.tools.scaladoc.Servlet;

public class HTTPServer
extends Thread {
    private File documentRootDirectory;
    private String indexFileName = "index.html";
    private ServerSocket server;
    private int numThreads = 50;
    private Map servletNamed;

    public HTTPServer(File file, int n, String string) throws IOException {
        File file2 = this.documentRootDirectory = file == null ? new File(".") : file;
        if (!this.documentRootDirectory.isDirectory()) {
            throw new IOException(String.valueOf(String.valueOf(this.documentRootDirectory)).concat(" does not exist as a directory"));
        }
        this.indexFileName = string;
        this.server = new ServerSocket(n);
    }

    public HTTPServer(File file, int n) throws IOException {
        this(file, n, "index.html");
    }

    public HTTPServer(File file) throws IOException {
        this(file, 80, "index.html");
    }

    public HTTPServer(File file, int n, Servlet[] servletArray) throws IOException {
        this(file, n, "index.html");
        this.servletNamed = new HashMap();
        for (int i = 0; i < servletArray.length; ++i) {
            this.servletNamed.put("/".concat(String.valueOf(String.valueOf(servletArray[i].name()))), servletArray[i]);
        }
    }

    public void run() {
        Object object;
        for (int i = 0; i < this.numThreads; ++i) {
            object = new Thread(new RequestProcessor(this.documentRootDirectory, this.indexFileName, this.servletNamed));
            ((Thread)object).start();
        }
        System.out.println("Accepting connections on port ".concat(String.valueOf(this.server.getLocalPort())));
        System.out.println("Document Root: ".concat(String.valueOf(String.valueOf(this.documentRootDirectory))));
        while (true) {
            try {
                object = this.server.accept();
                InetSocketAddress inetSocketAddress = (InetSocketAddress)((Socket)object).getRemoteSocketAddress();
                if (inetSocketAddress != null) {
                    System.out.println("Connection from: ".concat(String.valueOf(String.valueOf(inetSocketAddress.getAddress().getCanonicalHostName()))));
                }
                RequestProcessor.processRequest((Socket)object);
            }
            catch (IOException iOException) {
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        File file;
        try {
            file = new File(stringArray[0]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Usage: java HTTPServer docroot port indexfile");
            return;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
            if (n < 0 || n > 65535) {
                n = 80;
            }
        }
        catch (Exception exception) {
            n = 80;
        }
        try {
            Servlet[] servletArray = new Servlet[]{new EchoServlet()};
            HTTPServer hTTPServer = new HTTPServer(file, n, servletArray);
            hTTPServer.start();
        }
        catch (IOException iOException) {
            System.out.println("Server could not start because of an ".concat(String.valueOf(String.valueOf(iOException.getClass()))));
            System.out.println(iOException);
        }
    }
}

