/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scaladoc;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import scala.tools.util.debug.Debug;
import scalac.symtab.Symbol;

public class Location {
    public static final String ROOT_NAME = "root-page";
    public static final String HTML_SUFFIX = ".html";
    public static final String CLASS_SUFFIX = "-class";
    private static final Map uris;
    private static final Map ids;
    private static File hereFile;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static String get(Symbol symbol) {
        return Location.getURI(symbol).toString();
    }

    public static URI getURI(Symbol symbol) {
        if (uris.get(symbol) == null) {
            URI uRI = null;
            try {
                uRI = symbol.isModule() ? Location.getURI(symbol.moduleClass()) : (symbol.isClassType() ? new URI(String.valueOf(String.valueOf(Location.getPath(symbol).toString())).concat(HTML_SUFFIX)) : (symbol.isParameter() ? Location.getURI(symbol.classOwner()) : new URI(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Location.getURI(symbol.owner()).toString())).concat("#"))).concat(String.valueOf(Location.nextFreeId(symbol.owner()))))));
                uris.put(symbol, uRI);
            }
            catch (Exception exception) {
                throw Debug.abort(symbol.defString());
            }
        }
        return (URI)uris.get(symbol);
    }

    private static URI getPath(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClassType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        try {
            if (symbol.isRoot()) {
                return new URI(ROOT_NAME);
            }
            if (symbol.owner().isRoot()) {
                return new URI(Location.getName(symbol));
            }
            return new URI(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Location.getPath(symbol.owner()).toString())).concat("/"))).concat(String.valueOf(String.valueOf(Location.getName(symbol)))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getName(Symbol symbol) {
        if (symbol.isModule()) {
            return Location.getName(symbol.moduleClass());
        }
        if (!$assertionsDisabled && !symbol.isClassType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        String string = symbol.simpleName().toString();
        if (!symbol.isRoot() && !symbol.isModuleClass()) {
            string = String.valueOf(String.valueOf(string)).concat(CLASS_SUFFIX);
        }
        return string;
    }

    private static int nextFreeId(Symbol symbol) {
        if (ids.get(symbol) == null) {
            ids.put(symbol, new Integer(0));
        }
        int n = (Integer)ids.get(symbol);
        ids.put(symbol, new Integer(n + 1));
        return n;
    }

    protected static URI makeURI(String string) {
        try {
            return new URI(string);
        }
        catch (Exception exception) {
            throw Debug.abort(exception);
        }
    }

    public static URI asSeenFrom(URI uRI, URI uRI2) {
        File file = new File(uRI.getPath());
        File file2 = new File(uRI2.getPath());
        try {
            String string = Location.asSeenFrom(file, file2).getPath().replace('\\', '/');
            return new URI(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(uRI.getFragment() != null ? "#".concat(String.valueOf(String.valueOf(uRI.getFragment()))) : "")))).normalize();
        }
        catch (Exception exception) {
            throw Debug.abort(exception);
        }
    }

    private static File pathToRoot(File file) {
        if (file.equals(hereFile) || file.getParentFile() == null) {
            return new File(".");
        }
        return new File(Location.pathToRoot(file.getParentFile()), "..");
    }

    private static File asSeenFrom(File file, File file2) {
        if (file.equals(file2)) {
            return new File(file.getName());
        }
        File file3 = Location.longestCommonPrefix(file, file2);
        File file4 = Location.subtractPrefix(file3, file);
        File file5 = Location.subtractPrefix(file3, file2);
        return new File(Location.pathToRoot(file5), file4.getPath());
    }

    private static File longestCommonPrefix(File file, File file2) {
        if (Location.prefixes(file, file2)) {
            return file;
        }
        if (file.getParentFile() == null) {
            return new File(".");
        }
        return Location.longestCommonPrefix(file.getParentFile(), file2);
    }

    private static boolean prefixes(File file, File file2) {
        if (file.equals(file2)) {
            return true;
        }
        if (file2.getParentFile() == null) {
            return false;
        }
        return Location.prefixes(file, file2.getParentFile());
    }

    private static File subtractPrefix(File file, File file2) {
        if (file.equals(hereFile)) {
            return file2;
        }
        return Location.subtractPrefix(file, file2, hereFile);
    }

    private static File subtractPrefix(File file, File file2, File file3) {
        if (file.equals(file2)) {
            return file3;
        }
        if (file2.getParentFile() == null) {
            return null;
        }
        return Location.subtractPrefix(file, file2.getParentFile(), file3.equals(hereFile) ? new File(file2.getName()) : new File(file2.getName(), file3.getPath()));
    }

    protected static URI mkURI(String string) {
        try {
            return new URI(string);
        }
        catch (Exception exception) {
            throw Debug.abort(exception);
        }
    }

    public static void main(String[] stringArray) {
        File file = new File("A", "B");
        File file2 = new File("A", new File("B", "C").getPath());
        File file3 = new File("C");
        System.out.println("".concat(String.valueOf(String.valueOf(Location.longestCommonPrefix(file, file2)))));
        System.out.println("".concat(String.valueOf(String.valueOf(Location.longestCommonPrefix(file, file3)))));
        System.out.println("".concat(String.valueOf(String.valueOf(Location.subtractPrefix(Location.longestCommonPrefix(file, file3), file)))));
        System.out.println("".concat(String.valueOf(String.valueOf(Location.asSeenFrom(file2, file)))));
        System.out.println("".concat(String.valueOf(String.valueOf(Location.asSeenFrom(file, file3)))));
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.scaladoc.Location").desiredAssertionStatus();
        uris = new HashMap();
        ids = new HashMap();
        hereFile = new File(".");
    }
}

