/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scala.runtime.RunTime;
import scala.tools.scalai.Code;
import scala.tools.scalai.CodeContainer;
import scala.tools.scalai.CodePromise;
import scala.tools.scalai.Constants;
import scala.tools.scalai.Environment;
import scala.tools.scalai.Evaluator;
import scala.tools.scalai.ExpressionCompiler;
import scala.tools.scalai.ExpressionContext;
import scala.tools.scalai.Function;
import scala.tools.scalai.JavaMirror;
import scala.tools.scalai.Override;
import scala.tools.scalai.PathClassLoader;
import scala.tools.scalai.ScalaFunction;
import scala.tools.scalai.ScalaTemplate;
import scala.tools.scalai.Template;
import scala.tools.scalai.Variable;
import scala.tools.util.SourceFile;
import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.ast.Tree;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Name;
import scalac.util.Names;

public class Compiler {
    private final Global global;
    private final Definitions definitions;
    private final Constants constants;
    private final ClassLoader loader;
    private final Environment environment;
    private final Map templates;
    private final Evaluator evaluator;
    private final Map any_methods;
    private final Map sources;
    private static final Class[] CSTR_PARAMS;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public Compiler(Global global, Map map, Evaluator evaluator) {
        this.global = global;
        this.definitions = global.definitions;
        this.constants = new Constants();
        this.loader = new PathClassLoader(global.classPath.getRoot());
        RunTime.setClassLoader((ClassLoader)this.loader);
        JavaMirror javaMirror = new JavaMirror(this.definitions, this.loader);
        this.environment = new Environment(this, javaMirror);
        this.templates = map;
        this.evaluator = evaluator;
        this.any_methods = new HashMap();
        this.sources = new HashMap();
        SourceFile sourceFile = global.getSourceFile("<<compiled code>>", "");
        this.environment.insertFunction(this.definitions.STRING_PLUS, Function.StringPlus);
        this.environment.insertFunction(this.definitions.THROWABLE_THROW, Function.Throw);
        Method method = null;
        try {
            method = Class.forName("java.lang.reflect.Proxy").getMethod("getInvocationHandler", Class.forName("java.lang.Object"));
        }
        catch (Exception exception) {
            throw Debug.abort("getInvocationHandler", (Throwable)exception);
        }
        Method method2 = null;
        try {
            method2 = Class.forName("java.lang.Object").getMethod("equals", Class.forName("java.lang.Object"));
        }
        catch (Exception exception) {
            throw Debug.abort("equals", (Throwable)exception);
        }
        Symbol symbol = this.definitions.OBJECT_CLASS.lookup(Names.equals);
        if (!$assertionsDisabled && symbol == Symbol.NONE) {
            throw new AssertionError();
        }
        CodePromise codePromise = new CodePromise(new CodeContainer(sourceFile, symbol, Code.Invoke(Code.Invoke(Code.Null, Function.JavaMethod(method), new Code[]{Code.Self}, 0), Function.JavaMethod(method2), new Code[]{Code.Load(Code.Null, Variable.Argument(0))}, 0), 0));
        this.any_methods.put(this.definitions.ANY_EQUALS, codePromise);
        this.any_methods.put(method2, codePromise);
        this.environment.insertFunction(this.definitions.ANY_EQUALS, Function.JavaMethod(method2));
        Override override = Override.empty();
        override.insert(method2).insert(this.definitions.ANY_EQUALS);
        this.environment.insertOverride(this.definitions.ANY_EQUALS, override);
        Method method3 = null;
        try {
            method3 = Class.forName("java.lang.Object").getMethod("hashCode", new Class[0]);
        }
        catch (Exception exception) {
            throw Debug.abort("hashCode", (Throwable)exception);
        }
        CodePromise codePromise2 = new CodePromise(new CodeContainer(sourceFile, this.definitions.ANY_HASHCODE, Code.Invoke(Code.Self, Function.HashCode, new Code[0], 0), 0));
        this.any_methods.put(this.definitions.ANY_HASHCODE, codePromise2);
        this.any_methods.put(method3, codePromise2);
        this.environment.insertFunction(this.definitions.ANY_HASHCODE, Function.JavaMethod(method3));
        Override override2 = Override.empty();
        override2.insert(method3).insert(this.definitions.ANY_HASHCODE);
        this.environment.insertOverride(this.definitions.ANY_HASHCODE, override2);
        Method method4 = null;
        try {
            method4 = Class.forName("java.lang.Object").getMethod("toString", new Class[0]);
        }
        catch (Exception exception) {
            throw Debug.abort("toString", (Throwable)exception);
        }
        CodePromise codePromise3 = new CodePromise(new CodeContainer(sourceFile, this.definitions.ANY_TOSTRING, Code.Invoke(Code.Self, Function.ToString, new Code[0], 0), 0));
        this.any_methods.put(this.definitions.ANY_TOSTRING, codePromise3);
        this.any_methods.put(method4, codePromise3);
        this.environment.insertFunction(this.definitions.ANY_TOSTRING, Function.JavaMethod(method4));
        Override override3 = Override.empty();
        override3.insert(method4).insert(this.definitions.ANY_TOSTRING);
        this.environment.insertOverride(this.definitions.ANY_TOSTRING, override3);
        this.environment.insertFunction(this.definitions.OBJECT_EQ, Function.Eq);
        Override override4 = Override.empty().insert(this.definitions.OBJECT_EQ);
        this.environment.insertOverride(this.definitions.OBJECT_EQ, override4);
        this.environment.insertFunction(this.definitions.OBJECT_NE, Function.Ne);
        Override override5 = Override.empty().insert(this.definitions.OBJECT_NE);
        this.environment.insertOverride(this.definitions.OBJECT_NE, override5);
        this.environment.insertFunction(this.definitions.ANY_EQEQ, Function.EqEq);
        Override override6 = Override.empty().insert(this.definitions.ANY_EQEQ);
        this.environment.insertOverride(this.definitions.ANY_EQEQ, override6);
        this.environment.insertFunction(this.definitions.ANY_BANGEQ, Function.BangEq);
        Override override7 = Override.empty().insert(this.definitions.ANY_BANGEQ);
        this.environment.insertOverride(this.definitions.ANY_BANGEQ, override7);
    }

    public ScalaTemplate load(Symbol symbol, Tree.ClassDef classDef) {
        SourceFile sourceFile = (SourceFile)this.sources.remove(classDef);
        if (!$assertionsDisabled && classDef == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        return this.load(sourceFile, symbol, classDef);
    }

    public ScalaTemplate load(SourceFile sourceFile, Symbol symbol, Tree.ClassDef classDef) {
        if (!$assertionsDisabled && classDef.tparams.length != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(classDef))));
        }
        if (!$assertionsDisabled && classDef.vparams.length != 1) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(classDef))));
        }
        if (!$assertionsDisabled && classDef.vparams[0].length != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(classDef))));
        }
        return this.compileTemplate(sourceFile, symbol, classDef.impl.body);
    }

    public ScalaTemplate compileTemplate(SourceFile sourceFile, Symbol symbol, Tree[] treeArray) {
        Set<Object> set;
        Object object;
        List list;
        Map map;
        HashSet hashSet = new HashSet();
        ArrayList arrayList = new ArrayList();
        this.getTypes(hashSet, arrayList, symbol);
        Class[] classArray = new Class[arrayList.size()];
        arrayList.toArray(classArray);
        Class<?> clazz = Proxy.getProxyClass(this.loader, classArray);
        Function function = this.getConstructor(clazz);
        Type[] typeArray = symbol.parents();
        if (symbol.isInterface() || typeArray.length == 0) {
            map = new HashMap(this.any_methods);
            list = new ArrayList();
        } else {
            Template template = this.environment.lookupTemplate(typeArray[0].symbol());
            switch (template.$tag) {
                case 0: {
                    object = (Template.Global)template;
                    set = ((Template.Global)object).template;
                    map = ((ScalaTemplate)((Object)set)).getMethods();
                    list = ((ScalaTemplate)((Object)set)).getFields();
                    break;
                }
                case 1: {
                    map = new HashMap(this.any_methods);
                    list = new ArrayList();
                    break;
                }
                default: {
                    throw Debug.abort("illegal case", template);
                }
            }
        }
        for (int i = 0; i < treeArray.length; ++i) {
            this.addTemplateMember(sourceFile, map, list, treeArray[i]);
        }
        object = new ScalaTemplate(this.evaluator, symbol, clazz, function, map, list.toArray());
        set = (Set)this.templates.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            this.templates.put(clazz, set);
        }
        set.add(object);
        return object;
    }

    public Variable getModule(Symbol symbol) {
        return this.environment.lookupVariable(symbol);
    }

    public Function getMethod(Symbol symbol) {
        return this.environment.lookupFunction(symbol);
    }

    public CodePromise compile(SourceFile sourceFile, Symbol symbol, Tree.DefDef defDef) {
        if (!$assertionsDisabled && defDef.tparams.length != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(defDef))));
        }
        if (!$assertionsDisabled && defDef.vparams.length != 1) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(defDef))));
        }
        return new CodePromise(new ScalaFunction(this, sourceFile, symbol, defDef.vparams[0], defDef.rhs));
    }

    public void compile(CompilationUnit[] compilationUnitArray) {
        for (int i = 0; i < compilationUnitArray.length; ++i) {
            this.declare(compilationUnitArray[i].source, compilationUnitArray[i].body);
        }
    }

    public CodeContainer compile(SourceFile sourceFile, Symbol symbol, Tree tree, Symbol[] symbolArray) {
        ExpressionContext expressionContext = new ExpressionContext(this.environment, sourceFile, symbol);
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(this.definitions, this.global.primitives, this.constants, expressionContext, symbolArray);
        return expressionCompiler.compile(tree);
    }

    private void declare(SourceFile sourceFile, Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            this.declare(sourceFile, treeArray[i]);
        }
    }

    private void declare(SourceFile sourceFile, Tree tree) {
        Symbol symbol = tree.symbol();
        switch (tree.$tag) {
            case 42: {
                return;
            }
            case 10: {
                this.sources.put(tree, sourceFile);
                this.environment.insertClassDef(symbol, (Tree.ClassDef)tree);
                return;
            }
            case 24: {
                Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                if (packageDef.impl.$tag != 33) break;
                Tree.Template template = packageDef.impl;
                Tree tree2 = packageDef.packaged;
                Tree[] treeArray = template.parents;
                Tree[] treeArray2 = template.body;
                if (!$assertionsDisabled && !tree2.symbol().isPackage()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(tree))));
                }
                if (!$assertionsDisabled && treeArray.length != 0) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(tree))));
                }
                this.declare(sourceFile, treeArray2);
                return;
            }
        }
        throw Debug.abort("illegal case");
    }

    private Symbol newGlobalVariable(Type type, Object object) {
        Symbol symbol = this.definitions.ROOT_CLASS.newField(0, 0, Name.fromString(object.toString()));
        symbol.setInfo(type);
        this.environment.insertVariable(symbol, Variable.Global(object));
        return symbol;
    }

    private void getTypes(Set set, List list, Symbol symbol) {
        if (set.contains(symbol)) {
            return;
        }
        set.add(symbol);
        if (!symbol.isExternal()) {
            Type[] typeArray = symbol.parents();
            for (int i = 0; i < typeArray.length; ++i) {
                this.getTypes(set, list, typeArray[i].symbol());
            }
            return;
        }
        Template template = this.environment.lookupTemplate(symbol);
        if (template.$tag == 1) {
            Template.JavaClass javaClass = (Template.JavaClass)template;
            Class clazz = javaClass.clasz;
            this.getTypes(set, list, clazz);
            return;
        }
        Debug.abort("illegal template", template);
    }

    private void getTypes(Set set, List list, Class clazz) {
        if (set.contains(clazz)) {
            return;
        }
        set.add(clazz);
        if (clazz.isInterface()) {
            list.add(clazz);
        } else {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                this.getTypes(set, list, clazz2);
            }
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                this.getTypes(set, list, classArray[i]);
            }
        }
    }

    private Function getConstructor(Class clazz) {
        try {
            return Function.JavaConstructor(clazz.getConstructor(CSTR_PARAMS));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Debug.abort(noSuchMethodException);
        }
    }

    private void addTemplateMember(SourceFile sourceFile, Map map, List list, Tree tree) {
        Symbol symbol = tree.symbol();
        switch (tree.$tag) {
            case 42: {
                return;
            }
            case 10: {
                this.sources.put(tree, sourceFile);
                this.environment.insertClassDef(symbol, (Tree.ClassDef)tree);
                return;
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree2 = valDef.rhs;
                if (!$assertionsDisabled && tree2 != Tree.Empty) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(tree))));
                }
                if (!$assertionsDisabled && symbol.isModule()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(tree))));
                }
                int n = list.size();
                list.add(this.constants.zero(symbol.type()));
                this.environment.insertVariable(symbol, Variable.Member(n));
                return;
            }
            case 13: {
                if (!$assertionsDisabled && map.containsKey(symbol)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                }
                CodePromise codePromise = this.compile(sourceFile, symbol, (Tree.DefDef)tree);
                Override override = this.environment.lookupOverride(symbol);
                Iterator iterator = override.iterator();
                while (iterator.hasNext()) {
                    map.put(iterator.next(), codePromise);
                }
                this.environment.insertFunction(symbol, Function.Member(symbol));
                return;
            }
        }
        throw Debug.abort("illegal tree", tree);
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.scalai.Compiler").desiredAssertionStatus();
        CSTR_PARAMS = new Class[]{Class.forName("java.lang.reflect.InvocationHandler")};
    }
}

