/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import scala.tools.util.AbstractFile;
import scala.tools.util.DirectoryPath;

public class ClassPath {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator", ":");
    public static final String SCALA_LIBRARY_CLASSPATH = System.getProperty("scala.library.class.path", "");
    public static final String SCALA_LIBRARY_SOURCEPATH = System.getProperty("scala.library.source.path", "");
    public static final String RUNTIME_BOOTCLASSPATH = System.getProperty("sun.boot.class.path", "");
    public static final String RUNTIME_EXTDIRS = System.getProperty("java.ext.dirs", "");
    public static final String IMPLICIT_BOOTCLASSPATH = ClassPath.concat(new String[]{SCALA_LIBRARY_CLASSPATH, SCALA_LIBRARY_SOURCEPATH, RUNTIME_BOOTCLASSPATH});
    public static final String DEFAULT_CLASSPATH = System.getProperty("scala.class.path", ".");
    public static final String DEFAULT_SOURCEPATH = System.getProperty("scala.source.path", "");
    public static final String DEFAULT_BOOTCLASSPATH = System.getProperty("scala.boot.class.path", IMPLICIT_BOOTCLASSPATH);
    public static final String DEFAULT_EXTDIRS = System.getProperty("scala.ext.dirs", RUNTIME_EXTDIRS);
    private final AbstractFile root;

    public static void addArchivesInExtDirPath(Set set, String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        ClassPath.addFilesInPath(linkedHashSet, string);
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            ClassPath.addArchivesInExtDir(set, (File)iterator.next());
        }
    }

    public static void addArchivesInExtDir(Set set, File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2;
            if (!stringArray[i].endsWith(".jar") && !stringArray[i].endsWith(".zip") || !(file2 = new File(file, stringArray[i])).isFile()) continue;
            set.add(file2);
        }
    }

    public static void addFilesInPath(Set set, String string) {
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(PATH_SEPARATOR)));
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(PATH_SEPARATOR, n);
            File file = new File(string.substring(n, n2));
            if (file.exists()) {
                set.add(file);
            }
            n = n2 + 1;
        }
    }

    private static String concat(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        if (string2.length() == 0) {
            return string;
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(PATH_SEPARATOR))))).concat(String.valueOf(String.valueOf(string2)));
    }

    private static String concat(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = ClassPath.concat(string, stringArray[i]);
        }
        return string;
    }

    public ClassPath() {
        this(DEFAULT_CLASSPATH);
    }

    public ClassPath(String string) {
        this(string, DEFAULT_SOURCEPATH, DEFAULT_BOOTCLASSPATH, DEFAULT_EXTDIRS);
    }

    public ClassPath(String string, String string2, String string3, String string4) {
        AbstractFile[] abstractFileArray;
        Object object;
        int n;
        if (!string3.equals(IMPLICIT_BOOTCLASSPATH) && (n = ((String)(object = String.valueOf(String.valueOf(String.valueOf(String.valueOf(PATH_SEPARATOR)).concat(String.valueOf(String.valueOf(string3))))).concat(String.valueOf(String.valueOf(PATH_SEPARATOR))))).indexOf(String.valueOf(String.valueOf(PATH_SEPARATOR)).concat(String.valueOf(String.valueOf(PATH_SEPARATOR))))) >= 0) {
            string3 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(((String)object).substring(1, n + 1))).concat(String.valueOf(String.valueOf(IMPLICIT_BOOTCLASSPATH))))).concat(String.valueOf(String.valueOf(((String)object).substring(n + 1, ((String)object).length() - 1))));
        }
        object = new LinkedHashSet();
        ClassPath.addFilesInPath(object, string3);
        ClassPath.addArchivesInExtDirPath(object, string4);
        ClassPath.addFilesInPath(object, string);
        ClassPath.addFilesInPath((Set)object, string2);
        ArrayList<AbstractFile[]> arrayList = new ArrayList<AbstractFile[]>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            abstractFileArray = AbstractFile.getDirectory((File)iterator.next());
            if (abstractFileArray == null) continue;
            arrayList.add(abstractFileArray);
        }
        abstractFileArray = arrayList.toArray(new AbstractFile[arrayList.size()]);
        this.root = DirectoryPath.fromArray("<root>", abstractFileArray);
    }

    public AbstractFile getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root.toString();
    }
}

