/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import scala.tools.util.AbstractReporter;
import scala.tools.util.Position;

public class ConsoleReporter
extends AbstractReporter {
    private final BufferedReader reader;
    private final PrintWriter writer;
    public boolean shortname;

    public ConsoleReporter() {
        this(new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.err, true));
    }

    public ConsoleReporter(BufferedReader bufferedReader, PrintWriter printWriter) {
        this.reader = bufferedReader;
        this.writer = printWriter;
    }

    public String getErrorCountString() {
        return this.getCountString(this.errors(), "error");
    }

    public String getWarningCountString() {
        return this.getCountString(this.warnings(), "warning");
    }

    public String getCountString(int n, String string) {
        switch (n) {
            case 0: {
                return String.valueOf(String.valueOf("no ".concat(String.valueOf(String.valueOf(string))))).concat("s");
            }
            case 1: {
                return "one ".concat(String.valueOf(String.valueOf(string)));
            }
            case 2: {
                return String.valueOf(String.valueOf("two ".concat(String.valueOf(String.valueOf(string))))).concat("s");
            }
            case 3: {
                return String.valueOf(String.valueOf("three ".concat(String.valueOf(String.valueOf(string))))).concat("s");
            }
            case 4: {
                return String.valueOf(String.valueOf("four ".concat(String.valueOf(String.valueOf(string))))).concat("s");
            }
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n).concat(" "))).concat(String.valueOf(String.valueOf(string))))).concat("s");
    }

    public void printMessage(String string) {
        this.writer.println(string);
    }

    public void printMessage(Position position, String string) {
        if (position != null) {
            string = " ".concat(String.valueOf(String.valueOf(string)));
            if (position.getLineNumber() != 0) {
                string = String.valueOf(String.valueOf(String.valueOf(position.getLineNumber()).concat(":"))).concat(String.valueOf(String.valueOf(string)));
            }
            string = this.shortname ? String.valueOf(String.valueOf(String.valueOf(String.valueOf(position.getName())).concat(":"))).concat(String.valueOf(String.valueOf(string))) : String.valueOf(String.valueOf(String.valueOf(String.valueOf(position.getPath())).concat(":"))).concat(String.valueOf(String.valueOf(string)));
        }
        this.printMessage(string);
        this.printSourceLine(position);
    }

    public void printWarning(Position position, String string) {
        string = "warning: ".concat(String.valueOf(String.valueOf(string)));
        this.printMessage(position, string);
    }

    public void printError(Position position, String string) {
        if (position == null) {
            string = "error: ".concat(String.valueOf(String.valueOf(string)));
        }
        this.printMessage(position, string);
    }

    public void printSourceLine(Position position) {
        String string;
        String string2 = string = position == null ? null : position.getLineContent();
        if (string == null) {
            return;
        }
        this.printMessage(string);
        this.printColumnMarker(position);
    }

    public void printColumnMarker(Position position) {
        int n = position == null ? 0 : position.getColumnNumber();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(' ');
        }
        if (n > 0) {
            stringBuffer.append('^');
        }
        this.printMessage(stringBuffer.toString());
    }

    public void printSummary() {
        if (this.warnings() > 0) {
            this.printMessage(String.valueOf(String.valueOf(this.getWarningCountString())).concat(" found"));
        }
        if (this.errors() > 0) {
            this.printMessage(String.valueOf(String.valueOf(this.getErrorCountString())).concat(" found"));
        }
    }

    public void displayInfo(Position position, String string) {
        this.printMessage(position, string);
    }

    public void displayWarning(Position position, String string) {
        this.printWarning(position, string);
    }

    public void displayError(Position position, String string) {
        this.printError(position, string);
    }

    public void displayPrompt() {
        try {
            while (true) {
                this.writer.print("r)esume, a)bort: ");
                this.writer.flush();
                String string = this.reader.readLine();
                if (string == null) continue;
                if ("abort".startsWith(string = string.toLowerCase())) {
                    throw new Error("user abort");
                }
                if ("resume".startsWith(string)) break;
            }
            return;
        }
        catch (IOException iOException) {
            throw new Error("input read error");
        }
    }
}

