/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import scala.tools.util.AbstractFile;
import scala.tools.util.SourceFile;

public class Position {
    public static final int LINE_BITS = 20;
    public static final int COLUMN_BITS = 11;
    public static final int LINE_MASK = 1048575;
    public static final int COLUMN_MASK = 2047;
    public static final int NOPOS = 0;
    public static final int FIRSTPOS;
    private final SourceFile source;
    private final int line;
    private final int column;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static int encode(int n, int n2) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)String.valueOf(n));
        }
        if (!$assertionsDisabled) {
            if (!(n == 0 ? n2 == 0 : n2 >= 0)) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n).concat(","))).concat(String.valueOf(n2)))));
            }
        }
        if (n >= 1048575) {
            n = 1048575;
            n2 = 0;
        }
        if (n2 > 2047) {
            n2 = 2047;
        }
        return n << 11 | n2;
    }

    public static int line(int n) {
        return n >> 11 & 0xFFFFF;
    }

    public static int column(int n) {
        return n & 0x7FF;
    }

    public static String toString(int n) {
        return String.valueOf(String.valueOf(String.valueOf(Position.line(n)).concat(":"))).concat(String.valueOf(Position.column(n)));
    }

    public Position(String string) {
        this(new SourceFile(string, new char[0]));
    }

    public Position(SourceFile sourceFile) {
        this(sourceFile, 0, 0);
    }

    public Position(SourceFile sourceFile, int n) {
        this(sourceFile, Position.line(n), Position.column(n));
    }

    public Position(SourceFile sourceFile, int n, int n2) {
        this.source = sourceFile;
        this.line = n;
        this.column = n2;
        if (!$assertionsDisabled && sourceFile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)String.valueOf(n));
        }
        if (!$assertionsDisabled) {
            if (!(n == 0 ? n2 == 0 : n2 >= 0)) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n).concat(","))).concat(String.valueOf(n2)))));
            }
        }
    }

    public String getName() {
        return this.source.getFile().getName();
    }

    public String getPath() {
        return this.source.getFile().getPath();
    }

    public AbstractFile getAbstractFile() {
        return this.source.getFile();
    }

    public SourceFile getSourceFile() {
        return this.source;
    }

    public String getLineContent() {
        return this.line == 0 ? null : this.source.getLine(this.line);
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public int getLineAndColumnNumber() {
        return Position.encode(this.line, this.column);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.source.getFile().getPath());
        if (this.line > 0) {
            stringBuffer.append(":").append(this.line);
        }
        if (this.line > 0 && this.column > 0) {
            stringBuffer.append(":").append(this.column);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.source.hashCode() ^ this.getLineAndColumnNumber();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Position)) {
            return false;
        }
        Position position = (Position)object;
        return this.source == position.source && this.line == position.line && this.column == position.column;
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.util.Position").desiredAssertionStatus();
        FIRSTPOS = Position.encode(1, 1);
    }
}

