/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util.debug;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import scala.tools.util.debug.AbortError;
import scala.tools.util.debug.ArrayDebugger;
import scala.tools.util.debug.Debugger;
import scala.tools.util.debug.ObjectDebugger;
import scala.tools.util.debug.ThrowableDebugger;
import scala.tools.util.debug.ToStringDebugger;

public class Debug {
    private static final ArrayList debuggers = new ArrayList();

    public static void addDebugger(Debugger debugger) {
        debuggers.add(debugger);
    }

    public static Error abort() {
        throw new AbortError();
    }

    public static Error abort(Throwable throwable) {
        throw new AbortError(throwable);
    }

    public static Error abort(Object object) {
        return Debug.abort(Debug.show(object));
    }

    public static Error abort(Object object, Throwable throwable) {
        return Debug.abort(Debug.show(object), throwable);
    }

    public static Error abort(String string) {
        throw new AbortError(string);
    }

    public static Error abort(String string, Throwable throwable) {
        throw new AbortError(string, throwable);
    }

    public static Error abort(String string, Object object) {
        return Debug.abort(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(": "))).concat(String.valueOf(String.valueOf(Debug.show(object)))));
    }

    public static Error abort(String string, Object object, Throwable throwable) {
        return Debug.abort(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(": "))).concat(String.valueOf(String.valueOf(Debug.show(object)))), throwable);
    }

    public static Error abortIllegalCase(int n) {
        return Debug.abort("illegal case: ".concat(String.valueOf(n)));
    }

    public static Error abortIllegalCase(Object object) {
        return Debug.abort("illegal case", object);
    }

    public static String show(Object object) {
        return Debug.showAll(new Object[]{object});
    }

    public static String show(Object object, Object object2) {
        return Debug.showAll(new Object[]{object, object2});
    }

    public static String show(Object object, Object object2, Object object3) {
        return Debug.showAll(new Object[]{object, object2, object3});
    }

    public static String show(Object object, Object object2, Object object3, Object object4) {
        return Debug.showAll(new Object[]{object, object2, object3, object4});
    }

    public static String show(Object object, Object object2, Object object3, Object object4, Object object5) {
        return Debug.showAll(new Object[]{object, object2, object3, object4, object5});
    }

    public static String show(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return Debug.showAll(new Object[]{object, object2, object3, object4, object5, object6});
    }

    public static String show(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return Debug.showAll(new Object[]{object, object2, object3, object4, object5, object6, object7});
    }

    public static String show(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return Debug.showAll(new Object[]{object, object2, object3, object4, object5, object6, object7, object8});
    }

    public static String show(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return Debug.showAll(new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9});
    }

    public static String show(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return Debug.showAll(new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9, object10});
    }

    public static String show(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11) {
        return Debug.showAll(new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9, object10, object11});
    }

    public static String show(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12) {
        return Debug.showAll(new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12});
    }

    public static String showAll(Object[] objectArray) {
        return Debug.showAll(objectArray, " - ");
    }

    public static String showAll(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Debug.appendAll(stringBuffer, objectArray, string);
        return stringBuffer.toString();
    }

    public static void append(StringBuffer stringBuffer, Object object) {
        if (object != null) {
            for (int i = debuggers.size() - 1; i >= 0; --i) {
                Debugger debugger = (Debugger)debuggers.get(i);
                if (!debugger.canAppend(object)) continue;
                debugger.append(stringBuffer, object);
                return;
            }
        }
        stringBuffer.append(object);
    }

    public static void appendAll(StringBuffer stringBuffer, Object[] objectArray, String string) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0 && string != null) {
                stringBuffer.append(string);
            }
            Debug.append(stringBuffer, objectArray[i]);
        }
    }

    public static String getClassNameOf(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        if (!string.endsWith("$$Var")) {
            return string;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        Field[] fieldArray = clazz2.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                Object object2;
                Field field = fieldArray[i];
                if (field.getType() != clazz || !Modifier.isStatic(field.getModifiers()) || (object2 = field.get(null)) != object) continue;
                return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat("["))).concat(String.valueOf(String.valueOf(field.getName()))))).concat("]");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return string;
    }

    public static boolean overridesToString(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod("toString", new Class[0]);
            return method.getDeclaringClass() != Class.forName("java.lang.Object");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static {
        Debug.addDebugger(ObjectDebugger.object);
        Debug.addDebugger(ArrayDebugger.object);
        Debug.addDebugger(ThrowableDebugger.object);
        Debug.addDebugger(new ToStringDebugger(Class.forName("java.lang.String")));
    }
}

