/*
 * Decompiled with CFR 0.152.
 */
package scalac;

import java.util.ArrayList;
import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.PhaseDescriptor;

public class CompilationLoop {
    private final Global global;
    private final Phase[] phases;
    private final ArrayList[] unitss;
    private final int[] indexes;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public CompilationLoop(Global global) {
        this.global = global;
        int n = 0;
        Phase phase = global.PHASE.INITIAL.phase();
        while (phase != null) {
            ++n;
            phase = phase.next;
        }
        this.phases = new Phase[n];
        this.unitss = new ArrayList[n];
        this.indexes = new int[n];
        Phase phase2 = global.PHASE.INITIAL.phase();
        for (int i = 0; i < n; ++i) {
            this.phases[i] = phase2;
            this.unitss[i] = new ArrayList();
            phase2 = phase2.next;
        }
    }

    public CompilationUnit[] compile(CompilationUnit[] compilationUnitArray) {
        for (int i = 0; i < compilationUnitArray.length; ++i) {
            this.unitss[0].add(compilationUnitArray[i]);
        }
        int n = this.phases.length - 1;
        this.loop(n, true);
        return this.global.reporter.errors() != 0 ? new CompilationUnit[]{} : this.unitss[n].toArray(new CompilationUnit[this.unitss[n].size()]);
    }

    public void insert(CompilationUnit compilationUnit) {
        Phase phase = this.global.currentPhase;
        this.unitss[0].add(compilationUnit);
        this.loop(this.getPhaseIndex(phase), false);
        this.global.currentPhase = phase;
    }

    private void loop(int n, boolean bl) {
        if (!$assertionsDisabled && n >= this.phases.length) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show("".concat(String.valueOf(n)), this.phases))));
        }
        int n2 = this.getFirstNonEmptyIndex();
        while (!(n2 >= n || bl && this.global.reporter.errors() != 0 && this.global.currentPhase != this.global.PHASE.NAMER.phase())) {
            Phase phase = this.global.currentPhase = this.phases[n2];
            if (this.indexes[n2] == 0) {
                this.global.timer.start();
            }
            for (int i = this.indexes[n2]; i < this.unitss[n2].size(); ++i) {
                phase.apply((CompilationUnit)this.unitss[n2].get(i));
            }
            int n3 = this.getFirstNonEmptyIndex();
            if (n3 == n2) {
                PhaseDescriptor phaseDescriptor = phase.descriptor;
                this.global.timer.stop(phaseDescriptor.taskDescription());
                CompilationUnit[] compilationUnitArray = this.unitss[n2].toArray(new CompilationUnit[this.unitss[n2].size()]);
                if (phaseDescriptor.hasPrintFlag()) {
                    this.global.print(compilationUnitArray);
                }
                if (phase == this.global.PHASE.PARSER.phase()) {
                    this.global.fix1(compilationUnitArray);
                }
                if (phase == this.global.PHASE.ANALYZER.phase()) {
                    this.global.fix2(compilationUnitArray);
                }
                this.unitss[n2 + 1].addAll(this.unitss[n2]);
                this.unitss[n2].clear();
            }
            this.indexes[n2] = this.unitss[n2].size();
            n2 = ++n3;
        }
    }

    private int getFirstNonEmptyIndex() {
        int n;
        for (n = 0; n < this.phases.length && this.unitss[n].isEmpty(); ++n) {
        }
        return n;
    }

    private int getPhaseIndex(Phase phase) {
        for (int i = 0; i < this.phases.length; ++i) {
            if (this.phases[i] != phase) continue;
            return i;
        }
        throw Debug.abort("phase not found", Debug.show(phase, this.phases));
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.CompilationLoop").desiredAssertionStatus();
    }
}

