/*
 * Decompiled with CFR 0.152.
 */
package scalac;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import scala.tools.util.ClassPath;
import scala.tools.util.ConsoleReporter;
import scala.tools.util.Reporter;
import scalac.CompilerPhases;
import scalac.Global;
import scalac.PhaseDescriptor;
import scalac.util.ArgumentParser;
import scalac.util.BooleanOptionParser;
import scalac.util.ChoiceOptionParser;
import scalac.util.CommandParser;
import scalac.util.HelpOptionParser;
import scalac.util.PhaseSetOptionParser;
import scalac.util.PrintOptionParser;
import scalac.util.ScalaFileArgumentParser;
import scalac.util.StringOptionParser;
import scalac.util.Strings;
import scalac.util.UnknownArgumentParser;
import scalac.util.UnknownOptionParser;
import scalac.util.VersionOptionParser;

public class CompilerCommand
extends CommandParser {
    public final CompilerPhases phases;
    public final BooleanOptionParser debuginfo;
    public final BooleanOptionParser nowarn;
    public final BooleanOptionParser verbose;
    public final BooleanOptionParser debug;
    public final BooleanOptionParser explaintypes;
    public final BooleanOptionParser uniqid;
    public final BooleanOptionParser types;
    public final BooleanOptionParser prompt;
    public final ChoiceOptionParser separate;
    public final StringOptionParser classpath;
    public final StringOptionParser sourcepath;
    public final StringOptionParser bootclasspath;
    public final StringOptionParser extdirs;
    public final StringOptionParser outpath;
    public final StringOptionParser encoding;
    public final StringOptionParser assemrefs;
    public final StringOptionParser assemname;
    public final ChoiceOptionParser target;
    public final BooleanOptionParser noimports;
    public final BooleanOptionParser nopredefs;
    public final PhaseSetOptionParser skip;
    public final PhaseSetOptionParser check;
    public final PrintOptionParser print;
    public final ChoiceOptionParser printer;
    public final StringOptionParser printfile;
    public final PhaseSetOptionParser graph;
    public final PhaseSetOptionParser stop;
    public final PhaseSetOptionParser log;
    public final VersionOptionParser version;
    public final HelpOptionParser help;
    public final UnknownOptionParser unknown_options;
    public final ScalaFileArgumentParser files;
    public final UnknownArgumentParser unknown_arguments;
    public final BooleanOptionParser Xshortname;
    public final BooleanOptionParser Xmarkup;
    public final BooleanOptionParser Xnewmatch;
    public final BooleanOptionParser XpreserveWS;
    public final BooleanOptionParser XrunTimeTypes;
    public final StringOptionParser XrootClass;
    public final StringOptionParser XappFile;
    public final StringOptionParser XdotFile;
    public final BooleanOptionParser Xrta;
    public final BooleanOptionParser Xinline;

    public CompilerCommand(String string, String string2, Reporter reporter, CompilerPhases compilerPhases) {
        this(string, string2, "<source files>", reporter, compilerPhases);
    }

    protected CompilerCommand(String string, String string2, String string3, Reporter reporter, CompilerPhases compilerPhases) {
        super(string, string2, string3, reporter);
        this.phases = compilerPhases;
        ArgumentParser[] argumentParserArray = new ArgumentParser[43];
        this.debuginfo = new BooleanOptionParser(this, "g", "Generate debugging info", false);
        argumentParserArray[0] = this.debuginfo;
        this.nowarn = new BooleanOptionParser(this, "nowarn", "Generate no warnings", false);
        argumentParserArray[1] = this.nowarn;
        this.verbose = new BooleanOptionParser(this, "verbose", "Output messages about what the compiler is doing", false);
        argumentParserArray[2] = this.verbose;
        this.classpath = new StringOptionParser(this, "classpath", "Specify where to find user class files", "path", ClassPath.DEFAULT_CLASSPATH);
        argumentParserArray[3] = this.classpath;
        this.sourcepath = new StringOptionParser(this, "sourcepath", "Specify where to find input source files", "path", ClassPath.DEFAULT_SOURCEPATH);
        argumentParserArray[4] = this.sourcepath;
        this.bootclasspath = new StringOptionParser(this, "bootclasspath", "Override location of bootstrap class files", "path", ClassPath.DEFAULT_BOOTCLASSPATH);
        argumentParserArray[5] = this.bootclasspath;
        this.extdirs = new StringOptionParser(this, "extdirs", "Override location of installed extensions", "dirs", ClassPath.DEFAULT_EXTDIRS);
        argumentParserArray[6] = this.extdirs;
        this.outpath = new StringOptionParser(this, "d", "Specify where to place generated class files", "directory", ".");
        argumentParserArray[7] = this.outpath;
        this.encoding = new StringOptionParser(this, "encoding", "Specify character encoding used by source files", "encoding", System.getProperty("file.encoding", "ISO-8859-1"));
        argumentParserArray[8] = this.encoding;
        this.separate = new ChoiceOptionParser(this, "separate", "Read symbol files for separate compilation: (yes, no)", "separate", new String[]{"yes", "no"}, "default");
        argumentParserArray[9] = this.separate;
        this.target = new ChoiceOptionParser(this, "target", "Specify which backend to use (jvm, msil)", "target", Global.TARGETS, Global.TARGET_JVM);
        argumentParserArray[10] = this.target;
        this.assemrefs = new StringOptionParser(this, "r", "Assemblies referenced by the source program (only relevant with '-target:msil')", "assembly files", ".");
        argumentParserArray[11] = this.assemrefs;
        this.assemname = new StringOptionParser(this, "o", "Name of the output assembly (only relevant with '-target:msil')", "assembly name", null);
        argumentParserArray[12] = this.assemname;
        this.debug = new BooleanOptionParser(this, "debug", "Output debugging messages", false);
        argumentParserArray[13] = this.debug;
        this.explaintypes = new BooleanOptionParser(this, "explaintypes", "Explain type errors in more detail", false);
        argumentParserArray[14] = this.explaintypes;
        this.uniqid = new BooleanOptionParser(this, "uniqid", "Print identifiers with unique names (debugging option)", false);
        argumentParserArray[15] = this.uniqid;
        this.types = new BooleanOptionParser(this, "types", "Print tree types (debugging option)", false);
        argumentParserArray[16] = this.types;
        this.prompt = new BooleanOptionParser(this, "prompt", "Display a prompt after each error (debugging option)", false);
        argumentParserArray[17] = this.prompt;
        this.noimports = new BooleanOptionParser(this, "noimports", "Compile without any implicit imports", false);
        argumentParserArray[18] = this.noimports;
        this.nopredefs = new BooleanOptionParser(this, "nopredefs", "Compile without any implicit predefined values", false);
        argumentParserArray[19] = this.nopredefs;
        this.skip = new PhaseSetOptionParser(this, "skip", "Skip <phases> (see below)", compilerPhases.phases(), 2);
        argumentParserArray[20] = this.skip;
        this.check = new PhaseSetOptionParser(this, "check", "Check the tree after <phases> (see below)", compilerPhases.phases(), 16);
        argumentParserArray[21] = this.check;
        this.print = new PrintOptionParser(this, "print", "Print out program after <phases> (see below)", compilerPhases.phases(), 4);
        argumentParserArray[22] = this.print;
        this.printer = new ChoiceOptionParser(this, "printer", "Printer to use", "printer", Global.PRINTERS, Global.PRINTER_TEXT);
        argumentParserArray[23] = this.printer;
        this.printfile = new StringOptionParser(this, "print-file", "Specify file in which to print trees", "file", "-");
        argumentParserArray[24] = this.printfile;
        this.graph = new PhaseSetOptionParser(this, "graph", "Graph the program after <phases> (see below)", compilerPhases.phases(), 8);
        argumentParserArray[25] = this.graph;
        this.stop = new PhaseSetOptionParser(this, "stop", "Stop after first phase in <phases> (see below)", compilerPhases.phases(), 1);
        argumentParserArray[26] = this.stop;
        this.log = new PhaseSetOptionParser(this, "log", "Log operations in <phases> (see below)", compilerPhases.phases(), 32);
        argumentParserArray[27] = this.log;
        this.version = new VersionOptionParser(this, "version", "Print product version and exit", String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.product())).concat(" "))).concat(String.valueOf(String.valueOf(this.version()))))).concat(" -- (c) 2002-05 LAMP/EPFL"));
        argumentParserArray[28] = this.version;
        this.help = new HelpOptionParser(this, "help", "Print a synopsis of standard options");
        argumentParserArray[29] = this.help;
        this.Xshortname = new BooleanOptionParser(this, "Xshortname", "Display short file names in error reports", false);
        argumentParserArray[30] = this.Xshortname;
        this.Xmarkup = new BooleanOptionParser(this, "Xmarkup", "no effect, only for compatibility", false);
        argumentParserArray[31] = this.Xmarkup;
        this.Xnewmatch = new BooleanOptionParser(this, "Xnewmatch", "new pattern matching", false);
        argumentParserArray[32] = this.Xnewmatch;
        this.XpreserveWS = new BooleanOptionParser(this, "XpreserveWS", "don't trim whitespace in XML literals", false);
        argumentParserArray[33] = this.XpreserveWS;
        this.XrootClass = new StringOptionParser(this, "XrootClass", "Specify the root class of the global application", "class", "$");
        argumentParserArray[34] = this.XrootClass;
        this.XappFile = new StringOptionParser(this, "XappFile", "Specify the filename where to dump the whole-application inferred from the rootclass", "file", "app.txt");
        argumentParserArray[35] = this.XappFile;
        this.XdotFile = new StringOptionParser(this, "XdotFile", "Specify the filename where to print the AST in graphviz dot format", "file", "$");
        argumentParserArray[36] = this.XdotFile;
        this.Xrta = new BooleanOptionParser(this, "Xrta", "Perform Rapid Type analysis for method call resolution", false);
        argumentParserArray[37] = this.Xrta;
        this.Xinline = new BooleanOptionParser(this, "Xinline", "Inline method calls that can be resolved statically", false);
        argumentParserArray[38] = this.Xinline;
        this.XrunTimeTypes = new BooleanOptionParser(this, "Xrtt", "Enable run-time types", false);
        argumentParserArray[39] = this.XrunTimeTypes;
        this.unknown_options = new UnknownOptionParser(this);
        argumentParserArray[40] = this.unknown_options;
        this.files = new ScalaFileArgumentParser(this);
        argumentParserArray[41] = this.files;
        this.unknown_arguments = new UnknownArgumentParser(this);
        argumentParserArray[42] = this.unknown_arguments;
        ArgumentParser[] argumentParserArray2 = argumentParserArray;
        for (int i = 0; i < argumentParserArray2.length; ++i) {
            this.add(argumentParserArray2[i]);
        }
    }

    public boolean parse(String[] stringArray) {
        boolean bl = super.parse(stringArray);
        this.reporter().verbose(this.verbose.value);
        this.reporter().nowarn(this.nowarn.value);
        this.reporter().prompt(this.prompt.value);
        if (this.reporter() instanceof ConsoleReporter) {
            ((ConsoleReporter)this.reporter()).shortname = this.Xshortname.value;
        }
        return bl;
    }

    private boolean containsPhaseOptions() {
        List list = this.parsers();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof PhaseSetOptionParser)) continue;
            return true;
        }
        return false;
    }

    public String getHelpMessage() {
        StringBuffer stringBuffer = new StringBuffer(super.getHelpMessage());
        if (this.containsPhaseOptions()) {
            stringBuffer.append(Strings.EOL);
            stringBuffer.append("and possible compilation phases include:");
            stringBuffer.append(Strings.EOL);
            PhaseDescriptor[] phaseDescriptorArray = this.phases.phases();
            ArrayList<String> arrayList = new ArrayList<String>(phaseDescriptorArray.length);
            for (int i = 0; i < phaseDescriptorArray.length; ++i) {
                PhaseDescriptor phaseDescriptor = phaseDescriptorArray[i];
                arrayList.add(String.valueOf(String.valueOf(String.valueOf(String.valueOf("  ".concat(String.valueOf(String.valueOf(phaseDescriptor.name()))))).concat("\t  "))).concat(String.valueOf(String.valueOf(phaseDescriptor.description()))));
            }
            arrayList.add("  all\t  matches all phases");
            stringBuffer.append(Strings.format(arrayList));
        }
        return stringBuffer.toString();
    }

    public ClassPath classpath() {
        return new ClassPath(this.classpath.value, this.sourcepath.value, this.bootclasspath.value, this.extdirs.value);
    }

    public String outpath() {
        return String.valueOf(String.valueOf(this.outpath.value)).concat(String.valueOf(String.valueOf(this.outpath.value.endsWith(File.separator) ? "" : File.separator)));
    }
}

