/*
 * Decompiled with CFR 0.152.
 */
package scalac.ast;

import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.ast.LazyTreeCopier;
import scalac.ast.Tree;
import scalac.ast.TreeCopier;
import scalac.ast.TreeFactory;
import scalac.ast.TreeGen;
import scalac.atree.AConstant;
import scalac.util.Name;

public class Transformer {
    public final Global global;
    public final TreeFactory make;
    public final TreeCopier copy;
    public final TreeGen gen;

    public Transformer(Global global) {
        this(global, global.make);
    }

    public Transformer(Global global, TreeFactory treeFactory) {
        this(global, treeFactory, new LazyTreeCopier(treeFactory));
    }

    public Transformer(Global global, TreeFactory treeFactory, TreeCopier treeCopier) {
        this.global = global;
        this.make = treeFactory;
        this.copy = treeCopier;
        this.gen = global.treeGen;
    }

    public void apply(CompilationUnit compilationUnit) {
        compilationUnit.global.log("transforming ".concat(String.valueOf(String.valueOf(compilationUnit))));
        compilationUnit.body = this.transform(compilationUnit.body);
    }

    public Tree transform(Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return tree;
            }
            case 6: {
                Tree.Attributed attributed = (Tree.Attributed)tree;
                Tree tree2 = attributed.attribute;
                Tree tree3 = attributed.definition;
                return this.copy.Attributed(tree, this.transform(tree2), this.transform(tree3));
            }
            case 14: {
                Tree.DocDef docDef = (Tree.DocDef)tree;
                String string = docDef.comment;
                Tree tree4 = docDef.definition;
                return this.copy.DocDef(tree, string, this.transform(tree4));
            }
            case 10: {
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                int n = classDef.mods;
                Name name = classDef.name;
                Tree.AbsTypeDef[] absTypeDefArray = classDef.tparams;
                Tree.ValDef[][] valDefArray = classDef.vparams;
                Tree tree5 = classDef.tpe;
                Tree.Template template = classDef.impl;
                if (tree.symbol() != null) {
                    return this.copy.ClassDef(tree, tree.symbol(), this.transform(absTypeDefArray), this.transform(valDefArray), this.transform(tree5), this.transform(template));
                }
                return this.copy.ClassDef(tree, n, name, this.transform(absTypeDefArray), this.transform(valDefArray), this.transform(tree5), this.transform(template));
            }
            case 24: {
                Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                Tree tree6 = packageDef.packaged;
                Tree.Template template = packageDef.impl;
                return this.copy.PackageDef(tree, this.transform(tree6), this.transform(template));
            }
            case 22: {
                Tree.ModuleDef moduleDef = (Tree.ModuleDef)tree;
                int n = moduleDef.mods;
                Name name = moduleDef.name;
                Tree tree7 = moduleDef.tpe;
                Tree.Template template = moduleDef.impl;
                if (tree.symbol() != null) {
                    return this.copy.ModuleDef(tree, tree.symbol(), this.transform(tree7), this.transform(template));
                }
                return this.copy.ModuleDef(tree, n, name, this.transform(tree7), this.transform(template));
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                int n = valDef.mods;
                Name name = valDef.name;
                Tree tree8 = valDef.tpe;
                Tree tree9 = valDef.rhs;
                if (tree.symbol() != null) {
                    return this.copy.ValDef(tree, tree.symbol(), this.transform(tree8), this.transform(tree9));
                }
                return this.copy.ValDef(tree, n, name, this.transform(tree8), this.transform(tree9));
            }
            case 25: {
                Tree.PatDef patDef = (Tree.PatDef)tree;
                int n = patDef.mods;
                Tree tree10 = patDef.pat;
                Tree tree11 = patDef.rhs;
                return this.copy.PatDef(tree, n, this.transform(tree10), this.transform(tree11));
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                int n = defDef.mods;
                Name name = defDef.name;
                Tree.AbsTypeDef[] absTypeDefArray = defDef.tparams;
                Tree.ValDef[][] valDefArray = defDef.vparams;
                Tree tree12 = defDef.tpe;
                Tree tree13 = defDef.rhs;
                if (tree.symbol() != null) {
                    return this.copy.DefDef(tree, tree.symbol(), this.transform(absTypeDefArray), this.transform(valDefArray), this.transform(tree12), this.transform(tree13));
                }
                return this.copy.DefDef(tree, n, name, this.transform(absTypeDefArray), this.transform(valDefArray), this.transform(tree12), this.transform(tree13));
            }
            case 0: {
                Tree.AbsTypeDef absTypeDef = (Tree.AbsTypeDef)tree;
                int n = absTypeDef.mods;
                Name name = absTypeDef.name;
                Tree tree14 = absTypeDef.rhs;
                Tree tree15 = absTypeDef.lobound;
                if (tree.symbol() != null) {
                    return this.copy.AbsTypeDef(tree, tree.symbol(), this.transform(tree14), this.transform(tree15));
                }
                return this.copy.AbsTypeDef(tree, n, name, this.transform(tree14), this.transform(tree15));
            }
            case 1: {
                Tree.AliasTypeDef aliasTypeDef = (Tree.AliasTypeDef)tree;
                int n = aliasTypeDef.mods;
                Name name = aliasTypeDef.name;
                Tree.AbsTypeDef[] absTypeDefArray = aliasTypeDef.tparams;
                Tree tree16 = aliasTypeDef.rhs;
                if (tree.symbol() != null) {
                    return this.copy.AliasTypeDef(tree, tree.symbol(), this.transform(absTypeDefArray), this.transform(tree16));
                }
                return this.copy.AliasTypeDef(tree, n, name, this.transform(absTypeDefArray), this.transform(tree16));
            }
            case 19: {
                Tree.Import import_ = (Tree.Import)tree;
                Tree tree17 = import_.expr;
                Name[] nameArray = import_.selectors;
                if (tree.symbol() != null) {
                    return this.copy.Import(tree, tree.symbol(), this.transform(tree17), nameArray);
                }
                return this.copy.Import(tree, this.transform(tree17), nameArray);
            }
            case 9: {
                Tree.CaseDef caseDef = (Tree.CaseDef)tree;
                Tree tree18 = caseDef.pat;
                Tree tree19 = caseDef.guard;
                Tree tree20 = caseDef.body;
                return this.copy.CaseDef(tree, this.transform(tree18), this.transform(tree19), this.transform(tree20));
            }
            case 33: {
                Tree.Template template = (Tree.Template)tree;
                Tree[] treeArray = template.parents;
                Tree[] treeArray2 = template.body;
                if (tree.symbol() != null) {
                    return this.copy.Template(tree, tree.symbol(), this.transform(treeArray), this.transform(treeArray2));
                }
                return this.copy.Template(tree, this.transform(treeArray), this.transform(treeArray2));
            }
            case 20: {
                Tree.LabelDef labelDef = (Tree.LabelDef)tree;
                Name name = labelDef.name;
                Tree.Ident[] identArray = labelDef.params;
                Tree tree21 = labelDef.rhs;
                if (tree.symbol() != null) {
                    return this.copy.LabelDef(tree, tree.symbol(), this.transform(identArray), this.transform(tree21));
                }
                return this.copy.LabelDef(tree, name, this.transform(identArray), this.transform(tree21));
            }
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree22 = block.expr;
                return this.copy.Block(tree, this.transform(treeArray), this.transform(tree22));
            }
            case 29: {
                Tree.Sequence sequence = (Tree.Sequence)tree;
                Tree[] treeArray = sequence.trees;
                return this.copy.Sequence(tree, this.transform(treeArray));
            }
            case 2: {
                Tree.Alternative alternative = (Tree.Alternative)tree;
                Tree[] treeArray = alternative.trees;
                return this.copy.Alternative(tree, this.transform(treeArray));
            }
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Name name = bind.name;
                Tree tree23 = bind.rhs;
                if (tree.symbol() != null) {
                    return this.copy.Bind(tree, tree.symbol(), this.transform(tree23));
                }
                return this.copy.Bind(tree, name, this.transform(tree23));
            }
            case 41: {
                Tree.Visitor visitor = (Tree.Visitor)tree;
                Tree.CaseDef[] caseDefArray = visitor.cases;
                return this.copy.Visitor(tree, this.transform(caseDefArray));
            }
            case 16: {
                Tree.Function function = (Tree.Function)tree;
                Tree.ValDef[] valDefArray = function.vparams;
                Tree tree24 = function.body;
                return this.copy.Function(tree, this.transform(valDefArray), this.transform(tree24));
            }
            case 5: {
                Tree.Assign assign = (Tree.Assign)tree;
                Tree tree25 = assign.lhs;
                Tree tree26 = assign.rhs;
                return this.copy.Assign(tree, this.transform(tree25), this.transform(tree26));
            }
            case 18: {
                Tree.If if_ = (Tree.If)tree;
                Tree tree27 = if_.cond;
                Tree tree28 = if_.thenp;
                Tree tree29 = if_.elsep;
                return this.copy.If(tree, this.transform(tree27), this.transform(tree28), this.transform(tree29));
            }
            case 32: {
                Tree.Switch switch_ = (Tree.Switch)tree;
                Tree tree30 = switch_.test;
                int[] nArray = switch_.tags;
                Tree[] treeArray = switch_.bodies;
                Tree tree31 = switch_.otherwise;
                return this.copy.Switch(tree, this.transform(tree30), nArray, this.transform(treeArray), this.transform(tree31));
            }
            case 26: {
                Tree.Return return_ = (Tree.Return)tree;
                Tree tree32 = return_.expr;
                if (tree.symbol() != null) {
                    return this.copy.Return(tree, tree.symbol(), this.transform(tree32));
                }
                return this.copy.Return(tree, this.transform(tree32));
            }
            case 35: {
                Tree.Throw throw_ = (Tree.Throw)tree;
                Tree tree33 = throw_.expr;
                return this.copy.Throw(tree, this.transform(tree33));
            }
            case 23: {
                Tree.New new_ = (Tree.New)tree;
                Tree tree34 = new_.init;
                return this.copy.New(tree, this.transform(tree34));
            }
            case 12: {
                Tree.Create create = (Tree.Create)tree;
                Tree tree35 = create.qualifier;
                Tree[] treeArray = create.targs;
                if (tree.symbol() != null) {
                    return this.copy.Create(tree, tree.symbol(), this.transform(tree35), this.transform(treeArray));
                }
                return this.copy.Create(tree, this.transform(tree35), this.transform(treeArray));
            }
            case 39: {
                Tree.Typed typed = (Tree.Typed)tree;
                Tree tree36 = typed.expr;
                Tree tree37 = typed.tpe;
                return this.copy.Typed(tree, this.transform(tree36), this.transform(tree37));
            }
            case 37: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                Tree tree38 = typeApply.fun;
                Tree[] treeArray = typeApply.args;
                return this.copy.TypeApply(tree, this.transform(tree38), this.transform(treeArray));
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree39 = apply.fun;
                Tree[] treeArray = apply.args;
                return this.copy.Apply(tree, this.transform(tree39), this.transform(treeArray));
            }
            case 31: {
                Tree.Super super_ = (Tree.Super)tree;
                Name name = super_.qualifier;
                Name name2 = super_.mixin;
                if (tree.symbol() != null) {
                    return this.copy.Super(tree, tree.symbol(), name2);
                }
                return this.copy.Super(tree, name, name2);
            }
            case 34: {
                Tree.This this_ = (Tree.This)tree;
                Name name = this_.qualifier;
                if (tree.symbol() != null) {
                    return this.copy.This(tree, tree.symbol());
                }
                return this.copy.This(tree, name);
            }
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                Tree tree40 = select.qualifier;
                Name name = select.selector;
                if (tree.symbol() != null) {
                    return this.copy.Select(tree, tree.symbol(), this.transform(tree40));
                }
                return this.copy.Select(tree, this.transform(tree40), name);
            }
            case 17: {
                Tree.Ident ident = (Tree.Ident)tree;
                Name name = ident.name;
                if (tree.symbol() != null) {
                    return this.copy.Ident(tree, tree.symbol());
                }
                return this.copy.Ident(tree, name);
            }
            case 21: {
                Tree.Literal literal = (Tree.Literal)tree;
                AConstant aConstant = literal.value;
                return this.copy.Literal(tree, aConstant);
            }
            case 38: {
                return this.copy.TypeTerm(tree);
            }
            case 30: {
                Tree.SingletonType singletonType = (Tree.SingletonType)tree;
                Tree tree41 = singletonType.ref;
                return this.copy.SingletonType(tree, this.transform(tree41));
            }
            case 28: {
                Tree.SelectFromType selectFromType = (Tree.SelectFromType)tree;
                Tree tree42 = selectFromType.qualifier;
                Name name = selectFromType.selector;
                if (tree.symbol() != null) {
                    return this.copy.SelectFromType(tree, tree.symbol(), this.transform(tree42));
                }
                return this.copy.SelectFromType(tree, this.transform(tree42), name);
            }
            case 15: {
                Tree.FunType funType = (Tree.FunType)tree;
                Tree[] treeArray = funType.argtpes;
                Tree tree43 = funType.restpe;
                return this.copy.FunType(tree, this.transform(treeArray), this.transform(tree43));
            }
            case 11: {
                Tree.CompoundType compoundType = (Tree.CompoundType)tree;
                Tree[] treeArray = compoundType.parents;
                Tree[] treeArray3 = compoundType.refinements;
                return this.copy.CompoundType(tree, this.transform(treeArray), this.transform(treeArray3));
            }
            case 3: {
                Tree.AppliedType appliedType = (Tree.AppliedType)tree;
                Tree tree44 = appliedType.tpe;
                Tree[] treeArray = appliedType.args;
                return this.copy.AppliedType(tree, this.transform(tree44), this.transform(treeArray));
            }
            case 36: {
                Tree.Try try_ = (Tree.Try)tree;
                Tree tree45 = try_.block;
                Tree tree46 = try_.catcher;
                Tree tree47 = try_.finalizer;
                return this.copy.Try(tree, this.transform(tree45), this.transform(tree46), this.transform(tree47));
            }
        }
        throw Debug.abort("unknown tree", tree);
    }

    public Tree.Template transform(Tree.Template template) {
        return (Tree.Template)this.transform((Tree)template);
    }

    public Tree[] transform(Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            Tree tree = this.transform(treeArray[i]);
            if (tree == treeArray[i]) continue;
            Tree[] treeArray2 = new Tree[treeArray.length];
            System.arraycopy(treeArray, 0, treeArray2, 0, i);
            treeArray2[i++] = tree;
            while (i < treeArray.length) {
                treeArray2[i] = this.transform(treeArray[i]);
                ++i;
            }
            return treeArray2;
        }
        return treeArray;
    }

    public Tree.ValDef[] transform(Tree.ValDef[] valDefArray) {
        for (int i = 0; i < valDefArray.length; ++i) {
            Tree tree = this.transform(valDefArray[i]);
            if (tree == valDefArray[i]) continue;
            Tree.ValDef[] valDefArray2 = new Tree.ValDef[valDefArray.length];
            System.arraycopy(valDefArray, 0, valDefArray2, 0, i);
            valDefArray2[i++] = (Tree.ValDef)tree;
            while (i < valDefArray.length) {
                valDefArray2[i] = (Tree.ValDef)this.transform(valDefArray[i]);
                ++i;
            }
            return valDefArray2;
        }
        return valDefArray;
    }

    public Tree.ValDef[][] transform(Tree.ValDef[][] valDefArray) {
        for (int i = 0; i < valDefArray.length; ++i) {
            Tree.ValDef[] valDefArray2 = this.transform(valDefArray[i]);
            if (valDefArray2 == valDefArray[i]) continue;
            Tree.ValDef[][] valDefArray3 = new Tree.ValDef[valDefArray.length][];
            System.arraycopy(valDefArray, 0, valDefArray3, 0, i);
            valDefArray3[i++] = valDefArray2;
            while (i < valDefArray.length) {
                valDefArray3[i] = this.transform(valDefArray[i]);
                ++i;
            }
            return valDefArray3;
        }
        return valDefArray;
    }

    public Tree.AbsTypeDef[] transform(Tree.AbsTypeDef[] absTypeDefArray) {
        for (int i = 0; i < absTypeDefArray.length; ++i) {
            Tree tree = this.transform(absTypeDefArray[i]);
            if (tree == absTypeDefArray[i]) continue;
            Tree.AbsTypeDef[] absTypeDefArray2 = new Tree.AbsTypeDef[absTypeDefArray.length];
            System.arraycopy(absTypeDefArray, 0, absTypeDefArray2, 0, i);
            absTypeDefArray2[i++] = (Tree.AbsTypeDef)tree;
            while (i < absTypeDefArray.length) {
                absTypeDefArray2[i] = (Tree.AbsTypeDef)this.transform(absTypeDefArray[i]);
                ++i;
            }
            return absTypeDefArray2;
        }
        return absTypeDefArray;
    }

    public Tree.CaseDef[] transform(Tree.CaseDef[] caseDefArray) {
        for (int i = 0; i < caseDefArray.length; ++i) {
            Tree tree = this.transform(caseDefArray[i]);
            if (tree == caseDefArray[i]) continue;
            Tree.CaseDef[] caseDefArray2 = new Tree.CaseDef[caseDefArray.length];
            System.arraycopy(caseDefArray, 0, caseDefArray2, 0, i);
            caseDefArray2[i++] = (Tree.CaseDef)tree;
            while (i < caseDefArray.length) {
                caseDefArray2[i] = (Tree.CaseDef)this.transform(caseDefArray[i]);
                ++i;
            }
            return caseDefArray2;
        }
        return caseDefArray;
    }

    public Tree.Ident[] transform(Tree.Ident[] identArray) {
        for (int i = 0; i < identArray.length; ++i) {
            Tree tree = this.transform(identArray[i]);
            if (tree == identArray[i]) continue;
            Tree.Ident[] identArray2 = new Tree.Ident[identArray.length];
            System.arraycopy(identArray, 0, identArray2, 0, i);
            identArray2[i++] = (Tree.Ident)tree;
            while (i < identArray.length) {
                identArray2[i] = (Tree.Ident)this.transform(identArray[i]);
                ++i;
            }
            return identArray2;
        }
        return identArray;
    }
}

