/*
 * Decompiled with CFR 0.152.
 */
package scalac.atree;

import ch.epfl.lamp.util.CodePrinter;
import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.atree.AArithmeticOp;
import scalac.atree.AClass;
import scalac.atree.ACode;
import scalac.atree.AComparisonOp;
import scalac.atree.AConstant;
import scalac.atree.AField;
import scalac.atree.AFunction;
import scalac.atree.AInvokeStyle;
import scalac.atree.ALocation;
import scalac.atree.ALogicalOp;
import scalac.atree.AMember;
import scalac.atree.AMethod;
import scalac.atree.APrimitive;
import scalac.atree.ARepository;
import scalac.atree.AShiftOp;
import scalac.atree.ATestOp;
import scalac.atree.ATypeKind;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolTablePrinter;
import scalac.symtab.Type;
import scalac.util.SourceRepresentation;

public class ATreePrinter {
    private final Global global;
    private final CodePrinter printer;
    private final SymbolTablePrinter symtab;

    public ATreePrinter() {
        this(new CodePrinter());
    }

    public ATreePrinter(String string) {
        this(Global.instance, new CodePrinter(string));
    }

    public ATreePrinter(CodePrinter codePrinter) {
        this(Global.instance, codePrinter);
    }

    public ATreePrinter(Global global, CodePrinter codePrinter) {
        this.global = global;
        this.printer = codePrinter;
        this.symtab = new SymbolTablePrinter(global, codePrinter);
    }

    public CodePrinter getCodePrinter() {
        return this.printer;
    }

    public ATreePrinter indent() {
        this.printer.indent();
        return this;
    }

    public ATreePrinter undent() {
        this.printer.undent();
        return this;
    }

    public ATreePrinter line() {
        this.printer.line();
        return this;
    }

    public ATreePrinter space() {
        this.printer.space();
        return this;
    }

    public ATreePrinter lbrace() {
        return this.space().println('{').indent();
    }

    public ATreePrinter rbrace() {
        return this.undent().space().println('}');
    }

    public ATreePrinter println() {
        this.printer.println();
        return this;
    }

    public ATreePrinter println(boolean bl) {
        this.printer.println(bl);
        return this;
    }

    public ATreePrinter println(byte by) {
        this.printer.println(by);
        return this;
    }

    public ATreePrinter println(short s) {
        this.printer.println(s);
        return this;
    }

    public ATreePrinter println(char c) {
        this.printer.println(c);
        return this;
    }

    public ATreePrinter println(int n) {
        this.printer.println(n);
        return this;
    }

    public ATreePrinter println(long l) {
        this.printer.println(l);
        return this;
    }

    public ATreePrinter println(float f) {
        this.printer.println(f);
        return this;
    }

    public ATreePrinter println(double d) {
        this.printer.println(d);
        return this;
    }

    public ATreePrinter println(String string) {
        this.printer.println(string);
        return this;
    }

    public ATreePrinter print(boolean bl) {
        this.printer.print(bl);
        return this;
    }

    public ATreePrinter print(byte by) {
        this.printer.print(by);
        return this;
    }

    public ATreePrinter print(short s) {
        this.printer.print(s);
        return this;
    }

    public ATreePrinter print(char c) {
        this.printer.print(c);
        return this;
    }

    public ATreePrinter print(int n) {
        this.printer.print(n);
        return this;
    }

    public ATreePrinter print(long l) {
        this.printer.print(l);
        return this;
    }

    public ATreePrinter print(float f) {
        this.printer.print(f);
        return this;
    }

    public ATreePrinter print(double d) {
        this.printer.print(d);
        return this;
    }

    public ATreePrinter print(String string) {
        this.printer.print(string);
        return this;
    }

    public ATreePrinter printSymbol(Symbol symbol) {
        this.symtab.printSymbolName(symbol);
        return this;
    }

    public ATreePrinter printType(Type type) {
        this.symtab.printType(type);
        return this;
    }

    public ATreePrinter printUnits(CompilationUnit[] compilationUnitArray) {
        Phase phase = this.global.currentPhase;
        this.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[[attributed trees at ".concat(String.valueOf(String.valueOf(phase))))).concat(" (after "))).concat(String.valueOf(String.valueOf(phase.prev))))).concat(")]]"));
        for (int i = 0; i < compilationUnitArray.length; ++i) {
            this.printUnit(compilationUnitArray[i]);
        }
        return this;
    }

    public ATreePrinter printUnit(CompilationUnit compilationUnit) {
        this.println("// Scala source: ".concat(String.valueOf(String.valueOf(compilationUnit.source))));
        return this.printRepository(compilationUnit.repository);
    }

    public ATreePrinter printRepository(ARepository aRepository) {
        AClass[] aClassArray = aRepository.classes();
        for (int i = 0; i < aClassArray.length; ++i) {
            this.printClass(aClassArray[i]);
        }
        return this;
    }

    public ATreePrinter printClass(AClass aClass) {
        Symbol[] symbolArray;
        this.printClassModifiers(aClass);
        this.print(aClass.isInterface() ? "interface" : "class").space();
        this.printSymbol(aClass.symbol());
        Symbol[] symbolArray2 = aClass.tparams();
        if (symbolArray2.length != 0) {
            this.symtab.printTypeParams(symbolArray2);
        }
        if ((symbolArray = aClass.vparams()).length != 0) {
            this.symtab.printValueParams(symbolArray);
        }
        if (aClass.symbol().typeOfThis() != aClass.symbol().thisType()) {
            this.space().print(':').printType(aClass.symbol().typeOfThis());
        }
        this.space().print("extends").space();
        this.symtab.printTypes(aClass.parents(), " with ");
        this.lbrace();
        this.printRepository(aClass);
        AField[] aFieldArray = aClass.fields();
        for (int i = 0; i < aFieldArray.length; ++i) {
            this.printField(aFieldArray[i]);
        }
        AMethod[] aMethodArray = aClass.methods();
        for (int i = 0; i < aMethodArray.length; ++i) {
            this.printMethod(aMethodArray[i]);
        }
        return this.rbrace();
    }

    public ATreePrinter printClassModifiers(AClass aClass) {
        if (aClass.isDeprecated()) {
            this.print("deprecated").space();
        }
        if (aClass.isSynthetic()) {
            this.print("synthetic").space();
        }
        if (aClass.isPublic()) {
            this.print("public").space();
        }
        if (aClass.isPrivate()) {
            this.print("private").space();
        }
        if (aClass.isProtected()) {
            this.print("protected").space();
        }
        if (aClass.isFinal()) {
            this.print("final").space();
        }
        if (aClass.isAbstract()) {
            this.print("abstract").space();
        }
        return this;
    }

    public ATreePrinter printMemberModifiers(AMember aMember) {
        if (aMember.isDeprecated()) {
            this.print("deprecated").space();
        }
        if (aMember.isSynthetic()) {
            this.print("synthetic").space();
        }
        if (aMember.isPublic()) {
            this.print("public").space();
        }
        if (aMember.isPrivate()) {
            this.print("private").space();
        }
        if (aMember.isProtected()) {
            this.print("protected").space();
        }
        if (aMember.isStatic()) {
            this.print("static").space();
        }
        return this;
    }

    public ATreePrinter printMemberCode(AMember aMember) {
        if (aMember.code() == ACode.Void) {
            return this;
        }
        return this.print('=').space().printCode(aMember.code());
    }

    public ATreePrinter printField(AField aField) {
        this.printFieldModifiers(aField);
        this.symtab.printSignature(aField.symbol()).space();
        return this.printMemberCode(aField).line();
    }

    public ATreePrinter printFieldModifiers(AField aField) {
        this.printMemberModifiers(aField);
        if (aField.isFinal()) {
            this.print("final").space();
        }
        if (aField.isVolatile()) {
            this.print("volatile").space();
        }
        if (aField.isTransient()) {
            this.print("transient").space();
        }
        return this;
    }

    public ATreePrinter printMethod(AMethod aMethod) {
        this.printMethodModifiers(aMethod);
        this.symtab.printSignature(aMethod.symbol()).space();
        return this.printMemberCode(aMethod).line();
    }

    public ATreePrinter printMethodModifiers(AMethod aMethod) {
        this.printMemberModifiers(aMethod);
        if (aMethod.isFinal()) {
            this.print("final").space();
        }
        if (aMethod.isSynchronized()) {
            this.print("synchronized").space();
        }
        if (aMethod.isNative()) {
            this.print("native").space();
        }
        if (aMethod.isAbstract()) {
            this.print("abstract").space();
        }
        return this;
    }

    public ATreePrinter printCode(ACode aCode) {
        switch (aCode.$tag) {
            case 15: {
                return this.print("<void>");
            }
            case 13: {
                ACode.This this_ = (ACode.This)aCode;
                Symbol symbol = this_.clasz;
                return this.printSymbol(symbol).print('.').print("this");
            }
            case 2: {
                ACode.Constant constant = (ACode.Constant)aCode;
                AConstant aConstant = constant.constant;
                return this.printConstant(aConstant);
            }
            case 8: {
                ACode.Load load = (ACode.Load)aCode;
                ALocation aLocation = load.location;
                return this.printLocation(aLocation);
            }
            case 10: {
                ACode.Store store = (ACode.Store)aCode;
                ALocation aLocation = store.location;
                ACode aCode2 = store.value;
                this.printLocation(aLocation).space().print('=').space();
                return this.printCode(aCode2);
            }
            case 0: {
                int n;
                ACode.Apply apply = (ACode.Apply)aCode;
                AFunction aFunction = apply.function;
                Type[] typeArray = apply.targs;
                ACode[] aCodeArray = apply.vargs;
                this.printFunction(aFunction);
                if (typeArray.length > 0) {
                    this.print('[');
                    for (n = 0; n < typeArray.length; ++n) {
                        (n == 0 ? this : this.print(',').space()).printType(typeArray[n]);
                    }
                    this.print(']');
                }
                this.print('(');
                for (n = 0; n < aCodeArray.length; ++n) {
                    (n == 0 ? this : this.print(',').space()).printCode(aCodeArray[n]);
                }
                this.print(')');
                return this;
            }
            case 6: {
                ACode.IsAs isAs = (ACode.IsAs)aCode;
                ACode aCode3 = isAs.value;
                Type type = isAs.type;
                boolean bl = isAs.cast;
                this.printCode(aCode3).print('.').print(bl ? "as" : "is");
                return this.print('[').printType(type).print(']');
            }
            case 5: {
                ACode.If if_ = (ACode.If)aCode;
                ACode aCode4 = if_.test;
                ACode aCode5 = if_.success;
                ACode aCode6 = if_.failure;
                this.print("if").space().print('(').printCode(aCode4).print(')').lbrace();
                this.printCode(aCode5).line();
                this.rbrace().space().print("else").space().lbrace();
                this.printCode(aCode6).line();
                return this.rbrace();
            }
            case 11: {
                ACode.Switch switch_ = (ACode.Switch)aCode;
                ACode aCode7 = switch_.test;
                int[][] nArray = switch_.tags;
                ACode[] aCodeArray = switch_.bodies;
                this.print("switch").space().print('(').printCode(aCode7).print(')');
                this.lbrace();
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 0; j < nArray[i].length; ++j) {
                        this.print("case").space().print(nArray[i][j]).print(':').line();
                    }
                    this.indent().printCode(aCodeArray[i]).undent().line();
                }
                this.print("case").space().print('_').print(':').line();
                this.indent().printCode(aCodeArray[nArray.length]).undent();
                return this.rbrace();
            }
            case 12: {
                ACode.Synchronized synchronized_ = (ACode.Synchronized)aCode;
                ACode aCode8 = synchronized_.lock;
                ACode aCode9 = synchronized_.value;
                this.print("synchronized").space();
                this.print('(').printCode(aCode8).print(')');
                return this.lbrace().printCode(aCode9).rbrace();
            }
            case 1: {
                ACode.Block block = (ACode.Block)aCode;
                Symbol[] symbolArray = block.locals;
                ACode[] aCodeArray = block.statements;
                ACode aCode10 = block.value;
                this.lbrace();
                for (int i = 0; i < symbolArray.length; ++i) {
                    this.print("var").space().printSymbol(symbolArray[i]);
                    this.print(":").space().printType(symbolArray[i].type());
                    this.println(";");
                }
                for (int i = 0; i < aCodeArray.length; ++i) {
                    this.printCode(aCodeArray[i]).println(';');
                }
                return this.printCode(aCode10).line().rbrace();
            }
            case 7: {
                ACode.Label label = (ACode.Label)aCode;
                Symbol symbol = label.label;
                Symbol[] symbolArray = label.locals;
                ACode aCode11 = label.value;
                this.print("label").space().printSymbol(symbol).print('(');
                for (int i = 0; i < symbolArray.length; ++i) {
                    (i == 0 ? this : this.print(',').space()).printSymbol(symbolArray[i]);
                }
                this.print(')').space().print('=').lbrace();
                return this.printCode(aCode11).rbrace();
            }
            case 4: {
                ACode.Goto goto_ = (ACode.Goto)aCode;
                Symbol symbol = goto_.label;
                ACode[] aCodeArray = goto_.vargs;
                this.print("goto").space().printSymbol(symbol).print('(');
                for (int i = 0; i < aCodeArray.length; ++i) {
                    (i == 0 ? this : this.print(',').space()).printCode(aCodeArray[i]);
                }
                return this.print(')');
            }
            case 9: {
                ACode.Return return_ = (ACode.Return)aCode;
                Symbol symbol = return_.function;
                ACode aCode12 = return_.value;
                this.print((String)"return").symtab.printSymbolUniqueId(symbol).space();
                return this.printCode(aCode12);
            }
            case 14: {
                ACode.Throw throw_ = (ACode.Throw)aCode;
                ACode aCode13 = throw_.value;
                return this.print("throw").space().printCode(aCode13);
            }
            case 3: {
                ACode.Drop drop = (ACode.Drop)aCode;
                ACode aCode14 = drop.value;
                Type type = drop.type;
                this.print("drop").print('[').printType(type).print(']').space();
                return this.printCode(aCode14);
            }
        }
        throw Debug.abort("unknown case", aCode);
    }

    public ATreePrinter printLocation(ALocation aLocation) {
        switch (aLocation.$tag) {
            case 3: {
                ALocation.Module module = (ALocation.Module)aLocation;
                Symbol symbol = module.module;
                return this.printSymbol(symbol);
            }
            case 1: {
                ALocation.Field field = (ALocation.Field)aLocation;
                if (field.object.$tag == 15 && field.isStatic) {
                    Symbol symbol = field.field;
                    return this.printSymbol(symbol.owner()).print('.').printSymbol(symbol);
                }
                ACode aCode = field.object;
                Symbol symbol = field.field;
                boolean bl = field.isStatic;
                this.printCode(aCode).print('.');
                if (bl) {
                    this.print("<static>").space();
                }
                return this.printSymbol(symbol);
            }
            case 2: {
                ALocation.Local local = (ALocation.Local)aLocation;
                Symbol symbol = local.local;
                return this.printSymbol(symbol);
            }
            case 0: {
                ALocation.ArrayItem arrayItem = (ALocation.ArrayItem)aLocation;
                ACode aCode = arrayItem.array;
                ACode aCode2 = arrayItem.index;
                return this.printCode(aCode).print('(').printCode(aCode2).print(')');
            }
        }
        throw Debug.abort("unknown case", aLocation);
    }

    public ATreePrinter printFunction(AFunction aFunction) {
        switch (aFunction.$tag) {
            case 0: {
                Object object;
                Object object2;
                AFunction.Method method = (AFunction.Method)aFunction;
                switch (method.object.$tag) {
                    case 15: {
                        switch (method.style.$tag) {
                            case 2: {
                                Symbol symbol = method.method;
                                return this.print("new").space().printSymbol(symbol);
                            }
                            case 0: {
                                object2 = (AInvokeStyle.Static)method.style;
                                if (((AInvokeStyle.Static)object2).onInstance) break;
                                Symbol symbol = method.method;
                                return this.printSymbol(symbol.owner()).print('.').printSymbol(symbol);
                            }
                        }
                        break;
                    }
                    case 13: {
                        object2 = (ACode.This)method.object;
                        if (method.style.$tag != 0) break;
                        object = (AInvokeStyle.Static)method.style;
                        if (!((AInvokeStyle.Static)object).onInstance) break;
                        Symbol symbol = ((ACode.This)object2).clasz;
                        Symbol symbol2 = method.method;
                        this.printSymbol(symbol).print('.').print("super").print('.');
                        return this.printSymbol(symbol2);
                    }
                }
                object2 = method.object;
                object = method.method;
                AInvokeStyle aInvokeStyle = method.style;
                this.printCode((ACode)object2).print('.');
                if (aInvokeStyle != AInvokeStyle.Dynamic) {
                    this.print(String.valueOf(String.valueOf("<".concat(String.valueOf(String.valueOf(aInvokeStyle))))).concat(">")).space();
                }
                return this.printSymbol((Symbol)object);
            }
            case 2: {
                AFunction.Primitive primitive = (AFunction.Primitive)aFunction;
                APrimitive aPrimitive = primitive.primitive;
                return this.printPrimitive(aPrimitive);
            }
            case 1: {
                AFunction.NewArray newArray = (AFunction.NewArray)aFunction;
                Type type = newArray.element;
                return this.print("new").space().printType(type).print("[]");
            }
        }
        throw Debug.abort("unknown case", aFunction);
    }

    public ATreePrinter printPrimitive(APrimitive aPrimitive) {
        switch (aPrimitive.$tag) {
            case 5: {
                APrimitive.Negation negation = (APrimitive.Negation)aPrimitive;
                ATypeKind aTypeKind = negation.kind;
                return this.printPrimitiveOp("NEG", aTypeKind);
            }
            case 8: {
                APrimitive.Test test = (APrimitive.Test)aPrimitive;
                ATestOp aTestOp = test.op;
                ATypeKind aTypeKind = test.kind;
                boolean bl = test.zero;
                return this.printPrimitiveOp(String.valueOf(String.valueOf(aTestOp.toString())).concat(String.valueOf(String.valueOf(bl ? "Z" : ""))), aTypeKind);
            }
            case 2: {
                APrimitive.Comparison comparison = (APrimitive.Comparison)aPrimitive;
                AComparisonOp aComparisonOp = comparison.op;
                ATypeKind aTypeKind = comparison.kind;
                return this.printPrimitiveOp(aComparisonOp.toString(), aTypeKind);
            }
            case 0: {
                APrimitive.Arithmetic arithmetic = (APrimitive.Arithmetic)aPrimitive;
                AArithmeticOp aArithmeticOp = arithmetic.op;
                ATypeKind aTypeKind = arithmetic.kind;
                return this.printPrimitiveOp(aArithmeticOp.toString(), aTypeKind);
            }
            case 4: {
                APrimitive.Logical logical = (APrimitive.Logical)aPrimitive;
                ALogicalOp aLogicalOp = logical.op;
                ATypeKind aTypeKind = logical.kind;
                return this.printPrimitiveOp(aLogicalOp.toString(), aTypeKind);
            }
            case 6: {
                APrimitive.Shift shift = (APrimitive.Shift)aPrimitive;
                AShiftOp aShiftOp = shift.op;
                ATypeKind aTypeKind = shift.kind;
                return this.printPrimitiveOp(aShiftOp.toString(), aTypeKind);
            }
            case 3: {
                APrimitive.Conversion conversion = (APrimitive.Conversion)aPrimitive;
                ATypeKind aTypeKind = conversion.src;
                ATypeKind aTypeKind2 = conversion.dst;
                return this.printPrimitiveOp("CONV", aTypeKind, aTypeKind2);
            }
            case 1: {
                APrimitive.ArrayLength arrayLength = (APrimitive.ArrayLength)aPrimitive;
                ATypeKind aTypeKind = arrayLength.kind;
                return this.printPrimitiveOp("LENGTH", aTypeKind);
            }
            case 7: {
                APrimitive.StringConcat stringConcat = (APrimitive.StringConcat)aPrimitive;
                ATypeKind aTypeKind = stringConcat.lf;
                ATypeKind aTypeKind3 = stringConcat.rg;
                return this.printPrimitiveOp("CONCAT", aTypeKind, aTypeKind3);
            }
        }
        throw Debug.abort("unknown case", aPrimitive);
    }

    public ATreePrinter printPrimitiveOp(String string, ATypeKind aTypeKind) {
        return this.printPrimitiveOp(string, aTypeKind, null);
    }

    public ATreePrinter printPrimitiveOp(String string, ATypeKind aTypeKind, ATypeKind aTypeKind2) {
        this.print('<').print(string).print('>');
        if (aTypeKind != null && this.global.uniqid) {
            this.print('#').print(aTypeKind.toString());
        }
        if (aTypeKind2 != null && this.global.uniqid) {
            this.print(',').print(aTypeKind2.toString());
        }
        return this;
    }

    public ATreePrinter printConstant(AConstant aConstant) {
        switch (aConstant.$tag) {
            case 11: {
                return this.print("()");
            }
            case 0: {
                AConstant.BOOLEAN bOOLEAN = (AConstant.BOOLEAN)aConstant;
                boolean bl = bOOLEAN.value;
                return this.print(bl);
            }
            case 1: {
                AConstant.BYTE bYTE = (AConstant.BYTE)aConstant;
                byte by = bYTE.value;
                return this.print(by);
            }
            case 7: {
                AConstant.SHORT sHORT = (AConstant.SHORT)aConstant;
                short s = sHORT.value;
                return this.print(s);
            }
            case 2: {
                AConstant.CHAR cHAR = (AConstant.CHAR)aConstant;
                char c = cHAR.value;
                return this.print('\'').print(c).print('\'');
            }
            case 5: {
                AConstant.INT iNT = (AConstant.INT)aConstant;
                int n = iNT.value;
                return this.print(n);
            }
            case 6: {
                AConstant.LONG lONG = (AConstant.LONG)aConstant;
                long l = lONG.value;
                return this.print(l);
            }
            case 4: {
                AConstant.FLOAT fLOAT = (AConstant.FLOAT)aConstant;
                float f = fLOAT.value;
                return this.print(f);
            }
            case 3: {
                AConstant.DOUBLE dOUBLE = (AConstant.DOUBLE)aConstant;
                double d = dOUBLE.value;
                return this.print(d);
            }
            case 8: {
                AConstant.STRING sTRING = (AConstant.STRING)aConstant;
                String string = sTRING.value;
                return this.print('\"').print(SourceRepresentation.escape(string)).print('\"');
            }
            case 9: {
                AConstant.SYMBOL_NAME sYMBOL_NAME = (AConstant.SYMBOL_NAME)aConstant;
                Symbol symbol = sYMBOL_NAME.value;
                return this.print('\"').print(SourceRepresentation.escape(symbol.name.toString())).print('\"');
            }
            case 10: {
                return this.print("null");
            }
            case 12: {
                return this.print("<zero>");
            }
        }
        throw Debug.abort("unknown case", aConstant);
    }

    public String toString() {
        return this.printer.toString();
    }
}

