/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import scalac.symtab.Symbol;

public class SymSet {
    private SymSet l;
    private SymSet r;
    private Symbol sym;
    public static final SymSet EMPTY;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public SymSet() {
    }

    private SymSet(Symbol symbol, SymSet symSet, SymSet symSet2) {
        this.sym = symbol;
        this.l = symSet;
        this.r = symSet2;
    }

    public SymSet incl(Symbol symbol) {
        if (this == EMPTY) {
            return new SymSet(symbol, EMPTY, EMPTY);
        }
        if (symbol == this.sym) {
            return this;
        }
        if (this.less(symbol, this.sym)) {
            return new SymSet(this.sym, this.l.incl(symbol), this.r);
        }
        if (!$assertionsDisabled && !this.less(this.sym, symbol)) {
            throw new AssertionError();
        }
        return new SymSet(this.sym, this.l, this.r.incl(symbol));
    }

    public SymSet excl(Symbol symbol) {
        if (symbol == this.sym) {
            if (this.l == EMPTY) {
                return this.r;
            }
            if (this.r == EMPTY) {
                return this.l;
            }
            SymSet symSet = this.r;
            if (symSet.l != EMPTY) {
                do {
                    SymSet symSet2 = symSet;
                    symSet = symSet.l;
                } while (symSet.l != EMPTY);
                symSet2.l = symSet.r;
                symSet.r = this.r;
            }
            symSet.l = this.l;
            return symSet;
        }
        if (this.less(symbol, this.sym)) {
            return new SymSet(this.sym, this.l.excl(symbol), this.r);
        }
        if (!$assertionsDisabled && !this.less(this.sym, symbol)) {
            throw new AssertionError();
        }
        return new SymSet(this.sym, this.l, this.r.excl(symbol));
    }

    public boolean contains(Symbol symbol) {
        if (this == EMPTY) {
            return false;
        }
        if (symbol == this.sym) {
            return true;
        }
        if (this.less(symbol, this.sym)) {
            return this.l.contains(symbol);
        }
        if (!$assertionsDisabled && !this.less(this.sym, symbol)) {
            throw new AssertionError();
        }
        return this.r.contains(symbol);
    }

    public int size() {
        if (this == EMPTY) {
            return 0;
        }
        return 1 + this.l.size() + this.r.size();
    }

    public int copyToArray(Symbol[] symbolArray, int n) {
        if (this == EMPTY) {
            return n;
        }
        n = this.l.copyToArray(symbolArray, n);
        symbolArray[n] = this.sym;
        return this.r.copyToArray(symbolArray, n + 1);
    }

    public Symbol[] toArray() {
        int n = this.size();
        if (n == 0) {
            return Symbol.EMPTY_ARRAY;
        }
        Symbol[] symbolArray = new Symbol[n];
        this.copyToArray(symbolArray, 0);
        return symbolArray;
    }

    private boolean less(Symbol symbol, Symbol symbol2) {
        return symbol.isLess(symbol2);
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.SymSet").desiredAssertionStatus();
        EMPTY = new SymSet();
    }
}

