/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import scala.tools.util.AbstractFileReader;
import scalac.atree.AConstant;
import scalac.symtab.Definitions;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.ClassfileConstants;
import scalac.symtab.classfile.ClassfileParser;
import scalac.symtab.classfile.ConstantPool;
import scalac.symtab.classfile.MetaParser;
import scalac.symtab.classfile.UnPickle;
import scalac.util.Name;

public class AttributeParser
implements ClassfileConstants {
    protected AbstractFileReader in;
    protected ConstantPool pool;
    protected ClassfileParser parser;
    Scope tvars = new Scope();

    public AttributeParser(AbstractFileReader abstractFileReader, ConstantPool constantPool, ClassfileParser classfileParser) {
        this.in = abstractFileReader;
        this.pool = constantPool;
        this.parser = classfileParser;
    }

    public int nameToId(Name name) {
        if (name == ClassfileConstants.SOURCEFILE_N) {
            return 1;
        }
        if (name == ClassfileConstants.SYNTHETIC_N) {
            return 2;
        }
        if (name == ClassfileConstants.DEPRECATED_N) {
            return 4;
        }
        if (name == ClassfileConstants.CODE_N) {
            return 8;
        }
        if (name == ClassfileConstants.EXCEPTIONS_N) {
            return 16;
        }
        if (name == ClassfileConstants.CONSTANT_VALUE_N) {
            return 32;
        }
        if (name == ClassfileConstants.LINE_NUM_TABLE_N) {
            return 64;
        }
        if (name == ClassfileConstants.LOCAL_VAR_TABLE_N) {
            return 128;
        }
        if (name == ClassfileConstants.INNERCLASSES_N) {
            return 32768;
        }
        if (name == ClassfileConstants.META_N) {
            return 65536;
        }
        if (name == ClassfileConstants.SCALA_N) {
            return 131072;
        }
        if (name == ClassfileConstants.JACO_N) {
            return 262144;
        }
        if (name == ClassfileConstants.BRIDGE_N) {
            return 524288;
        }
        if (name == ClassfileConstants.SIG_N) {
            return 0x100000;
        }
        return 0;
    }

    public void skipAttributes() {
        int n = this.in.nextChar();
        for (int i = 0; i < n; ++i) {
            this.in.skip(2);
            this.in.skip(this.in.nextInt());
        }
    }

    public Symbol readAttributes(Symbol symbol, Type type, int n) {
        int n2 = this.in.nextChar();
        for (int i = 0; i < n2; ++i) {
            Name name = this.pool.getName(this.in.nextChar());
            int n3 = this.nameToId(name);
            int n4 = this.in.nextInt();
            if ((n & n3) == 0) {
                this.in.skip(n4);
                continue;
            }
            this.readAttribute(symbol, type, n3, n4);
        }
        return symbol;
    }

    public void readAttribute(Symbol symbol, Type type, int n, int n2) {
        switch (n) {
            case 131072: {
                try {
                    UnPickle.parse(this.parser.global, this.in.nextBytes(n2), symbol);
                    return;
                }
                catch (UnPickle.BadSignature badSignature) {
                    throw new RuntimeException(badSignature);
                }
            }
            case 32768: {
                int n3 = this.in.nextChar();
                for (int i = 0; i < n3; ++i) {
                    char c = this.in.nextChar();
                    if (c == '\u0000') {
                        this.in.skip(6);
                        continue;
                    }
                    char c2 = this.in.nextChar();
                    if (c2 == '\u0000') {
                        this.in.skip(4);
                        continue;
                    }
                    char c3 = this.in.nextChar();
                    if (c3 == '\u0000') {
                        this.in.skip(2);
                        continue;
                    }
                    char c4 = this.in.nextChar();
                    if ((c4 & 8) == 0 || (c4 & 5) == 0 || this.pool.getClass(c2) != symbol) continue;
                    Symbol symbol2 = symbol.linkedModule().moduleClass().newTypeAlias(0, 0, this.pool.getName(c3).toTypeName(), this.parser.make.classType(this.pool.getClass(c)));
                    this.parser.statics.enterNoHide(symbol2);
                }
                return;
            }
            case 8: {
                this.in.skip(n2);
                return;
            }
            case 16: {
                this.in.skip(n2);
                return;
            }
            case 64: {
                this.in.skip(n2);
                return;
            }
            case 128: {
                this.in.skip(n2);
                return;
            }
            case 2: {
                symbol.flags |= 0x400;
                return;
            }
            case 524288: {
                symbol.flags |= 0x8000000;
                return;
            }
            case 4: {
                symbol.flags |= 0x800;
                return;
            }
            case 32: {
                AConstant aConstant = this.pool.getConstantValue(this.in.nextChar());
                if (aConstant.$tag == 5) {
                    AConstant.INT iNT = (AConstant.INT)aConstant;
                    int n4 = iNT.value;
                    Definitions definitions = this.parser.global.definitions;
                    Symbol symbol3 = symbol.getType().symbol();
                    if (symbol3 != definitions.INT_CLASS) {
                        aConstant = symbol3 == definitions.CHAR_CLASS ? AConstant.CHAR((char)n4) : (symbol3 == definitions.SHORT_CLASS ? AConstant.SHORT((short)n4) : (symbol3 == definitions.BYTE_CLASS ? AConstant.BYTE((byte)n4) : AConstant.BOOLEAN(n4 != 0)));
                    }
                }
                symbol.setInfo(this.parser.make.constantType(aConstant));
                return;
            }
            case 65536: {
                String string = this.pool.getString(this.in.nextChar()).trim();
                MetaParser metaParser = new MetaParser(string, this.tvars, symbol, type, this.parser.c, this.parser.ctype, this.parser.make);
                symbol.setInfo(metaParser.parse());
                return;
            }
            case 262144: {
                boolean bl;
                int n5 = this.in.nextChar();
                boolean bl2 = bl = ((n5 |= this.in.nextChar() << 16) & 0x200000) != 0;
                if (bl) {
                    symbol.flags |= 0x1040;
                }
                this.in.skip(n2 - 4);
                return;
            }
            case 1: {
                String string = this.pool.getString(this.in.nextChar());
                this.parser.c.getOrigin().setSourceFileAttribute(string);
                this.parser.m.moduleClass().getOrigin().setSourceFileAttribute(string);
                return;
            }
        }
        this.in.skip(n2);
    }
}

