/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import scala.tools.util.AbstractFile;
import scala.tools.util.debug.Debug;
import scalac.Global;
import scalac.symtab.Scope;
import scalac.symtab.SourceCompleter;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolLoader;
import scalac.symtab.SymbolOrigin;
import scalac.symtab.Type;
import scalac.symtab.classfile.ClassParser;
import scalac.symtab.classfile.SymblParser;
import scalac.util.Name;

public class PackageParser
extends SymbolLoader {
    protected final AbstractFile directory;
    protected final HashMap sources = new HashMap();
    protected final HashMap symbols = new HashMap();
    protected final HashMap classes = new HashMap();
    protected final HashMap packages = new HashMap();
    private static final /* synthetic */ boolean $assertionsDisabled;

    public PackageParser(Global global, AbstractFile abstractFile) {
        super(global);
        this.directory = abstractFile;
        if (!$assertionsDisabled && abstractFile == null) {
            throw new AssertionError();
        }
    }

    protected boolean isValidName(String string) {
        return string.length() > 0 && !string.endsWith("$class") && string.indexOf("$$anon") == -1;
    }

    protected PackageParser newPackageParser(AbstractFile abstractFile) {
        return new PackageParser(this.global, abstractFile);
    }

    protected void collectAllMembers(Symbol symbol) {
        Iterator iterator = this.directory.list();
        while (iterator.hasNext()) {
            String string;
            AbstractFile abstractFile = (AbstractFile)iterator.next();
            String string2 = abstractFile.getName();
            if (abstractFile.isDirectory()) {
                if (string2.equals("META-INF")) continue;
                this.packages.put(string2, abstractFile);
                continue;
            }
            if (string2.endsWith(".class")) {
                string = string2.substring(0, string2.length() - 6);
                if (!this.isValidName(string) || this.classes.containsKey(string)) continue;
                this.classes.put(string, abstractFile);
                continue;
            }
            if (string2.endsWith(".symbl")) {
                string = string2.substring(0, string2.length() - 6);
                if (!this.isValidName(string) || this.symbols.containsKey(string)) continue;
                this.symbols.put(string, abstractFile);
                continue;
            }
            if (!string2.endsWith(".scala") || !this.isValidName(string = string2.substring(0, string2.length() - 6)) || this.sources.containsKey(string)) continue;
            this.sources.put(string, abstractFile);
        }
    }

    protected void removeHiddenMembers(Symbol symbol) {
        AbstractFile abstractFile;
        Object object;
        Object object2;
        Object object3;
        if (symbol.isRoot()) {
            this.sources.clear();
        }
        if (symbol.isRoot()) {
            this.symbols.clear();
        }
        if (symbol.isRoot()) {
            this.classes.clear();
        }
        Iterator iterator = this.classes.entrySet().iterator();
        block0: while (iterator.hasNext() && !this.symbols.isEmpty()) {
            Map.Entry entry = iterator.next();
            object3 = (String)entry.getKey();
            object2 = (AbstractFile)entry.getValue();
            object = object3;
            while (true) {
                if ((abstractFile = (AbstractFile)this.symbols.get(object)) != null) {
                    if (((AbstractFile)object2).lastModified() <= abstractFile.lastModified()) {
                        iterator.remove();
                        continue block0;
                    }
                    if (object != object3) continue block0;
                    this.symbols.remove(object);
                    continue block0;
                }
                int n = ((String)object).lastIndexOf(36);
                if (n < 0) continue block0;
                object = ((String)object).substring(0, n);
            }
        }
        boolean bl = this.global.separate;
        object3 = this.sources.entrySet().iterator();
        while (!(!object3.hasNext() || this.symbols.isEmpty() && this.classes.isEmpty())) {
            object2 = (Map.Entry)object3.next();
            object = (String)object2.getKey();
            abstractFile = (AbstractFile)object2.getValue();
            AbstractFile abstractFile2 = (AbstractFile)this.symbols.get(object);
            AbstractFile abstractFile3 = (AbstractFile)this.classes.get(object);
            boolean bl2 = false;
            if (abstractFile2 != null) {
                if (bl && abstractFile2.lastModified() > abstractFile.lastModified()) {
                    bl2 = true;
                } else {
                    this.symbols.remove(object);
                }
            }
            if (abstractFile3 != null) {
                if (bl && abstractFile3.lastModified() > abstractFile.lastModified()) {
                    bl2 = true;
                } else {
                    this.classes.remove(object);
                }
            }
            if (!bl2) continue;
            object3.remove();
        }
        this.packages.keySet().removeAll(this.sources.keySet());
        this.packages.keySet().removeAll(this.symbols.keySet());
        this.packages.keySet().removeAll(this.classes.keySet());
    }

    protected Scope createMemberSymbols(Symbol symbol) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Iterator iterator;
        Object object7;
        Scope scope = new Scope();
        Iterator iterator2 = this.sources.entrySet().iterator();
        while (iterator2.hasNext()) {
            object7 = iterator2.next();
            iterator = (String)object7.getKey();
            object6 = (AbstractFile)object7.getValue();
            object5 = Name.fromString(iterator).toTypeName();
            object4 = new SourceCompleter(this.global, (AbstractFile)object6);
            object3 = SymbolOrigin.ScalaFile((AbstractFile)object6);
            symbol.newLoadedClass(0, (Name)object5, (SymbolLoader)object4, scope, (SymbolOrigin)object3);
        }
        object7 = this.symbols.entrySet().iterator();
        while (object7.hasNext()) {
            iterator = (Map.Entry)object7.next();
            object6 = (String)iterator.getKey();
            object5 = (AbstractFile)iterator.getValue();
            object4 = Name.fromString(object6).toTypeName();
            object3 = new SymblParser(this.global, (AbstractFile)object5);
            object2 = SymbolOrigin.SymblFile((AbstractFile)object5);
            symbol.newLoadedClass(0, (Name)object4, (SymbolLoader)object3, scope, (SymbolOrigin)object2);
        }
        iterator = this.classes.entrySet().iterator();
        while (iterator.hasNext()) {
            object6 = iterator.next();
            object5 = (String)object6.getKey();
            object4 = (AbstractFile)object6.getValue();
            object3 = Name.fromString((String)object5).toTypeName();
            object2 = new ClassParser(this.global, (AbstractFile)object4);
            object = SymbolOrigin.ClassFile((AbstractFile)object4, null);
            symbol.newLoadedClass(4096, (Name)object3, (SymbolLoader)object2, scope, (SymbolOrigin)object);
        }
        object6 = this.packages.entrySet().iterator();
        while (object6.hasNext()) {
            object5 = (Map.Entry)object6.next();
            object4 = (String)object5.getKey();
            object3 = (AbstractFile)object5.getValue();
            object2 = Name.fromString((String)object4);
            object = this.newPackageParser((AbstractFile)object3);
            SymbolOrigin.Directory directory = SymbolOrigin.Directory((AbstractFile)object3);
            symbol.newLoadedPackage((Name)object2, (SymbolLoader)object, scope, directory);
        }
        return scope;
    }

    protected String doComplete(Symbol symbol) {
        if (!($assertionsDisabled || symbol.isRoot() || symbol.isPackage())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        Symbol symbol2 = symbol.isRoot() ? symbol : symbol.moduleClass();
        this.collectAllMembers(symbol2);
        this.removeHiddenMembers(symbol2);
        Scope scope = this.createMemberSymbols(symbol2);
        symbol2.setInfo(Type.compoundType(Type.EMPTY_ARRAY, scope, symbol2));
        return String.valueOf(String.valueOf("directory path '".concat(String.valueOf(String.valueOf(this.directory))))).concat("'");
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.classfile.PackageParser").desiredAssertionStatus();
    }
}

