/*
 * Decompiled with CFR 0.152.
 */
package scalac.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import scala.tools.util.Position;
import scala.tools.util.Reporter;
import scalac.util.ArgumentParser;
import scalac.util.OptionParser;
import scalac.util.Strings;

public class CommandParser {
    private final String product;
    private final String version;
    private final String syntax;
    private final Reporter reporter;
    private final List parsers;

    public CommandParser(String string, String string2, String string3, Reporter reporter) {
        this.product = string;
        this.version = string2;
        this.syntax = string3;
        this.reporter = reporter;
        this.parsers = new ArrayList();
    }

    public String product() {
        return this.product;
    }

    public String version() {
        return this.version;
    }

    public String syntax() {
        return this.syntax;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public boolean add(ArgumentParser argumentParser) {
        return this.parsers.add(argumentParser);
    }

    public void add(int n, ArgumentParser argumentParser) {
        this.parsers.add(n, argumentParser);
    }

    public boolean remove(ArgumentParser argumentParser) {
        return this.parsers.remove(argumentParser);
    }

    public List parsers() {
        return this.parsers;
    }

    public boolean parse(String[] stringArray) {
        int n = this.reporter.errors();
        int n2 = 0;
        block0: while (n2 < stringArray.length) {
            for (int i = 0; i < this.parsers.size(); ++i) {
                ArgumentParser argumentParser = (ArgumentParser)this.parsers.get(i);
                if (!argumentParser.matches(stringArray, n2)) continue;
                n2 = argumentParser.consume(stringArray, n2);
                continue block0;
            }
        }
        return this.reporter.errors() == n;
    }

    public String getHelpMessage() {
        Object object;
        MessageFormat messageFormat = new MessageFormat("  {0}\t  {1}");
        ArrayList<String> arrayList = new ArrayList<String>(this.parsers.size());
        for (int i = 0; i < this.parsers.size(); ++i) {
            String string;
            if (!(this.parsers.get(i) instanceof OptionParser) || (string = ((OptionParser)(object = (OptionParser)this.parsers.get(i))).getHelpMessage(messageFormat)) == null) continue;
            arrayList.add(string);
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("usage: ").append(this.product());
        if (arrayList.size() > 0) {
            ((StringBuffer)object).append(" <options>");
        }
        if (this.syntax != null) {
            ((StringBuffer)object).append(' ').append(this.syntax);
        }
        ((StringBuffer)object).append(Strings.EOL);
        if (arrayList.size() > 0) {
            ((StringBuffer)object).append("where possible options include:");
            ((StringBuffer)object).append(Strings.EOL);
            ((StringBuffer)object).append(Strings.format(arrayList));
        }
        return ((StringBuffer)object).toString();
    }

    public void error(String string) {
        this.reporter.error(new Position(this.product), string);
    }

    public void warning(String string) {
        this.reporter.warning(new Position(this.product), string);
    }
}

