/*
 * Decompiled with CFR 0.152.
 */
package scalac.util;

import java.util.StringTokenizer;
import scalac.PhaseDescriptor;
import scalac.util.CommandParser;
import scalac.util.OptionParser;
import scalac.util.PrefixMatcher;

public class PhaseSetOptionParser
extends OptionParser {
    private final PhaseDescriptor[] phases;
    private final int flag;
    private final PrefixMatcher matcher;

    public PhaseSetOptionParser(CommandParser commandParser, String string, String string2, PhaseDescriptor[] phaseDescriptorArray, int n) {
        super(commandParser, string, string2);
        this.phases = phaseDescriptorArray;
        this.flag = n;
        this.matcher = new PrefixMatcher();
        for (int i = 0; i < phaseDescriptorArray.length; ++i) {
            PhaseDescriptor phaseDescriptor = phaseDescriptorArray[i];
            this.matcher.insert(phaseDescriptor.name(), phaseDescriptor, phaseDescriptor.description());
        }
    }

    public boolean matches(String[] stringArray, int n) {
        return stringArray[n].startsWith(String.valueOf(String.valueOf("-".concat(String.valueOf(String.valueOf(this.option))))).concat(":"));
    }

    public int consume(String[] stringArray, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n].substring(this.option.length() + 2), ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.consumePhase(stringTokenizer.nextToken());
        }
        return n + 1;
    }

    public void consumePhase(String string) {
        if (string.equals("all")) {
            for (int i = 0; i < this.phases.length; ++i) {
                this.phases[i].addFlag(this.flag, false);
            }
            return;
        }
        PhaseDescriptor phaseDescriptor = this.lookup(this.getPhaseName(string));
        if (phaseDescriptor != null) {
            boolean bl;
            boolean bl2 = this.getBeforeFlag(string);
            boolean bl3 = bl = this.getAfterFlag(string) || !bl2;
            if (bl2) {
                phaseDescriptor.addFlag(this.flag, true);
            }
            if (bl) {
                phaseDescriptor.addFlag(this.flag, false);
            }
        }
    }

    public PhaseDescriptor lookup(String string) {
        if (string.length() == 0) {
            this.error("illegal zero-length phase name");
            return null;
        }
        PrefixMatcher.Entry[] entryArray = this.matcher.lookup(string);
        if (entryArray.length == 1) {
            return (PhaseDescriptor)entryArray[0].value;
        }
        this.error(this.matcher.getErrorMessage(string, entryArray, "phase name"));
        return null;
    }

    public boolean getBeforeFlag(String string) {
        int n = string.length();
        block4: while (n-- > 0) {
            switch (string.charAt(n)) {
                case '-': {
                    return true;
                }
                case '+': {
                    continue block4;
                }
            }
            return false;
        }
        return false;
    }

    public boolean getAfterFlag(String string) {
        int n = string.length();
        block4: while (n-- > 0) {
            switch (string.charAt(n)) {
                case '-': {
                    continue block4;
                }
                case '+': {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String getPhaseName(String string) {
        int n = string.length();
        block4: while (n-- > 0) {
            switch (string.charAt(n)) {
                case '-': {
                    continue block4;
                }
                case '+': {
                    continue block4;
                }
            }
            return string.substring(0, n + 1);
        }
        return "";
    }

    public String getHelpSyntax() {
        return String.valueOf(String.valueOf(super.getHelpSyntax())).concat(":<phases>");
    }
}

