/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JAttributeFactory;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JField;
import ch.epfl.lamp.fjbg.JMethod;
import ch.epfl.lamp.fjbg.JObjectType;
import ch.epfl.lamp.fjbg.JType;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JClass {
    public static final int MAGIC_NUMBER = -889275714;
    protected boolean frozen = false;
    protected final FJBGContext context;
    protected final JAttributeFactory attributeFactory;
    protected final int accessFlags;
    protected final String name;
    protected final String superclassName;
    protected final String[] interfaceNames;
    protected final String sourceFileName;
    protected final JConstantPool pool;
    public static final String[] NO_INTERFACES;
    protected final LinkedList methods = new LinkedList();
    protected final LinkedList fields = new LinkedList();
    protected final LinkedList attributes = new LinkedList();
    protected int major;
    protected int minor;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected JClass(FJBGContext context, int accessFlags, String name, String superclassName, String[] interfaceNames, String sourceFileName) {
        this.context = context;
        this.attributeFactory = context.getJAttributeFactory();
        this.major = 45;
        this.minor = 3;
        this.accessFlags = accessFlags;
        this.name = name;
        this.superclassName = superclassName;
        this.interfaceNames = interfaceNames;
        this.sourceFileName = sourceFileName;
        this.pool = context.JConstantPool();
        this.addAttribute(context.JSourceFileAttribute(this, sourceFileName));
    }

    protected JClass(FJBGContext context, DataInputStream stream) throws IOException {
        this.context = context;
        this.attributeFactory = context.getJAttributeFactory();
        int magic = stream.readInt();
        if (magic != -889275714) {
            throw new IllegalArgumentException("invalid magic number: " + magic);
        }
        this.minor = stream.readShort();
        this.major = stream.readShort();
        this.pool = context.JConstantPool(stream);
        this.accessFlags = stream.readShort();
        this.name = this.pool.lookupClass(stream.readShort());
        this.superclassName = this.pool.lookupClass(stream.readShort());
        this.interfaceNames = new String[stream.readShort()];
        for (int i = 0; i < this.interfaceNames.length; ++i) {
            this.interfaceNames[i] = this.pool.lookupClass(stream.readShort());
        }
        int fieldsCount = stream.readShort();
        for (int i = 0; i < fieldsCount; ++i) {
            this.addField(context.JField(this, stream));
        }
        int methodsCount = stream.readShort();
        for (int i = 0; i < methodsCount; ++i) {
            this.addMethod(context.JMethod(this, stream));
        }
        int attributesCount = stream.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            this.addAttribute(this.attributeFactory.newInstance(this, this, stream));
        }
        this.sourceFileName = null;
    }

    public void addAttribute(JAttribute attr) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        this.attributes.add(attr);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public JAttribute getAttribute(String name) {
        Iterator attrIt = this.getAttributes().iterator();
        while (attrIt.hasNext()) {
            JAttribute attr = (JAttribute)attrIt.next();
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperclassName() {
        return this.superclassName;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public JType getType() {
        return new JObjectType(this.name);
    }

    public void setVersion(int major, int minor) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        this.major = major;
        this.minor = minor;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public JConstantPool getConstantPool() {
        return this.pool;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public void addField(JField field) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        this.fields.add(field);
    }

    public JField addNewField(int accessFlags, String name, JType type) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        JField f = this.context.JField(this, accessFlags, name, type);
        this.addField(f);
        return f;
    }

    protected void addMethod(JMethod method) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        this.methods.add(method);
    }

    public JMethod addNewMethod(int accessFlags, String name, JType returnType, JType[] argTypes, String[] argNames) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        JMethod m = this.context.JMethod(this, accessFlags, name, returnType, argTypes, argNames);
        this.addMethod(m);
        return m;
    }

    public void removeMethod(JMethod m) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        this.methods.remove(m);
    }

    public JMethod[] getMethods() {
        return this.methods.toArray(new JMethod[this.methods.size()]);
    }

    public void freeze() {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        this.frozen = true;
    }

    public void writeTo(String fileName) throws IOException {
        this.writeTo(new File(fileName));
    }

    public void writeTo(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("cannot create directory " + parent);
        }
        FileOutputStream fStream = new FileOutputStream(file);
        BufferedOutputStream bStream = new BufferedOutputStream(fStream);
        DataOutputStream dStream = new DataOutputStream(bStream);
        this.writeTo(dStream);
        dStream.close();
        bStream.close();
        fStream.close();
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        int i;
        if (!this.frozen) {
            this.freeze();
        }
        int thisClassIdx = this.pool.addClass(this.name);
        int superClassIdx = this.pool.addClass(this.superclassName);
        int[] interfacesIdx = new int[this.interfaceNames.length];
        for (i = 0; i < this.interfaceNames.length; ++i) {
            interfacesIdx[i] = this.pool.addClass(this.interfaceNames[i]);
        }
        this.pool.freeze();
        stream.writeInt(-889275714);
        stream.writeShort(this.minor);
        stream.writeShort(this.major);
        this.pool.writeTo(stream);
        stream.writeShort(this.accessFlags);
        stream.writeShort(thisClassIdx);
        stream.writeShort(superClassIdx);
        stream.writeShort(interfacesIdx.length);
        for (i = 0; i < interfacesIdx.length; ++i) {
            stream.writeShort(interfacesIdx[i]);
        }
        stream.writeShort(this.fields.size());
        Iterator fieldsIt = this.fields.iterator();
        while (fieldsIt.hasNext()) {
            ((JField)fieldsIt.next()).writeTo(stream);
        }
        stream.writeShort(this.methods.size());
        Iterator methodsIt = this.methods.iterator();
        while (methodsIt.hasNext()) {
            ((JMethod)methodsIt.next()).writeTo(stream);
        }
        JAttribute.writeTo(this.attributes, stream);
    }

    static {
        $assertionsDisabled = !JClass.class.desiredAssertionStatus();
        NO_INTERFACES = new String[0];
    }
}

