/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2002-2005, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: BoxedIntArray.scala,v 1.3 2005/08/26 12:25:56 michelou Exp $

package scala.runtime;

final class BoxedIntArray(val value: Array[Int]) extends BoxedArray {

  def length: Int = value.length;

  def apply(index: Int): Object = BoxedInt.box(value(index));

  def update(index: Int, elem: Object): Unit = { 
    value(index) = elem.asInstanceOf[BoxedNumber].intValue() 
  }

  def unbox(elemTag: String): Object = value;

  override def equals(other: Any) =
    value == other ||
    other.isInstanceOf[BoxedIntArray] && value == other.asInstanceOf[BoxedIntArray].value;

  override def hashCode(): Int = value.hashCode();
}

