/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2005, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: TypeAll.java,v 1.3 2005/04/28 16:28:36 michelou Exp $

package scala.runtime.types;

import scala.runtime.RunTime;
import scala.Type;
import scala.Array;

public class TypeAll extends SpecialType {
    public boolean isInstance(Object o) {
        assert Statistics.incInstanceOf();
        return false;
    }

    public boolean isSubType(Type that) {
        return true;
    }

    public String toString() { return "scala.All"; }
    public int hashCode() { return 0xAAAAAAAA; }

    // Make TypeAll a serializable singleton
    public static TypeAll INSTANCE = new TypeAll();
    protected TypeAll() { /* exists only to that instantiation */ }
    private Object readResolve() { return INSTANCE; }
}
