<?php

##################################################
#
# Copyright (c) 2004-2005 James Hunt and the OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Exponent is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU
# General Public License along with Exponent; if
# not, write to:
#
# Free Software Foundation, Inc.,
# 59 Temple Place,
# Suite 330,
# Boston, MA 02111-1307  USA
#
# $Id: index.php,v 1.6.2.2 2005/05/07 04:12:36 filetreefrog Exp $
##################################################

ob_start();

// If we do not have a not_configured file, the user has already gone through the installer once.
// Pop them back to the main page.
if (!file_exists('not_configured')) {
	header('Location: ../index.php');
	exit('This Exponent Site has already been configured.');
}

// NOT SURE WHAT THIS IS FOR
if (isset($_POST['c'])) {
	define("DB_BACKEND",$_POST['c']['db_engine']);
}


define('SCRIPT_EXP_RELATIVE','install/');
define('SCRIPT_FILENAME','index.php');
include_once('../pathos.php');
		
if (!isset($_REQUEST['page'])) {
	$_REQUEST['page'] = 'welcome';
}
$page = $_REQUEST['page'];

$page_image = '';
$page_text = '';
switch ($page) {
	case 'sanity':
		$page_image = 'sanity';
		$page_text = 'Exponent requires that several permissions be set correctly in order to operate.  Sanity checks are being run right now to ensure that the web server directory you wish to install Exponent in is suitable.<br /><br />If something fails, please <a href="#" onClick="return pop(\'sanity\');">read about each sanity check</a> for an explanation of what exactly the installer is checking for, and how to fix it.';
		break;
	case 'dbconfig':
		$page_image = 'database';
		$page_text = 'In order to best manage your content, Exponent stores it in a relational database.  Configuring your database connection properly is the most important step in setting up your new website.<br /><br />Due to security reasons, you or your web server administrator will have to create an empty database.  For information on how to create the database, click <a href="" onClick="return pop(\'db_create\');">here</a>.  Optionally, you may choose to use a pre-existing database.  For information on using an existing database and what it entails, click <a href="" onClick="return pop(\'db_existing\');">here</a>.';
		break;
	case 'dbcheck':
		$page_image = 'database';
		$page_text = 'The Exponent Install Wizard will now check to make sure that the database configuration information you provided is valid.';
		break;
	case 'admin_user':
		$page_image = 'account';
		$page_text = 'The Exponent Administrator account is the most important account in the whole installation.  The Administrator has access to every feature of the software, and controls all content and configuration.';
		break;
	case 'upgrade_version':
		$page_image = 'system';
		$page_text = 'Choose which version you want to upgrade.';
		break;
	case 'upgrade':
		$page_image = 'system';
		$page_text = 'Exponent is now upgrading the database definitions.';
		break;
	default:
		$page_image = '';
		break;
}

?>
<html>
<head>
	<title>Exponent Install Wizard</title>
	<link rel="stylesheet" href="style.css" />
	<script type="text/javascript">
	
	function pop(page) {
		url = "popup.php?page="+page;
		window.open(url,"pop","height=400,width=600,title=no,titlebar=no,scrollbars=yes");
		return false;
	}
	
	</script>
	<style type="text/css">
		div#main2 {
			background-image: url(images/mainbar_03.png);
			background-repeat: repeat-y;
			<?php if ($page_image != '') { ?>
			padding-left: 95px;
			<?php } else { ?>
			padding-left: 15px;
			<?php } ?>
			padding-right: 15px;
		}
		
		div#sidebar {
			padding-top: 70px;
			background-image: url(images/<?php echo $page_image; ?>.png);
			background-repeat: no-repeat;
		}
	</style>
</head>
<body>
	<div id="installer">
		<?php if ($page_image != '') { ?>
		<div id="side">
			<div id="side1"><!-- Empty div for background-images on CSS-capable browsers --></div>
			<div id="side2">
				<div id="sidebar" class="bodytext">
					<!--
					<h1 class="noncss">Sidebar Title</h1>
					Modo, vel pertineo genitus, exputo abbas enim in vulputate paulatim, adsum duis. Turpis vulputate at, delenit sino vel in odio vel. Fere velit letalis luctus macto consequat te eros bene adipiscing, dolus. Te aptent qui erat at patria sed diam velit ymo mara, verto ut ventosus. Scisco, feugiat consequat valde aptent probo ulciscor sudo metuo accumsan indoles ea feugiat. 
					-->
					<?php echo $page_text; ?>
				</div>
			</div>
			<div id="side3"><!-- Empty div for background-images on CSS-capable browsers --></div>
		</div>
		<?php } ?>
		<div id="main">
			<div id="main1"><!-- Empty div for background-images on CSS-capable browsers --></div>
			<div id="main2" class="bodytext">
				<h1 id="maintitle"><span class="noncss">Exponent Installer</span></h1>
				<!--
				<h2 id="subtitle"><span>Welcome to the Exponent Installer</span></h2>
				Eros autem validus vero, quidne accumsan nulla, praesent. Virtus, iriure gemino minim valetudo sed ventosus imputo. Veniam in velit, lenis, pertineo dolore conventio autem, dolore defui vindico. Blandit vero abigo dignissim verto pala esse nostrud, minim. Commoveo tation iustum et, feugait aptent. Si natu, ad ut, commodo multo consequat. Neque delenit ex inhibeo autem occuro te patria in illum accumsan. 
				<br /><br />
				Importunus luptatum demoveo singularis blandit letalis zelus minim commodo. 
				<br /><br />
				Voco in ea, wisi camur, pertineo ad. Iustum acsi imputo utrum illum lobortis praemitto sudo fere os sit. Eu abigo odio, patria exputo qui imputo hendrerit mara delenit eligo damnum feugait ventosus facilisi. Feugait neo vulputate velit nostrud luptatum sudo iaceo, minim. Comis regula reprobo consectetuer probo quidne. 
				<br /><br />
				Ne probo inhibeo facilisis suscipit autem odio abico et, enim torqueo. Eum consequat, et praesent capto veniam nulla ulciscor nostrud pertineo volutpat. Exerci jugis pala dolor vero duis refoveo premo. Esca commodo, regula occuro eros transverbero delenit, feugiat adipiscing delenit ullamcorper illum defui. Abbas os imputo macto molior, et quis nostrud adipiscing te jumentum accumsan ventosus haero caecus. Augue vereor, consequat conventio ut iusto premo bis nimis. 
				<br /><br />
				Aptent praesent laoreet, autem ut nostrud antehabeo ut euismod pecus. Huic letatio iaceo occuro si aliquam jumentum torqueo nonummy. Jugis cui refoveo neo quod sed esca nunc patria. Mara modo bene, eum ut wisi minim, veniam vero ingenium nisl pala quae suscipit. 
				<br /><br />
				Tego accumsan singularis venio, lobortis roto mara brevitas feugait consequat ne reprobo. Acsi odio suscipit quod aliquam vel magna pagus eros veniam adipiscing praesent. Meus, luptatum nisl exerci proprius saepius quidne enim, ut gravis praesent et veniam facilisi genitus. Luptatum delenit capto, odio eum neque ideo neo verto paratus tum abigo. 
				<br /><br />
				Ingenium mos magna accumsan quibus illum nonummy facilisi in sagaciter dignissim, elit, rusticus, mauris. Tego similis abico genitus eros ut immitto. 
				-->
				<?php
				if (file_exists('pages/'.$page.'.php')) {
					include('pages/'.$page.'.php');
				} else {
					echo 'Unknown installer page ('.$page.')';
				}
				?>
				<br />
			</div>
			<div id="main3"><!-- Empty div for background-images on CSS-capable browsers --></div>
		</div>
	</div>
</body>
</html>

<?php
ob_end_flush();
?>