<?php

##################################################
#
# Copyright (c) 2004-2005 James Hunt and the OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Exponent is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU
# General Public License along with Exponent; if
# not, write to:
#
# Free Software Foundation, Inc.,
# 59 Temple Place,
# Suite 330,
# Boston, MA 02111-1307  USA
#
# $Id: admin_confirmdeletepolicy.php,v 1.7 2005/02/19 00:32:37 filetreefrog Exp $
##################################################

if (!defined('PATHOS')) exit('');

if (pathos_permissions_check('workflow',pathos_core_makeLocation('administrationmodule'))) {

	$policy = $db->selectObject('approvalpolicy','id='.$_GET['id']);
	
	if ($policy) {

		if (!defined('SYS_WORKFLOW')) include_once(BASE.'subsystems/workflow.php');
		$infos = array();
		foreach(pathos_workflow_getInfoTables() as $table) {
			$typename = str_replace('_wf_info','',$table);
			$infos[$typename] = $db->selectObjects($table,'policy_id='.$policy->id);
			for ($i = 0; $i < count($infos[$typename]); $i++) {
				$revision = $db->selectObject($typename.'_wf_revision','wf_original='.$infos[$typename][$i]->real_id.' AND wf_major='.$infos[$typename][$i]->current_major.' AND wf_minor='.$infos[$typename][$i]->current_minor);
				$infos[$typename][$i]->title = $revision->title;
				$l = unserialize($revision->location_data);
				$mclass = $l->mod;
				$m = new $mclass();
				$infos[$typename][$i]->module = $m->name();
			}
			if (!count($infos[$typename])) unset($infos[$typename]);
		}
		
		if (count($infos)) {
			$template = new Template('workflow','_confirmpolicydelete',$loc);
			
			$template->assign('affected',$infos);
			$template->assign('policy',$policy);
			
			$template->output();
		} else {
			$db->delete('approvalpolicy','id='.$policy->id);
			$db->delete('approvalpolicyassociation','policy_id='.$policy->id);
			$db->delete('workflowaction','policy_id='.$policy->id);
			pathos_flow_redirect();
		}
	} else echo SITE_404_HTML;
} else {
	echo SITE_403_HTML;
}

?>