#corvar		correlation and variance matrices
subroutine corvar(x,n,p,y,q,var,rho)
integer n,p,q; logical var; real x(n,1),y(n,1),rho(p,1)
#x:	n by p matrix of data
#y:	n by q matrix of data
#var:	TRUE if variance, FALSE if correlation
#rho:	p by q output matrix
#NOTE= all matrices are assumed packed (dimensioned with n or p rows)

INCLUDE(stack)
integer i,j; real df,dotv,denom

call dev(x,n,n,p,x,rho) #column means removed, use rho as scratch
call dev(y,n,n,q,y,rho)
call matpt(x,n,n,p,y,n,q,rho,p) #cross-products
if(var) { # normalize
	df=float(n-1)
	if(df>0.)
		for(i=1;i<=p;i=i+1)
			for(j=1;j<=q;j=j+1)rho(i,j)=rho(i,j)/df
	else call rfill(0.,rho,p*q)
	}
else { # correlation
	ix=jstkgt(p+q,REAL)-1; iy=ix+p #scratch for std errors
	for(i=1; i<=p; i=i+1) rs(ix+i)=sqrt(dotv(x(1,i),n,x(1,i)))
	for(j=1; j<=q; j=j+1) rs(iy+j)=sqrt(dotv(y(1,j),n,y(1,j)))
	for(i=1; i<=p; i=i+1)
		for(j=1; j<=q; j=j+1) {
			denom=(rs(ix+i)*rs(iy+j))
			if(denom>0.)rho(i,j)=rho(i,j)/denom
			else NASET(rho(i,j),REAL)
			}
	call jstkrl(1)
	}
return
end
