#hp-gl device function for 7470, 7225 rotated
FUNCTION hpglv(
	width	/REAL,1,8./
	height	/REAL,1,10./
	ask	/LGL,1,TRUE/
	auto	/LGL,1,FALSE/
	color	/INT,1,0/
	speed	/REAL,1,400./
	)
STATIC(logical streq)
STRUCTURE(parms/REAL,6/)	# w,h,ask,auto,color

if( streq(TEXT(FNAME),TSTRING(hp7470v))
	| streq(TEXT(FNAME),TSTRING(hp7475v))){
	if(MISSING(width)) width=7.25
	if(MISSING(color)) color=2	# automatic
	}
else if( streq(TEXT(FNAME),TSTRING(hp7550v)) ){
	if(MISSING(width)) width=7.25
	if(MISSING(color)) color=2	# automatic
	if(MISSING(ask)) ask=FALSE
	if(MISSING(auto)) auto=!ask	# automatic frame advance
	}

parms[1]=width
parms[2]=height
if(ask) parms[3]=1; else parms[3]=0
if(auto) parms[4]=1; else parms[4]=0
parms[5]=color
parms[6]=speed/10.

DEVICE_DRIVER(hpglv)
RETURN(parms)
END
